/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.SchedulerState;
import com.github.kagkarlsson.scheduler.Waiter;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunUntilShutdown
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RunUntilShutdown.class);
    private final Runnable toRun;
    private final Waiter waitBetweenRuns;
    private final SchedulerState schedulerState;
    private final StatsRegistry statsRegistry;

    public RunUntilShutdown(Runnable toRun, Waiter waitBetweenRuns, SchedulerState schedulerState, StatsRegistry statsRegistry) {
        this.toRun = toRun;
        this.waitBetweenRuns = waitBetweenRuns;
        this.schedulerState = schedulerState;
        this.statsRegistry = statsRegistry;
    }

    @Override
    public void run() {
        while (!this.schedulerState.isShuttingDown()) {
            try {
                this.toRun.run();
            }
            catch (Throwable e) {
                LOG.error("Unhandled exception. Will keep running.", e);
                this.statsRegistry.register(StatsRegistry.SchedulerStatsEvent.UNEXPECTED_ERROR);
            }
            try {
                this.waitBetweenRuns.doWait();
            }
            catch (InterruptedException interruptedException) {
                if (this.schedulerState.isShuttingDown()) {
                    LOG.debug("Thread '{}' interrupted due to shutdown.", (Object)Thread.currentThread().getName());
                    continue;
                }
                LOG.error("Unexpected interruption of thread. Will keep running.", (Throwable)interruptedException);
                this.statsRegistry.register(StatsRegistry.SchedulerStatsEvent.UNEXPECTED_ERROR);
            }
        }
    }
}

