/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchedulerName {
    public String getName();

    public static class Hostname
    implements SchedulerName {
        private static final Logger LOG = LoggerFactory.getLogger(Hostname.class);

        @Override
        public String getName() {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LOG.warn("Failed to resolve hostname. Using dummy-name for scheduler.");
                return "failed.hostname.lookup";
            }
        }
    }

    public static class Fixed
    implements SchedulerName {
        private final String name;

        public Fixed(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

