/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.Task;
import java.util.Objects;

public final class TaskInstance {
    private final Task task;
    private final String id;

    public TaskInstance(Task task, String id) {
        this.task = task;
        this.id = id;
    }

    public String getTaskAndInstance() {
        return this.task.getName() + "_" + this.id;
    }

    public Task getTask() {
        return this.task;
    }

    public String getTaskName() {
        return this.task.getName();
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInstance that = (TaskInstance)o;
        return Objects.equals(this.task.getName(), that.task.getName()) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.task.getName(), this.id);
    }

    public String toString() {
        return "TaskInstance: task=" + this.task.getName() + ", id=" + this.id;
    }
}

