/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.RecurringTask;
import com.github.kagkarlsson.scheduler.task.Schedule;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;

public class ComposableTask {
    public static RecurringTask recurringTask(String name, Schedule schedule, final Runnable executionHandler) {
        return new RecurringTask(name, schedule){

            @Override
            public void execute(TaskInstance taskInstance, ExecutionContext executionContext) {
                executionHandler.run();
            }
        };
    }

    public static OneTimeTask onetimeTask(String name, final Runnable executionHandler) {
        return new OneTimeTask(name){

            @Override
            public void execute(TaskInstance taskInstance, ExecutionContext executionContext) {
                executionHandler.run();
            }
        };
    }

    public static Task customTask(String name, CompletionHandler completionHandler, final Runnable executionHandler) {
        return new Task(name, completionHandler, new DeadExecutionHandler.RescheduleDeadExecution()){

            @Override
            public void execute(TaskInstance taskInstance, ExecutionContext executionContext) {
                executionHandler.run();
            }
        };
    }
}

