/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.CompletionHandler;
import com.github.kagkarlsson.scheduler.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.Execution;
import com.github.kagkarlsson.scheduler.ExecutionComplete;
import com.github.kagkarlsson.scheduler.ExecutionHandler;
import com.github.kagkarlsson.scheduler.ExecutionOperations;
import com.github.kagkarlsson.scheduler.TaskInstance;

public abstract class Task
implements ExecutionHandler {
    protected final String name;
    private final CompletionHandler completionHandler;
    private final DeadExecutionHandler deadExecutionHandler;

    public Task(String name, CompletionHandler completionHandler, DeadExecutionHandler deadExecutionHandler) {
        this.name = name;
        this.completionHandler = completionHandler;
        this.deadExecutionHandler = deadExecutionHandler;
    }

    public String getName() {
        return this.name;
    }

    public TaskInstance instance(String id) {
        return new TaskInstance(this, id);
    }

    @Override
    public abstract void execute(TaskInstance var1);

    void complete(ExecutionComplete executionComplete, ExecutionOperations executionOperations) {
        this.completionHandler.complete(executionComplete, executionOperations);
    }

    void handleDeadExecution(Execution execution, ExecutionOperations executionOperations) {
        this.deadExecutionHandler.deadExecution(execution, executionOperations);
    }

    public String toString() {
        return "Task task=" + this.getName();
    }
}

