/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.Execution;
import com.github.kagkarlsson.scheduler.ExecutionOperations;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionHandler;
import com.github.kagkarlsson.scheduler.task.TaskInstance;

public abstract class Task {
    protected final String name;
    private final ExecutionHandler executionHandler;
    private final CompletionHandler completionHandler;
    private final DeadExecutionHandler deadExecutionHandler;

    public Task(String name, ExecutionHandler executionHandler, CompletionHandler completionHandler, DeadExecutionHandler deadExecutionHandler) {
        this.name = name;
        this.executionHandler = executionHandler;
        this.completionHandler = completionHandler;
        this.deadExecutionHandler = deadExecutionHandler;
    }

    public String getName() {
        return this.name;
    }

    public TaskInstance instance(String id) {
        return new TaskInstance(this, id);
    }

    public void execute(TaskInstance taskInstance) {
        this.executionHandler.execute(taskInstance);
    }

    public void complete(ExecutionComplete executionComplete, ExecutionOperations executionOperations) {
        this.completionHandler.complete(executionComplete, executionOperations);
    }

    public void handleDeadExecution(Execution execution, ExecutionOperations executionOperations) {
        this.deadExecutionHandler.deadExecution(execution, executionOperations);
    }

    public String toString() {
        return "Task task=" + this.getName();
    }
}

