/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.boot.autoconfigure;

import com.github.kagkarlsson.scheduler.boot.autoconfigure.DbSchedulerAutoConfiguration;
import com.github.kagkarlsson.scheduler.stats.MicrometerStatsRegistry;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.Task;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@AutoConfigureBefore(value={DbSchedulerAutoConfiguration.class})
@ConditionalOnProperty(value={"db-scheduler.enabled"}, matchIfMissing=true)
public class DbSchedulerMetricsAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DbSchedulerMetricsAutoConfiguration.class);
    private final List<Task<?>> configuredTasks;

    public DbSchedulerMetricsAutoConfiguration(List<Task<?>> configuredTasks) {
        this.configuredTasks = configuredTasks;
    }

    @ConditionalOnClass(value={MeterRegistry.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnMissingBean(value={StatsRegistry.class})
    @Bean
    StatsRegistry micrometerStatsRegistry(MeterRegistry registry) {
        log.debug("Spring Boot Actuator and Micrometer detected. Will use: {} for StatsRegistry", (Object)registry.getClass().getName());
        return new MicrometerStatsRegistry(registry, this.configuredTasks);
    }
}

