/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.boot.autoconfigure;

import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.boot.actuator.DbSchedulerHealthIndicator;
import com.github.kagkarlsson.scheduler.boot.autoconfigure.DbSchedulerAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={HealthContributorAutoConfiguration.class})
@AutoConfigureAfter(value={HealthContributorAutoConfiguration.class, DbSchedulerAutoConfiguration.class})
public class DbSchedulerActuatorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DbSchedulerActuatorAutoConfiguration.class);

    @ConditionalOnEnabledHealthIndicator(value="db-scheduler")
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnBean(value={Scheduler.class})
    @Bean
    public HealthIndicator dbScheduler(Scheduler scheduler) {
        log.debug("Exposing health indicator for db-scheduler");
        return new DbSchedulerHealthIndicator(scheduler);
    }
}

