/*
 * Decompiled with CFR 0.152.
 */
package com.jameswarlick.teams.api.input;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.jameswarlick.teams.api.Choice;
import com.jameswarlick.teams.api.input.Input;
import com.jameswarlick.teams.api.input.Style;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonTypeName(value="MultichoiceInput")
public class MultichoiceInput
implements Input {
    private String id;
    @JsonProperty(value="isRequired")
    private Boolean required;
    private String title;
    private String value;
    private List<Choice> choices;
    @JsonProperty(value="isMultiSelect")
    private Boolean multiSelect;
    private Style style;

    public MultichoiceInput() {
    }

    public MultichoiceInput(String id, String title) {
        this.id = id;
        this.title = title;
    }

    public MultichoiceInput(String id, Boolean required, String title, String value, List<Choice> choices, Boolean multiSelect, Style style) {
        this.id = id;
        this.required = required;
        this.title = title;
        this.value = value;
        this.choices = choices;
        this.multiSelect = multiSelect;
        this.style = style;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Boolean isRequired() {
        return this.required;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public Boolean getMultiSelect() {
        return this.multiSelect;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setChoices(List<Choice> choices) {
        this.choices = choices;
    }

    public void addChoice(Choice ... choices) {
        if (null == this.choices) {
            this.choices = new ArrayList<Choice>();
        }
        for (Choice choice : choices) {
            this.choices.add(choice);
        }
    }

    public void setMultiSelect(Boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultichoiceInput that = (MultichoiceInput)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.required, that.required) && Objects.equals(this.title, that.title) && Objects.equals(this.value, that.value) && Objects.equals(this.choices, that.choices) && Objects.equals(this.multiSelect, that.multiSelect) && this.style == that.style;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.required, this.title, this.value, this.choices, this.multiSelect, this.style});
    }

    public String toString() {
        return "MultichoiceInput(id=" + this.getId() + ", required=" + this.isRequired() + ", title=" + this.getTitle() + ", value=" + this.getValue() + ", choices=" + this.getChoices() + ", multiSelect=" + this.getMultiSelect() + ", style=" + (Object)((Object)this.getStyle()) + ")";
    }

    public static MultichoiceInputBuilder builder() {
        return new MultichoiceInputBuilder();
    }

    public static class MultichoiceInputBuilder {
        private String id;
        private Boolean required;
        private String title;
        private String value;
        private List<Choice> choices;
        private Boolean multiSelect;
        private Style style;

        MultichoiceInputBuilder() {
        }

        public MultichoiceInputBuilder id(String id) {
            this.id = id;
            return this;
        }

        public MultichoiceInputBuilder required(Boolean required) {
            this.required = required;
            return this;
        }

        public MultichoiceInputBuilder title(String title) {
            this.title = title;
            return this;
        }

        public MultichoiceInputBuilder value(String value) {
            this.value = value;
            return this;
        }

        public MultichoiceInputBuilder choices(List<Choice> choices) {
            this.choices = choices;
            return this;
        }

        public MultichoiceInputBuilder addChoice(Choice ... choices) {
            if (null == this.choices) {
                this.choices = new ArrayList<Choice>();
            }
            for (Choice choice : choices) {
                this.choices.add(choice);
            }
            return this;
        }

        public MultichoiceInputBuilder multiSelect(Boolean multiSelect) {
            this.multiSelect = multiSelect;
            return this;
        }

        public MultichoiceInputBuilder style(Style style) {
            this.style = style;
            return this;
        }

        public MultichoiceInput build() {
            return new MultichoiceInput(this.id, this.required, this.title, this.value, this.choices, this.multiSelect, this.style);
        }

        public String toString() {
            return "MultichoiceInput.MultichoiceInputBuilder(id=" + this.id + ", required=" + this.required + ", title=" + this.title + ", value=" + this.value + ", choices=" + this.choices + ", multiSelect=" + this.multiSelect + ", style=" + (Object)((Object)this.style) + ")";
        }
    }
}

