/*
 * Decompiled with CFR 0.152.
 */
package com.zl.reik.dilatingdotsprogressbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.zl.reik.dilatingdotsprogressbar.DilatingDotDrawable;
import com.zl.reik.dilatingdotsprogressbar.R;
import java.util.ArrayList;
import java.util.List;

public class DilatingDotsProgressBar
extends View {
    public static final String TAG = DilatingDotsProgressBar.class.getSimpleName();
    public static final double START_DELAY_FACTOR = 0.35;
    private static final float DEFAULT_GROWTH_MULTIPLIER = 1.75f;
    private static final int MIN_SHOW_TIME = 500;
    private static final int MIN_DELAY = 500;
    private int mDotColor;
    private int mAnimationDuration;
    private int mWidthBetweenDotCenters;
    private int mNumberDots;
    private float mDotRadius;
    private float mDotScaleMultiplier;
    private float mDotMaxRadius;
    private float mHorizontalSpacing;
    private long mStartTime = -1L;
    private boolean mShouldAnimate;
    private boolean mDismissed = false;
    private ArrayList<DilatingDotDrawable> mDrawables = new ArrayList();
    private final List<Animator> mAnimations = new ArrayList<Animator>();
    private final Runnable mDelayedHide = new Runnable(){

        @Override
        public void run() {
            DilatingDotsProgressBar.this.mStartTime = -1L;
            DilatingDotsProgressBar.this.setVisibility(8);
            DilatingDotsProgressBar.this.stopAnimations();
        }
    };
    private final Runnable mDelayedShow = new Runnable(){

        @Override
        public void run() {
            if (!DilatingDotsProgressBar.this.mDismissed) {
                DilatingDotsProgressBar.this.mStartTime = System.currentTimeMillis();
                DilatingDotsProgressBar.this.setVisibility(0);
                DilatingDotsProgressBar.this.startAnimations();
            }
        }
    };

    public DilatingDotsProgressBar(Context context) {
        this(context, null);
    }

    public DilatingDotsProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DilatingDotsProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.DilatingDotsProgressBar);
        this.mNumberDots = a.getInt(R.styleable.DilatingDotsProgressBar_dd_numDots, 3);
        this.mDotRadius = a.getDimension(R.styleable.DilatingDotsProgressBar_android_radius, 8.0f);
        this.mDotColor = a.getColor(R.styleable.DilatingDotsProgressBar_android_color, -6543440);
        this.mDotScaleMultiplier = a.getFloat(R.styleable.DilatingDotsProgressBar_dd_scaleMultiplier, 1.75f);
        this.mAnimationDuration = a.getInt(R.styleable.DilatingDotsProgressBar_dd_animationDuration, 300);
        this.mHorizontalSpacing = a.getDimension(R.styleable.DilatingDotsProgressBar_dd_horizontalSpacing, 12.0f);
        a.recycle();
        this.mShouldAnimate = false;
        this.calculateMaxRadius();
        this.calculateWidthBetweenDotCenters();
        this.initDots();
        this.updateDots();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.computeMaxHeight() != (float)h || (float)w != this.computeMaxWidth()) {
            this.updateDots();
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks();
    }

    private void removeCallbacks() {
        this.removeCallbacks(this.mDelayedHide);
        this.removeCallbacks(this.mDelayedShow);
    }

    public void reset() {
        this.hideNow();
    }

    public void hide() {
        this.hide(500);
    }

    public void hide(int delay) {
        this.mDismissed = true;
        this.removeCallbacks(this.mDelayedShow);
        long diff = System.currentTimeMillis() - this.mStartTime;
        if (diff >= (long)delay || this.mStartTime == -1L) {
            this.mDelayedHide.run();
        } else if ((long)delay - diff <= 0L) {
            this.mDelayedHide.run();
        } else {
            this.postDelayed(this.mDelayedHide, (long)delay - diff);
        }
    }

    public void show() {
        this.show(500);
    }

    public void showNow() {
        this.show(0);
    }

    public void hideNow() {
        this.hide(0);
    }

    public void show(int delay) {
        this.mStartTime = -1L;
        this.mDismissed = false;
        this.removeCallbacks(this.mDelayedHide);
        if (delay == 0) {
            this.mDelayedShow.run();
        } else {
            this.postDelayed(this.mDelayedShow, delay);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.shouldAnimate()) {
            for (DilatingDotDrawable dot : this.mDrawables) {
                dot.draw(canvas);
            }
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        if (this.shouldAnimate()) {
            return this.mDrawables.contains(who);
        }
        return super.verifyDrawable(who);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension((int)this.computeMaxWidth(), (int)this.computeMaxHeight());
    }

    private float computeMaxHeight() {
        return this.mDotMaxRadius * 2.0f;
    }

    private float computeMaxWidth() {
        return this.computeWidth() + (this.mDotMaxRadius - this.mDotRadius) * 2.0f;
    }

    private float computeWidth() {
        return (this.mDotRadius * 2.0f + this.mHorizontalSpacing) * (float)this.mDrawables.size() - this.mHorizontalSpacing;
    }

    private void calculateMaxRadius() {
        this.mDotMaxRadius = this.mDotRadius * this.mDotScaleMultiplier;
    }

    private void calculateWidthBetweenDotCenters() {
        this.mWidthBetweenDotCenters = (int)(this.mDotRadius * 2.0f) + (int)this.mHorizontalSpacing;
    }

    private void initDots() {
        this.mDrawables.clear();
        this.mAnimations.clear();
        for (int i = 1; i <= this.mNumberDots; ++i) {
            DilatingDotDrawable dot = new DilatingDotDrawable(this.mDotColor, this.mDotRadius, this.mDotMaxRadius);
            dot.setCallback((Drawable.Callback)this);
            this.mDrawables.add(dot);
            ObjectAnimator growAnimator = ObjectAnimator.ofFloat((Object)((Object)dot), (String)"radius", (float[])new float[]{this.mDotRadius, this.mDotMaxRadius, this.mDotRadius});
            growAnimator.setDuration((long)this.mAnimationDuration);
            growAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            if (i == this.mNumberDots) {
                growAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        if (DilatingDotsProgressBar.this.shouldAnimate()) {
                            DilatingDotsProgressBar.this.startAnimations();
                        }
                    }
                });
            }
            growAnimator.setStartDelay((long)((i - 1) * (int)(0.35 * (double)this.mAnimationDuration)));
            this.mAnimations.add((Animator)growAnimator);
        }
    }

    private void updateDots() {
        if (this.mDotRadius <= 0.0f) {
            this.mDotRadius = (float)(this.getHeight() / 2) / this.mDotScaleMultiplier;
        }
        int left = (int)(this.mDotMaxRadius - this.mDotRadius);
        int right = (int)((float)left + this.mDotRadius * 2.0f) + 2;
        int top = 0;
        int bottom = (int)(this.mDotMaxRadius * 2.0f) + 2;
        for (int i = 0; i < this.mDrawables.size(); ++i) {
            DilatingDotDrawable dot = this.mDrawables.get(i);
            dot.setRadius(this.mDotRadius);
            dot.setBounds(left, top, right, bottom);
            ValueAnimator growAnimator = (ValueAnimator)this.mAnimations.get(i);
            growAnimator.setFloatValues(new float[]{this.mDotRadius, this.mDotRadius * this.mDotScaleMultiplier, this.mDotRadius});
            left += this.mWidthBetweenDotCenters;
            right += this.mWidthBetweenDotCenters;
        }
    }

    protected void startAnimations() {
        this.mShouldAnimate = true;
        for (Animator anim : this.mAnimations) {
            anim.start();
        }
    }

    protected void stopAnimations() {
        this.mShouldAnimate = false;
        this.removeCallbacks();
        for (Animator anim : this.mAnimations) {
            anim.cancel();
        }
    }

    protected boolean shouldAnimate() {
        return this.mShouldAnimate;
    }

    public void setDotRadius(float radius) {
        this.reset();
        this.mDotRadius = radius;
        this.calculateMaxRadius();
        this.calculateWidthBetweenDotCenters();
        this.setupDots();
    }

    public void setDotSpacing(float horizontalSpacing) {
        this.reset();
        this.mHorizontalSpacing = horizontalSpacing;
        this.calculateWidthBetweenDotCenters();
        this.setupDots();
    }

    public void setGrowthSpeed(int growthSpeed) {
        this.reset();
        this.mAnimationDuration = growthSpeed;
        this.setupDots();
    }

    public void setNumberOfDots(int numDots) {
        this.reset();
        this.mNumberDots = numDots;
        this.setupDots();
    }

    public void setDotScaleMultpiplier(float multplier) {
        this.reset();
        this.mDotScaleMultiplier = multplier;
        this.calculateMaxRadius();
        this.setupDots();
    }

    public void setDotColor(int color) {
        this.mDotColor = color;
        for (DilatingDotDrawable dot : this.mDrawables) {
            dot.setColor(this.mDotColor);
        }
    }

    private void setupDots() {
        this.initDots();
        this.updateDots();
        this.showNow();
    }

    public int getDotGrowthSpeed() {
        return this.mAnimationDuration;
    }

    public float getDotRadius() {
        return this.mDotRadius;
    }

    public float getHorizontalSpacing() {
        return this.mHorizontalSpacing;
    }

    public int getNumberOfDots() {
        return this.mNumberDots;
    }

    public float getDotScaleMultiplier() {
        return this.mDotScaleMultiplier;
    }
}

