/*
 * Decompiled with CFR 0.152.
 */
package com.zl.reik.dilatingdotsprogressbar;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

public class DilatingDotDrawable
extends Drawable {
    private static final String TAG = DilatingDotDrawable.class.getSimpleName();
    private Paint mPaint = new Paint(1);
    private float radius;
    private float maxRadius;
    final Rect mDirtyBounds = new Rect(0, 0, 0, 0);

    public DilatingDotDrawable(int color, float radius, float maxRadius) {
        this.mPaint.setColor(color);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.radius = radius;
        this.setMaxRadius(maxRadius);
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        canvas.drawCircle((float)bounds.centerX(), (float)bounds.centerY(), this.radius - 1.0f, this.mPaint);
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mPaint.getAlpha()) {
            this.mPaint.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
        this.invalidateSelf();
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.invalidateSelf();
    }

    public float getRadius() {
        return this.radius;
    }

    public int getIntrinsicWidth() {
        return (int)(this.maxRadius * 2.0f) + 2;
    }

    public int getIntrinsicHeight() {
        return (int)(this.maxRadius * 2.0f) + 2;
    }

    public void setMaxRadius(float maxRadius) {
        this.maxRadius = maxRadius;
        this.mDirtyBounds.bottom = (int)(maxRadius * 2.0f) + 2;
        this.mDirtyBounds.right = (int)(maxRadius * 2.0f) + 2;
    }

    public Rect getDirtyBounds() {
        return this.mDirtyBounds;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mDirtyBounds.offsetTo(bounds.left, bounds.top);
    }
}

