/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.jsfr.json.JsonParserAdapter;
import org.jsfr.json.JsonSaxHandler;
import org.jsfr.json.JsonSimpleHandlerAdapter;
import org.jsfr.json.NonBlockingParser;
import org.jsfr.json.ResumableParser;
import org.jsfr.json.SurfingContext;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;

public class JsonSimpleParser
implements JsonParserAdapter {
    public static final JsonSimpleParser INSTANCE = new JsonSimpleParser();

    private JsonSimpleParser() {
    }

    public void parse(Reader reader, SurfingContext context) {
        this.parseImpl(reader, context);
    }

    private void parseImpl(Reader reader, SurfingContext context) {
        JSONParser parser = new JSONParser();
        try {
            parser.parse(reader, (ContentHandler)new JsonSimpleHandlerAdapter((JsonSaxHandler)context));
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
        }
    }

    public void parse(String json, SurfingContext context) {
        this.parseImpl(new StringReader(json), context);
    }

    public void parse(InputStream inputStream, SurfingContext context) {
        this.parseImpl(new InputStreamReader(inputStream, context.getConfig().getParserCharset()), context);
    }

    public ResumableParser createResumableParser(Reader reader, SurfingContext context) {
        throw new UnsupportedOperationException("Unsupported");
    }

    public ResumableParser createResumableParser(String json, SurfingContext context) {
        throw new UnsupportedOperationException("Unsupported");
    }

    public ResumableParser createResumableParser(InputStream json, SurfingContext context) {
        throw new UnsupportedOperationException("Unsupported");
    }

    public NonBlockingParser createNonBlockingParser(SurfingContext context) {
        throw new UnsupportedOperationException("Unsupported");
    }
}

