/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.async.NonBlockingJsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.jsfr.json.AbstractPrimitiveHolder;
import org.jsfr.json.JsonParserAdapter;
import org.jsfr.json.NonBlockingParser;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.ResumableParser;
import org.jsfr.json.StaticPrimitiveHolder;
import org.jsfr.json.SurfingContext;
import org.jsfr.json.provider.JsonProvider;

public class JacksonParser
implements JsonParserAdapter {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    public static final JacksonParser INSTANCE = new JacksonParser(JSON_FACTORY);
    private JsonFactory factory;
    private FormatSchema formatSchema;

    public JacksonParser(JsonFactory factory) {
        this.factory = factory;
    }

    public JacksonParser(JsonFactory factory, FormatSchema formatSchema) {
        this.factory = factory;
        this.formatSchema = formatSchema;
    }

    public void parse(Reader reader, SurfingContext context) {
        this.createResumableParser(reader, context).parse();
    }

    public void parse(String json, SurfingContext context) {
        this.createResumableParser(json, context).parse();
    }

    public void parse(InputStream inputStream, SurfingContext context) {
        this.createResumableParser(inputStream, context).parse();
    }

    public ResumableParser createResumableParser(Reader reader, SurfingContext context) {
        try {
            JsonParser jp = this.factory.createParser(reader);
            return this.createResumableParser(jp, context);
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            return null;
        }
    }

    public ResumableParser createResumableParser(String json, SurfingContext context) {
        try {
            JsonParser jp = this.factory.createParser(json);
            return this.createResumableParser(jp, context);
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            return null;
        }
    }

    public ResumableParser createResumableParser(InputStream json, SurfingContext context) {
        try {
            JsonParser jp = this.factory.createParser(json);
            return this.createResumableParser(jp, context);
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            return null;
        }
    }

    public NonBlockingParser createNonBlockingParser(SurfingContext context) {
        try {
            NonBlockingJsonParser jp = (NonBlockingJsonParser)this.factory.createNonBlockingByteArrayParser();
            if (this.formatSchema != null) {
                jp.setSchema(this.formatSchema);
            }
            return new JacksonNonblockingParser(jp, context);
        }
        catch (IOException e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException((Exception)e);
            return null;
        }
    }

    private JacksonResumableParser createResumableParser(JsonParser jp, SurfingContext context) {
        if (this.formatSchema != null) {
            jp.setSchema(this.formatSchema);
        }
        return new JacksonResumableParser(jp, context);
    }

    private static class JacksonResumableParser
    implements ResumableParser {
        private JsonParser jsonParser;
        SurfingContext context;
        private AbstractPrimitiveHolder stringHolder;
        private AbstractPrimitiveHolder longHolder;
        private AbstractPrimitiveHolder doubleHolder;
        private StaticPrimitiveHolder staticHolder;

        JacksonResumableParser(final JsonParser jsonParser, SurfingContext context) {
            this.jsonParser = jsonParser;
            this.context = context;
            final JsonProvider jsonProvider = context.getConfig().getJsonProvider();
            this.stringHolder = new AbstractPrimitiveHolder(context.getConfig()){

                public Object doGetValue() throws IOException {
                    return jsonProvider.primitive(jsonParser.getText());
                }

                public void doSkipValue() {
                }
            };
            this.longHolder = new AbstractPrimitiveHolder(context.getConfig()){

                public Object doGetValue() throws IOException {
                    if (jsonParser.getNumberType() == JsonParser.NumberType.BIG_INTEGER) {
                        return jsonProvider.primitive(jsonParser.getBigIntegerValue());
                    }
                    return jsonProvider.primitive(jsonParser.getLongValue());
                }

                public void doSkipValue() {
                }
            };
            this.doubleHolder = new AbstractPrimitiveHolder(context.getConfig()){

                public Object doGetValue() throws IOException {
                    return jsonProvider.primitive(jsonParser.getDoubleValue());
                }

                public void doSkipValue() {
                }
            };
            this.staticHolder = new StaticPrimitiveHolder();
        }

        public boolean resume() {
            try {
                if (!this.context.isPaused()) {
                    return false;
                }
                this.context.resume();
                this.doPare();
                return true;
            }
            catch (Exception e) {
                this.context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
                return false;
            }
        }

        public void parse() {
            this.context.startJSON();
            try {
                this.doPare();
            }
            catch (Exception e) {
                this.context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            }
        }

        void doPare() throws IOException {
            JsonProvider jsonProvider = this.context.getConfig().getJsonProvider();
            block14: while (!this.context.shouldBreak()) {
                JsonToken token = this.jsonParser.nextToken();
                if (token == null) {
                    this.context.endJSON();
                    break;
                }
                switch (token) {
                    case NOT_AVAILABLE: {
                        this.context.pause();
                        continue block14;
                    }
                    case START_OBJECT: {
                        this.context.startObject();
                        continue block14;
                    }
                    case END_OBJECT: {
                        this.context.endObject();
                        continue block14;
                    }
                    case START_ARRAY: {
                        this.context.startArray();
                        continue block14;
                    }
                    case END_ARRAY: {
                        this.context.endArray();
                        continue block14;
                    }
                    case FIELD_NAME: {
                        this.context.startObjectEntry(this.jsonParser.getCurrentName());
                        continue block14;
                    }
                    case VALUE_STRING: {
                        this.stringHolder.init();
                        this.context.primitive((PrimitiveHolder)this.stringHolder);
                        this.stringHolder.skipValue();
                        continue block14;
                    }
                    case VALUE_NUMBER_INT: {
                        this.longHolder.init();
                        this.context.primitive((PrimitiveHolder)this.longHolder);
                        this.longHolder.skipValue();
                        continue block14;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        this.doubleHolder.init();
                        this.context.primitive((PrimitiveHolder)this.doubleHolder);
                        this.doubleHolder.skipValue();
                        continue block14;
                    }
                    case VALUE_TRUE: {
                        this.context.primitive((PrimitiveHolder)this.staticHolder.withValue(jsonProvider.primitive(true)));
                        continue block14;
                    }
                    case VALUE_FALSE: {
                        this.context.primitive((PrimitiveHolder)this.staticHolder.withValue(jsonProvider.primitive(false)));
                        continue block14;
                    }
                    case VALUE_NULL: {
                        this.context.primitive((PrimitiveHolder)this.staticHolder.withValue(jsonProvider.primitiveNull()));
                        continue block14;
                    }
                }
                throw new IllegalStateException("Unexpected token");
            }
            if (this.context.getConfig().isCloseParserOnStop() && this.context.isStopped()) {
                this.jsonParser.close();
            }
        }
    }

    private static class JacksonNonblockingParser
    extends JacksonResumableParser
    implements NonBlockingParser {
        private NonBlockingJsonParser nonBlockingJsonParser;

        JacksonNonblockingParser(NonBlockingJsonParser jsonParser, SurfingContext context) {
            super((JsonParser)jsonParser, context);
            this.nonBlockingJsonParser = jsonParser;
        }

        public boolean feed(byte[] bytes, int start, int end) {
            try {
                if (this.nonBlockingJsonParser.needMoreInput() && !this.context.isStopped()) {
                    this.nonBlockingJsonParser.feedInput(bytes, start, end);
                    if (this.context.isPaused()) {
                        this.context.resume();
                        this.doPare();
                    } else {
                        this.parse();
                    }
                    return true;
                }
            }
            catch (IOException e) {
                this.context.getConfig().getErrorHandlingStrategy().handleParsingException((Exception)e);
            }
            return false;
        }

        public void endOfInput() {
            this.nonBlockingJsonParser.endOfInput();
            this.resume();
        }
    }
}

