/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.jsfr.json.exception.JsonSurfingException;
import org.jsfr.json.provider.JsonProvider;

public class JacksonProvider
implements JsonProvider<ObjectNode, ArrayNode, JsonNode> {
    public static final JacksonProvider INSTANCE = new JacksonProvider();
    private ObjectMapper om;
    private JsonNodeFactory factory;

    public JacksonProvider() {
        this(new ObjectMapper());
    }

    public JacksonProvider(ObjectMapper om) {
        this.om = om;
        this.factory = om.getNodeFactory();
    }

    public ObjectNode createObject() {
        return this.factory.objectNode();
    }

    public ArrayNode createArray() {
        return this.factory.arrayNode();
    }

    public void put(ObjectNode object, String key, JsonNode value) {
        object.set(key, value);
    }

    public void add(ArrayNode array, JsonNode value) {
        array.add(value);
    }

    public Object resolve(ObjectNode object, String key) {
        return object.get(key);
    }

    public Object resolve(ArrayNode array, int index) {
        return array.get(index);
    }

    public JsonNode primitive(boolean value) {
        return this.factory.booleanNode(value);
    }

    public JsonNode primitive(int value) {
        return this.factory.numberNode(value);
    }

    public JsonNode primitive(double value) {
        return this.factory.numberNode(value);
    }

    public JsonNode primitive(long value) {
        return this.factory.numberNode(value);
    }

    public JsonNode primitive(String value) {
        return this.factory.textNode(value);
    }

    public JsonNode primitiveNull() {
        return this.factory.nullNode();
    }

    public <T> T cast(JsonNode value, Class<T> tClass) {
        try {
            if (this.om.canDeserialize(this.om.getTypeFactory().constructType(tClass))) {
                return (T)this.om.treeToValue((TreeNode)value, tClass);
            }
            return tClass.cast(value);
        }
        catch (JsonProcessingException e) {
            throw new JsonSurfingException((Throwable)e);
        }
    }
}

