/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.jsfr.json.provider.JsonProvider;

public class GsonProvider
implements JsonProvider<JsonObject, JsonArray, JsonElement> {
    public static final GsonProvider INSTANCE = new GsonProvider();
    private Gson internalGson;

    public GsonProvider() {
        this(new GsonBuilder().create());
    }

    public GsonProvider(Gson internalGson) {
        this.internalGson = internalGson;
    }

    public JsonObject createObject() {
        return new JsonObject();
    }

    public JsonArray createArray() {
        return new JsonArray();
    }

    public void put(JsonObject object, String key, JsonElement value) {
        object.add(key, value);
    }

    public void add(JsonArray array, JsonElement value) {
        array.add(value);
    }

    public Object resolve(JsonObject object, String key) {
        return object.get(key);
    }

    public Object resolve(JsonArray array, int index) {
        return array.get(index);
    }

    public JsonElement primitive(boolean value) {
        return new JsonPrimitive(Boolean.valueOf(value));
    }

    public JsonElement primitive(int value) {
        return new JsonPrimitive((Number)value);
    }

    public JsonElement primitive(double value) {
        return new JsonPrimitive((Number)value);
    }

    public JsonElement primitive(long value) {
        return new JsonPrimitive((Number)value);
    }

    public JsonElement primitive(String value) {
        return new JsonPrimitive(value);
    }

    public JsonElement primitiveNull() {
        return JsonNull.INSTANCE;
    }

    public <T> T cast(JsonElement value, Class<T> tClass) {
        if (this.internalGson.getAdapter(tClass) != null) {
            return (T)this.internalGson.fromJson(value, tClass);
        }
        return tClass.cast(value);
    }
}

