/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.jsfr.json.JsonProvider;

public class GsonProvider
implements JsonProvider<JsonObject, JsonArray, JsonElement> {
    private static final Gson DEFAULT_GSON = new GsonBuilder().create();

    public JsonObject createObject() {
        return new JsonObject();
    }

    public JsonArray createArray() {
        return new JsonArray();
    }

    public boolean isObject(Object object) {
        return object instanceof JsonObject;
    }

    public boolean isArray(Object array) {
        return array instanceof JsonArray;
    }

    public void consumeObjectEntry(JsonObject object, String key, JsonElement value) {
        object.add(key, value);
    }

    public void consumeArrayElement(JsonArray array, JsonElement value) {
        array.add(value);
    }

    public JsonElement primitive(boolean value) {
        return new JsonPrimitive(Boolean.valueOf(value));
    }

    public JsonElement primitive(int value) {
        return new JsonPrimitive((Number)value);
    }

    public JsonElement primitive(double value) {
        return new JsonPrimitive((Number)value);
    }

    public JsonElement primitive(String value) {
        return new JsonPrimitive(value);
    }

    public JsonElement primitiveNull() {
        return JsonNull.INSTANCE;
    }

    public <T> T cast(JsonElement value, Class<T> tClass) {
        if (DEFAULT_GSON.getAdapter(tClass) != null) {
            return (T)DEFAULT_GSON.fromJson(value, tClass);
        }
        return (T)value;
    }
}

