/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.JSONLexerBase;
import com.alibaba.fastjson.parser.JSONReaderScanner;
import com.alibaba.fastjson.parser.JSONScanner;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jsfr.json.JsonParserAdapter;
import org.jsfr.json.NonBlockingParser;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.ResumableParser;
import org.jsfr.json.StaticPrimitiveHolder;
import org.jsfr.json.SurfingContext;

public class FastJsonParser
implements JsonParserAdapter {
    public static final FastJsonParser INSTANCE = new FastJsonParser();

    private FastJsonParser() {
    }

    public void parse(Reader reader, SurfingContext context) {
        this.createResumableParser(reader, context).parse();
    }

    public void parse(String json, SurfingContext context) {
        this.createResumableParser(json, context).parse();
    }

    public void parse(InputStream inputStream, SurfingContext context) {
        this.createResumableParser(inputStream, context).parse();
    }

    public ResumableParser createResumableParser(Reader reader, SurfingContext context) {
        return new FastJsonResumableParser((JSONLexerBase)new JSONReaderScanner(reader), context, new StaticPrimitiveHolder());
    }

    public ResumableParser createResumableParser(String json, SurfingContext context) {
        return new FastJsonResumableParser((JSONLexerBase)new JSONScanner(json), context, new StaticPrimitiveHolder());
    }

    public ResumableParser createResumableParser(InputStream json, SurfingContext context) {
        return new FastJsonResumableParser((JSONLexerBase)new JSONReaderScanner((Reader)new InputStreamReader(json, context.getConfig().getParserCharset())), context, new StaticPrimitiveHolder());
    }

    public NonBlockingParser createNonBlockingParser(SurfingContext context) {
        throw new UnsupportedOperationException("Unsupported");
    }

    private static class FastJsonResumableParser
    implements ResumableParser {
        private JSONLexerBase lexer;
        private SurfingContext context;
        private StaticPrimitiveHolder staticPrimitiveHolder;

        public FastJsonResumableParser(JSONLexerBase lexer, SurfingContext context, StaticPrimitiveHolder staticPrimitiveHolder) {
            this.lexer = lexer;
            this.context = context;
            this.staticPrimitiveHolder = staticPrimitiveHolder;
        }

        public void parse() {
            this.context.startJSON();
            this.doParse();
        }

        public boolean resume() {
            try {
                if (!this.context.isPaused()) {
                    return false;
                }
                this.context.resume();
                this.doParse();
                return true;
            }
            catch (Exception e) {
                this.context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
                return false;
            }
        }

        private void doParse() {
            try {
                String tempString = null;
                block16: while (!this.lexer.isEOF() && !this.context.shouldBreak()) {
                    this.lexer.nextToken();
                    int token = this.lexer.token();
                    if (tempString != null) {
                        if (token == 17) {
                            this.context.startObjectEntry(tempString);
                        } else {
                            this.context.primitive((PrimitiveHolder)this.staticPrimitiveHolder.withValue((Object)tempString));
                        }
                        tempString = null;
                    }
                    switch (token) {
                        case 9: 
                        case 16: 
                        case 17: 
                        case 21: 
                        case 22: {
                            continue block16;
                        }
                        case 14: {
                            this.context.startArray();
                            continue block16;
                        }
                        case 15: {
                            this.context.endArray();
                            continue block16;
                        }
                        case 12: {
                            this.context.startObject();
                            continue block16;
                        }
                        case 13: {
                            this.context.endObject();
                            continue block16;
                        }
                        case 2: {
                            this.context.primitive((PrimitiveHolder)this.staticPrimitiveHolder.withValue((Object)this.lexer.longValue()));
                            continue block16;
                        }
                        case 3: {
                            this.context.primitive((PrimitiveHolder)this.staticPrimitiveHolder.withValue((Object)this.lexer.doubleValue()));
                            continue block16;
                        }
                        case 4: 
                        case 18: {
                            tempString = this.lexer.stringVal();
                            continue block16;
                        }
                        case 8: 
                        case 23: {
                            this.context.primitive((PrimitiveHolder)this.staticPrimitiveHolder.withValue(null));
                            continue block16;
                        }
                        case 6: {
                            this.context.primitive((PrimitiveHolder)this.staticPrimitiveHolder.withValue((Object)true));
                            continue block16;
                        }
                        case 7: {
                            this.context.primitive((PrimitiveHolder)this.staticPrimitiveHolder.withValue((Object)false));
                            continue block16;
                        }
                        case 20: {
                            this.context.endJSON();
                            continue block16;
                        }
                    }
                    throw new JSONException("syntax error, " + this.lexer.info());
                }
                if (tempString != null) {
                    this.context.primitive((PrimitiveHolder)this.staticPrimitiveHolder.withValue(tempString));
                }
                if (this.context.getConfig().isCloseParserOnStop() && this.context.isStopped()) {
                    this.lexer.close();
                }
            }
            catch (Exception e) {
                this.context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            }
        }
    }
}

