/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.modelbuild;

import com.github.jsontemplate.jsonbuild.JsonBuilder;
import com.github.jsontemplate.jsonbuild.JsonNode;
import com.github.jsontemplate.modelbuild.BasePropertyDeclaration;
import com.github.jsontemplate.modelbuild.TypeSpec;
import com.github.jsontemplate.modelbuild.handler.DefaultBuildHandler;
import com.github.jsontemplate.valueproducer.IValueProducer;
import java.util.Map;

final class ArrayPropertyDeclaration
extends BasePropertyDeclaration {
    ArrayPropertyDeclaration(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public void buildJsonTemplate(JsonBuilder builder, Map<String, IValueProducer> producerMap, Map<String, JsonNode> typeMap, Map<String, JsonNode> variableMap, String defaultTypeName, DefaultBuildHandler defaultHandler) {
        JsonNode jsonNode;
        if (this.parent == null) {
            builder.createArray();
        } else if (builder.inObject()) {
            builder.putArray(this.propertyName);
        } else if (builder.inArray()) {
            builder.addArray();
        }
        this.buildChildrenJsonTemplate(builder, producerMap, typeMap, variableMap, defaultTypeName, defaultHandler);
        if (this.typeSpec.getTypeName() == null) {
            TypeSpec ancestorTypeSpec = this.findAncestorTypeSpec(defaultTypeName);
            this.typeSpec.setTypeName(ancestorTypeSpec.getTypeName());
        }
        if ((jsonNode = this.buildNodeFromProducer(producerMap)) == null) {
            jsonNode = typeMap.get(this.typeSpec.getTypeName());
        }
        if (jsonNode == null) {
            jsonNode = defaultHandler.handle(this.typeSpec.getTypeName());
        }
        this.setArrayInfo(builder.peekArrayNode(), jsonNode);
        builder.end();
    }

    @Override
    public void applyVariablesToParameters(Map<String, Object> variableMap) {
        this.properties.forEach(p -> p.applyVariablesToParameters(variableMap));
    }
}

