/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.valueproducer;

import com.github.jsontemplate.jsonbuild.JsonBooleanNode;
import com.github.jsontemplate.jsonbuild.JsonFloatNode;
import com.github.jsontemplate.jsonbuild.JsonIntegerNode;
import com.github.jsontemplate.jsonbuild.JsonNode;
import com.github.jsontemplate.jsonbuild.JsonNullNode;
import com.github.jsontemplate.jsonbuild.JsonStringNode;
import com.github.jsontemplate.valueproducer.AbstractValueProducer;

public class SmartValueProducer
extends AbstractValueProducer<JsonNode> {
    public static final String TYPE_NAME = "smart";
    private static final String NULL = "null";

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public JsonNode produce() {
        return new JsonNullNode();
    }

    @Override
    public JsonNode produce(String value) {
        if (this.isNull(value)) {
            return new JsonNullNode();
        }
        Boolean parsedBoolean = this.parseBoolean(value);
        if (parsedBoolean != null) {
            return new JsonBooleanNode(() -> parsedBoolean);
        }
        Integer parsedInteger = this.parseInteger(value);
        if (parsedInteger != null) {
            return new JsonIntegerNode(() -> parsedInteger);
        }
        Float parsedFloat = this.parseFloat(value);
        if (parsedFloat != null) {
            return new JsonFloatNode(() -> parsedFloat);
        }
        return new JsonStringNode(() -> value);
    }

    private boolean isNull(String value) {
        return NULL.equalsIgnoreCase(value);
    }

    private Boolean parseBoolean(String value) {
        if (Boolean.TRUE.toString().equalsIgnoreCase(value) || Boolean.FALSE.toString().equalsIgnoreCase(value)) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    private Integer parseInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Float parseFloat(String value) {
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

