/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.valueproducer;

import com.github.jsontemplate.jsonbuild.JsonStringNode;
import com.github.jsontemplate.valueproducer.AbstractValueProducer;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Ipv6ValueProducer
extends AbstractValueProducer<JsonStringNode> {
    public static final String TYPE_NAME = "ipv6";
    private static final String LETTERS = "0123456789abcdef";
    private Random random = new Random();

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public JsonStringNode produce() {
        return new JsonStringNode(this::produceIp);
    }

    protected String produceIp() {
        return IntStream.range(0, 8).mapToObj(i -> this.produceGroup()).collect(Collectors.joining(":"));
    }

    private String produceGroup() {
        int length = LETTERS.length();
        char[] group = new char[]{LETTERS.charAt(this.random.nextInt(length)), LETTERS.charAt(this.random.nextInt(length)), LETTERS.charAt(this.random.nextInt(length)), LETTERS.charAt(this.random.nextInt(length))};
        return new String(group);
    }
}

