/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.valueproducer;

import com.github.jsontemplate.jsonbuild.JsonIntegerNode;
import com.github.jsontemplate.jsonbuild.supplier.ListParamSupplier;
import com.github.jsontemplate.valueproducer.AbstractValueProducer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class IntegerValueProducer
extends AbstractValueProducer<JsonIntegerNode> {
    public static final String TYPE_NAME = "i";
    private static final int ZERO = 0;
    private static final int ONE_HUNDRED = 100;

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public JsonIntegerNode produce() {
        return new JsonIntegerNode(() -> this.randomIntInRange(this.getDefaultMin(), this.getDefaultMax()));
    }

    @Override
    public JsonIntegerNode produce(String value) {
        int parsedInt = Integer.parseInt(value);
        return new JsonIntegerNode(() -> parsedInt);
    }

    @Override
    public JsonIntegerNode produce(List<String> valueList) {
        List parsedValueList = valueList.stream().map(Integer::parseInt).collect(Collectors.toList());
        return new JsonIntegerNode((Supplier<Integer>)new ListParamSupplier<Integer>(parsedValueList));
    }

    @Override
    public JsonIntegerNode produce(Map<String, String> paramMap) {
        HashMap<String, String> copyParamMap = new HashMap<String, String>(paramMap);
        Integer min = this.pickIntegerParam(copyParamMap, "min");
        Integer max = this.pickIntegerParam(copyParamMap, "max");
        this.validateParamMap(copyParamMap);
        if (min != null && max != null) {
            this.shouldBeInAscOrder(min, max, "min", "max");
            return new JsonIntegerNode(() -> this.randomIntInRange(min, max));
        }
        if (min != null) {
            return new JsonIntegerNode(() -> this.randomIntInRange(min, this.getDefaultMax(min)));
        }
        if (max != null) {
            return new JsonIntegerNode(() -> this.randomIntInRange(this.getDefaultMin(max), max));
        }
        return this.produce();
    }

    protected int getDefaultMax() {
        return 100;
    }

    protected int getDefaultMin() {
        return 0;
    }

    protected int getDefaultMax(int min) {
        return min + 100;
    }

    protected int getDefaultMin(int max) {
        return max - 100;
    }
}

