/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.valueproducer;

import com.github.jsontemplate.jsonbuild.JsonFloatNode;
import com.github.jsontemplate.jsonbuild.supplier.ListParamSupplier;
import com.github.jsontemplate.valueproducer.AbstractValueProducer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FloatValueProducer
extends AbstractValueProducer<JsonFloatNode> {
    public static final String TYPE_NAME = "f";
    private static final float ONE_HUNDRED = 100.0f;

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public JsonFloatNode produce() {
        return new JsonFloatNode(() -> Float.valueOf(new Random().nextFloat() * this.getDefaultRange()));
    }

    @Override
    public JsonFloatNode produce(String value) {
        float parsedFloat = Float.parseFloat(value);
        return new JsonFloatNode(() -> Float.valueOf(parsedFloat));
    }

    @Override
    public JsonFloatNode produce(List<String> valueList) {
        List parsedValueList = valueList.stream().map(Float::parseFloat).collect(Collectors.toList());
        return new JsonFloatNode((Supplier<Float>)new ListParamSupplier<Float>(parsedValueList));
    }

    @Override
    public JsonFloatNode produce(Map<String, String> paramMap) {
        HashMap<String, String> copyParamMap = new HashMap<String, String>(paramMap);
        Float min = this.pickFloatParam(copyParamMap, "min");
        Float max = this.pickFloatParam(copyParamMap, "max");
        this.validateParamMap(copyParamMap);
        if (min != null && max != null) {
            this.shouldBeInAscOrder(min.floatValue(), max.floatValue(), "min", "max");
            return new JsonFloatNode(() -> Float.valueOf(this.randomFloatInRange(min.floatValue(), max.floatValue())));
        }
        if (min != null) {
            return new JsonFloatNode(() -> Float.valueOf(this.randomFloatInRange(min.floatValue(), this.getDefaultMax(min.floatValue()))));
        }
        if (max != null) {
            return new JsonFloatNode(() -> Float.valueOf(this.randomFloatInRange(this.getDefaultMin(max.floatValue()), max.floatValue())));
        }
        return this.produce();
    }

    protected float getDefaultMax(float min) {
        return min + 100.0f;
    }

    protected float getDefaultMin(float max) {
        return max - 100.0f;
    }

    protected float getDefaultRange() {
        return 100.0f;
    }
}

