/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.modelbuild;

import com.github.jsontemplate.antlr4.JsonTemplateAntlrBaseListener;
import com.github.jsontemplate.antlr4.JsonTemplateAntlrParser;
import com.github.jsontemplate.modelbuild.BasePropertyDeclaration;
import com.github.jsontemplate.modelbuild.Token;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.antlr.v4.runtime.tree.ParseTree;

public final class JsonTemplateTreeListener
extends JsonTemplateAntlrBaseListener {
    private Deque<BasePropertyDeclaration> curStack;
    private boolean inArrayParamSpec;
    private boolean inPropertyVariableWrapper;
    private BasePropertyDeclaration jsonRoot;
    private List<BasePropertyDeclaration> typeDefinitionList = new ArrayList<BasePropertyDeclaration>();

    public BasePropertyDeclaration getJsonRoot() {
        return this.jsonRoot;
    }

    public List<BasePropertyDeclaration> getTypeDefinitionList() {
        return this.typeDefinitionList;
    }

    @Override
    public void enterTemplatePart(JsonTemplateAntlrParser.TemplatePartContext ctx) {
        this.curStack = new LinkedList<BasePropertyDeclaration>();
    }

    @Override
    public void exitTemplatePart(JsonTemplateAntlrParser.TemplatePartContext ctx) {
        BasePropertyDeclaration peek = this.curStack.peek();
        if (this.curStack.peekLast().isTypeDefinition()) {
            this.typeDefinitionList.add(peek);
        } else if (this.jsonRoot == null) {
            this.jsonRoot = peek;
        } else {
            throw new IllegalStateException("Detected multiple json roots");
        }
    }

    @Override
    public void enterTypeDefinition(JsonTemplateAntlrParser.TypeDefinitionContext ctx) {
        BasePropertyDeclaration typeRoot = new BasePropertyDeclaration();
        typeRoot.markAsTypeDefinition();
        this.curStack.push(typeRoot);
        BasePropertyDeclaration typeBody = new BasePropertyDeclaration();
        typeRoot.addProperty(typeBody);
        this.curStack.push(typeBody);
    }

    @Override
    public void enterPairProperty(JsonTemplateAntlrParser.PairPropertyContext ctx) {
        this.curStack.push(new BasePropertyDeclaration());
    }

    @Override
    public void exitPairProperty(JsonTemplateAntlrParser.PairPropertyContext ctx) {
        BasePropertyDeclaration pop = this.curStack.pop();
        this.curStack.peek().addProperty(pop);
    }

    @Override
    public void enterArrayParamSpec(JsonTemplateAntlrParser.ArrayParamSpecContext ctx) {
        this.inArrayParamSpec = true;
    }

    @Override
    public void exitArrayParamSpec(JsonTemplateAntlrParser.ArrayParamSpecContext ctx) {
        this.inArrayParamSpec = false;
    }

    @Override
    public void enterMapParam(JsonTemplateAntlrParser.MapParamContext ctx) {
        String key = ctx.getChild(0).getText();
        String value = this.stripRawText(ctx.getChild(2).getText());
        BasePropertyDeclaration peek = this.curStack.peek();
        if (this.inArrayParamSpec) {
            peek.getArrayTypeSpec().getMapParam().put(key, value);
        } else {
            peek.getTypeSpec().getMapParam().put(key, value);
        }
    }

    @Override
    public void enterListParams(JsonTemplateAntlrParser.ListParamsContext ctx) {
        IntStream.range(0, ctx.getChildCount()).mapToObj(arg_0 -> ((JsonTemplateAntlrParser.ListParamsContext)ctx).getChild(arg_0)).map(ParseTree::getText).filter(text -> !",".equals(text)).map(this::stripRawText).forEach(param -> {
            BasePropertyDeclaration peek = this.curStack.peek();
            if (this.inArrayParamSpec) {
                peek.getArrayTypeSpec().getListParam().add((String)param);
            } else {
                peek.getTypeSpec().getListParam().add((String)param);
            }
        });
    }

    @Override
    public void enterSingleParam(JsonTemplateAntlrParser.SingleParamContext ctx) {
        BasePropertyDeclaration peek = this.curStack.peek();
        String text = this.stripRawText(ctx.getText());
        if (this.inArrayParamSpec) {
            peek.getArrayTypeSpec().setSingleParam(text);
        } else {
            peek.getTypeSpec().setSingleParam(text);
        }
    }

    @Override
    public void enterPropertyName(JsonTemplateAntlrParser.PropertyNameContext ctx) {
        this.curStack.peek().setPropertyName(ctx.getText());
    }

    @Override
    public void enterPropertyVariableWrapper(JsonTemplateAntlrParser.PropertyVariableWrapperContext ctx) {
        this.inPropertyVariableWrapper = true;
    }

    @Override
    public void exitPropertyVariableWrapper(JsonTemplateAntlrParser.PropertyVariableWrapperContext ctx) {
        this.inPropertyVariableWrapper = false;
    }

    @Override
    public void enterVariableWrapper(JsonTemplateAntlrParser.VariableWrapperContext ctx) {
        if (this.inPropertyVariableWrapper) {
            if (ctx.getChild(0) instanceof JsonTemplateAntlrParser.VariableContext) {
                this.curStack.peek().getTypeSpec().setTypeName(ctx.getText());
            } else {
                this.curStack.peek().getTypeSpec().setSingleParam(ctx.getText());
            }
        }
    }

    @Override
    public void enterTypeName(JsonTemplateAntlrParser.TypeNameContext ctx) {
        if (ctx.getParent() instanceof JsonTemplateAntlrParser.TypeDefContext) {
            this.curStack.peek().setPropertyName(ctx.getText());
        } else {
            this.curStack.peek().getTypeSpec().setTypeName(ctx.getText());
        }
    }

    @Override
    public void enterSingleProperty(JsonTemplateAntlrParser.SinglePropertyContext ctx) {
        this.curStack.push(new BasePropertyDeclaration());
    }

    @Override
    public void exitSingleProperty(JsonTemplateAntlrParser.SinglePropertyContext ctx) {
        BasePropertyDeclaration pop = this.curStack.pop();
        this.curStack.peek().addProperty(pop);
    }

    @Override
    public void enterJsonObject(JsonTemplateAntlrParser.JsonObjectContext ctx) {
        if (this.curStack.isEmpty()) {
            this.curStack.push(new BasePropertyDeclaration());
        }
        BasePropertyDeclaration pop = this.curStack.pop();
        this.curStack.push(pop.asObjectProperty());
    }

    @Override
    public void enterJsonArray(JsonTemplateAntlrParser.JsonArrayContext ctx) {
        if (this.curStack.isEmpty()) {
            this.curStack.push(new BasePropertyDeclaration());
        }
        BasePropertyDeclaration pop = this.curStack.pop();
        this.curStack.push(pop.asArrayProperty());
    }

    @Override
    public void enterItem(JsonTemplateAntlrParser.ItemContext ctx) {
        this.curStack.push(new BasePropertyDeclaration());
    }

    @Override
    public void exitItem(JsonTemplateAntlrParser.ItemContext ctx) {
        BasePropertyDeclaration pop = this.curStack.pop();
        this.curStack.peek().addProperty(pop);
    }

    private String stripRawText(String text) {
        if (text.startsWith(Token.RAW.getTag()) && text.endsWith(Token.RAW.getTag())) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }
}

