/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsontemplate.jsonbuild;

import com.github.jsontemplate.jsonbuild.JsonArrayNode;
import com.github.jsontemplate.jsonbuild.JsonNode;
import com.github.jsontemplate.jsonbuild.JsonObjectNode;
import java.util.Deque;
import java.util.LinkedList;

public final class JsonBuilder {
    private Deque<JsonNode> nodeStack = new LinkedList<JsonNode>();
    private JsonNode lastPopNode;

    public JsonBuilder createArray() {
        this.nodeStack.push(new JsonArrayNode());
        return this;
    }

    public JsonBuilder createObject() {
        this.nodeStack.push(new JsonObjectNode());
        return this;
    }

    public JsonBuilder end() {
        this.lastPopNode = this.nodeStack.pop();
        return this;
    }

    public JsonBuilder putArray(String key) {
        JsonArrayNode jsonArrayNode = new JsonArrayNode();
        ((JsonObjectNode)this.nodeStack.peek()).putNode(key, jsonArrayNode);
        this.nodeStack.push(jsonArrayNode);
        return this;
    }

    public JsonBuilder putObject(String key) {
        JsonObjectNode jsonObjectNode = new JsonObjectNode();
        ((JsonObjectNode)this.nodeStack.peek()).putNode(key, jsonObjectNode);
        this.nodeStack.push(jsonObjectNode);
        return this;
    }

    public JsonBuilder putNode(String key, JsonNode node) {
        ((JsonObjectNode)this.nodeStack.peek()).putNode(key, node);
        return this;
    }

    public JsonBuilder addNode(JsonNode node) {
        ((JsonArrayNode)this.nodeStack.peek()).addNode(node);
        return this;
    }

    public JsonBuilder pushNode(JsonNode node) {
        this.nodeStack.push(node);
        return this;
    }

    public JsonBuilder addArray() {
        JsonArrayNode jsonArrayNode = new JsonArrayNode();
        ((JsonArrayNode)this.nodeStack.peek()).addNode(jsonArrayNode);
        this.nodeStack.push(jsonArrayNode);
        return this;
    }

    public JsonBuilder addObject() {
        JsonObjectNode jsonObjectNode = new JsonObjectNode();
        ((JsonArrayNode)this.nodeStack.peek()).addNode(jsonObjectNode);
        this.nodeStack.push(jsonObjectNode);
        return this;
    }

    public boolean inObject() {
        return !this.nodeStack.isEmpty() && this.nodeStack.peek() instanceof JsonObjectNode;
    }

    public boolean inArray() {
        return !this.nodeStack.isEmpty() && this.nodeStack.peek() instanceof JsonArrayNode;
    }

    public JsonArrayNode peekArrayNode() {
        return (JsonArrayNode)this.nodeStack.peek();
    }

    public JsonNode build() {
        if (!this.nodeStack.isEmpty()) {
            return this.nodeStack.peek();
        }
        return this.lastPopNode;
    }
}

