/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.MethodContextImpl;
import com.github.jsdevel.testng.selenium.PageFactory;
import com.github.jsdevel.testng.selenium.PageFactoryProxy;
import com.github.jsdevel.testng.selenium.annotations.driverconfig.UserAgent;
import com.github.jsdevel.testng.selenium.annotations.drivers.Chrome;
import com.github.jsdevel.testng.selenium.annotations.drivers.Firefox;
import com.github.jsdevel.testng.selenium.annotations.drivers.InternetExplorer;
import com.github.jsdevel.testng.selenium.annotations.screensizes.Desktop;
import com.github.jsdevel.testng.selenium.annotations.screensizes.LargeDesktop;
import com.github.jsdevel.testng.selenium.annotations.screensizes.Phone;
import com.github.jsdevel.testng.selenium.annotations.screensizes.Tablet;
import com.github.jsdevel.testng.selenium.config.Config;
import com.github.jsdevel.testng.selenium.exceptions.MissingPageFactoryException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.anthavio.phanbedder.Phanbedder;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;

class AbsractSuiteHelpers {
    private static final File phantomBinary = Phanbedder.unpack();
    static final File SCREENSHOT_DIR = new File(Config.TMPDIR, "screenshots");

    AbsractSuiteHelpers() {
    }

    static <PF extends PageFactory> void addPageFactory(MethodContextImpl context) {
        ParameterizedType abstractSuite;
        Class<?> suite = context.method.getDeclaringClass();
        try {
            abstractSuite = (ParameterizedType)suite.getGenericSuperclass();
        }
        catch (ClassCastException e) {
            throw new MissingPageFactoryException("AbstractSuite must receive Type parameters I.E. class MySuite extends AbstractSuite<MyPageFactory>.  None were given in " + suite.getName());
        }
        Class pageFactoryClass = (Class)abstractSuite.getActualTypeArguments()[0];
        context.setPageFactory((PageFactory)PageFactoryProxy.newInstance(pageFactoryClass, context));
    }

    static void addScreensize(MethodContextImpl context) {
        Method method = context.method;
        WebDriver driver = context.getWebDriver();
        Dimension testConfiguredDimension = AbsractSuiteHelpers.getDimension(method, context);
        if (testConfiguredDimension == null) {
            try {
                testConfiguredDimension = AbsractSuiteHelpers.getDimension(ScreenSizeHelper.class.getDeclaredMethod(Config.SCREENSIZE.toLowerCase(), new Class[0]), context);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        if (testConfiguredDimension != null) {
            driver.manage().window().setSize(testConfiguredDimension);
        }
    }

    static void addUserAgent(MethodContextImpl context) {
        Method method = context.method;
        if (method.isAnnotationPresent(UserAgent.class)) {
            context.setUserAgent(method.getAnnotation(UserAgent.class).value());
        } else if (Config.USER_AGENT != null) {
            context.setUserAgent(Config.USER_AGENT);
        }
    }

    static void addWebDriver(MethodContextImpl context) {
        Method method = context.method;
        if (method.isAnnotationPresent(Chrome.class) || Config.DRIVER.equalsIgnoreCase("chrome")) {
            AbsractSuiteHelpers.addChromeDriver(context);
        } else if (method.isAnnotationPresent(Firefox.class) || Config.DRIVER.equalsIgnoreCase("firefox")) {
            AbsractSuiteHelpers.addFirefoxDriver(context);
        } else if (method.isAnnotationPresent(InternetExplorer.class) || Config.DRIVER.equalsIgnoreCase("internetexplorer")) {
            AbsractSuiteHelpers.addInternetExplorerDriver(context);
        } else {
            AbsractSuiteHelpers.addPhantomJSDriver(context);
        }
    }

    static String getTestName(Method method) {
        return method.getDeclaringClass().getName() + ":" + method.getName();
    }

    static void takeScreenshot(MethodContextImpl context) throws IOException {
        File screenshotTarget = new File(SCREENSHOT_DIR, AbsractSuiteHelpers.getTestName(context.method) + ".png");
        context.log("Saving a screenshot to " + screenshotTarget.getAbsolutePath());
        File screenshot = (File)((TakesScreenshot)context.getWebDriver()).getScreenshotAs(OutputType.FILE);
        FileUtils.copyFile((File)screenshot, (File)screenshotTarget);
    }

    private static void addChromeDriver(MethodContextImpl context) {
        ChromeDriver driver = new ChromeDriver();
        context.setWebDriver((WebDriver)driver);
    }

    private static void addFirefoxDriver(MethodContextImpl context) {
        FirefoxDriver driver = new FirefoxDriver();
        context.setWebDriver((WebDriver)driver);
    }

    private static void addInternetExplorerDriver(MethodContextImpl context) {
        InternetExplorerDriver driver = new InternetExplorerDriver();
        context.setWebDriver((WebDriver)driver);
    }

    private static void addPhantomJSDriver(MethodContextImpl context) {
        DesiredCapabilities dcaps = new DesiredCapabilities();
        String testName = AbsractSuiteHelpers.getTestName(context.method) + "-" + System.currentTimeMillis();
        dcaps.setCapability("phantomjs.binary.path", phantomBinary.getAbsolutePath());
        ArrayList<String> phantomCliArgs = new ArrayList<String>();
        phantomCliArgs.add("--web-security=false");
        phantomCliArgs.add("--ignore-ssl-errors=true");
        phantomCliArgs.add("--ssl-protocol=any");
        phantomCliArgs.add("--cookies-file=" + new File(Config.TMPDIR, "cookies-" + testName + ".txt").getAbsolutePath());
        phantomCliArgs.add("--local-storage-path=" + new File(Config.TMPDIR, "local-storage-" + testName).getAbsolutePath());
        ArrayList<String> ghostdriverCliArgs = new ArrayList<String>();
        if (!Config.DEBUG) {
            phantomCliArgs.add("--webdriver-loglevel=ERROR");
            ghostdriverCliArgs.add("--logLevel=ERROR");
            Logger.getLogger(PhantomJSDriverService.class.getName()).setLevel(Level.OFF);
        }
        dcaps.setCapability("phantomjs.cli.args", (Object)phantomCliArgs.toArray(new String[0]));
        dcaps.setCapability("phantomjs.ghostdriver.cli.args", (Object)ghostdriverCliArgs.toArray(new String[0]));
        if (context.getUserAgent() != null) {
            dcaps.setCapability("phantomjs.page.settings.userAgent", context.getUserAgent());
        }
        PhantomJSDriver driver = new PhantomJSDriver((Capabilities)dcaps);
        context.setWebDriver((WebDriver)driver);
    }

    private static Dimension getDimension(Method method, MethodContextImpl context) {
        if (method.isAnnotationPresent(Phone.class)) {
            Phone dimension = method.getAnnotation(Phone.class);
            context.setScreensize(dimension);
            return new Dimension(dimension.width(), dimension.height());
        }
        if (method.isAnnotationPresent(Tablet.class)) {
            Tablet dimension = method.getAnnotation(Tablet.class);
            context.setScreensize(dimension);
            return new Dimension(dimension.width(), dimension.height());
        }
        if (method.isAnnotationPresent(Desktop.class)) {
            Desktop dimension = method.getAnnotation(Desktop.class);
            context.setScreensize(dimension);
            return new Dimension(dimension.width(), dimension.height());
        }
        if (method.isAnnotationPresent(LargeDesktop.class)) {
            LargeDesktop dimension = method.getAnnotation(LargeDesktop.class);
            context.setScreensize(dimension);
            return new Dimension(dimension.width(), dimension.height());
        }
        return null;
    }

    static {
        SCREENSHOT_DIR.mkdirs();
    }

    private static class ScreenSizeHelper {
        private ScreenSizeHelper() {
        }

        @Phone
        static void phone() {
        }

        @Tablet
        static void tablet() {
        }

        @Desktop
        static void deskop() {
        }

        @LargeDesktop
        static void lagedeskop() {
        }
    }
}

