/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.AbstractPage;
import com.github.jsdevel.testng.selenium.MethodContext;
import com.github.jsdevel.testng.selenium.PageFactory;
import com.github.jsdevel.testng.selenium.exceptions.PageInstantiationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

class PageFactoryProxy<PF extends PageFactory>
implements InvocationHandler {
    private final MethodContext context;
    private final Class<PF> pageFactoryClass;

    PageFactoryProxy(Class<PF> pageFactoryClass, MethodContext context) {
        this.context = context;
        this.pageFactoryClass = pageFactoryClass;
    }

    static <PF> PF newInstance(Class<PF> pageFactoryClass, MethodContext context) {
        return (PF)Proxy.newProxyInstance(pageFactoryClass.getClassLoader(), new Class[]{pageFactoryClass}, new PageFactoryProxy<PF>(pageFactoryClass, context));
    }

    @Override
    public Object invoke(Object proxy, Method pageFactoryMethod, Object[] args) throws Throwable {
        Object page = pageFactoryMethod.getReturnType().newInstance();
        if (!(page instanceof AbstractPage)) {
            throw new PageInstantiationException("Pages returned from " + this.pageFactoryClass.getName() + " must return instances of " + AbstractPage.class.getName());
        }
        AbstractPage abstractPage = (AbstractPage)page;
        abstractPage.initialize(this.getDesiredUrl(pageFactoryMethod, args), this.context);
        return page;
    }

    private String getDesiredUrl(Method method, Object[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        ArrayList<String> stringArgs = new ArrayList<String>();
        for (Object arg : args) {
            if (!(arg instanceof String)) continue;
            stringArgs.add((String)arg);
        }
        switch (stringArgs.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return stringArgs.get(0) == null ? "" : (String)stringArgs.get(0);
            }
        }
        throw new PageInstantiationException("Multiple String arguments are not allowed in " + method.getName());
    }
}

