/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.MethodContext;
import com.github.jsdevel.testng.selenium.Page;
import com.github.jsdevel.testng.selenium.PageFactory;
import com.github.jsdevel.testng.selenium.exceptions.PageInitializationException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.WebDriver;

public abstract class AbstractPage<P extends AbstractPage, PF extends PageFactory>
implements Page<P, PF> {
    private MethodContext context;
    private String endpoint;
    private URL initialUrl;
    private PF pageFactory;
    private WebDriver webDriver;

    @Override
    public final MethodContext getContext() {
        return this.context;
    }

    @Override
    public final String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public final URL getInitialUrl() {
        return this.initialUrl;
    }

    @Override
    public final Page<P, PF> getPage() {
        return this;
    }

    @Override
    public final PF getPageFactory() {
        return this.pageFactory;
    }

    @Override
    public final WebDriver getWebDriver() {
        return this.webDriver;
    }

    protected void handlePageInitialized() {
    }

    void initialize(String desiredUrl, MethodContext<PF> context) {
        this.context = context;
        this.endpoint = context.getEndpoint();
        this.pageFactory = context.getPageFactory();
        this.webDriver = context.getWebDriver();
        this.initialUrl = this.getUrl(this.ofAbsoluteUrl(desiredUrl, this.endpoint));
        context.log("Initializing " + this.getClass().getSimpleName());
        if (this.webDriver.getCurrentUrl().equals("about:blank")) {
            context.log("Detected about:blank.");
            context.log("Navigating to " + this.initialUrl);
            this.webDriver.get(this.initialUrl.toString());
        }
        context.log("Instantiating any WebElement or List<WebElement> fields with org.openqa.selenium.support.PageFactory");
        org.openqa.selenium.support.PageFactory.initElements((WebDriver)context.getWebDriver(), (Object)this);
        context.log("Page initialized.  Calling handlePageInitialized().");
        this.handlePageInitialized();
        this.initialUrl = this.getUrl(this.webDriver.getCurrentUrl());
        if (!this.isPageViewableFrom(this.initialUrl)) {
            context.log(this.getClass().getName() + " was not viewable from " + this.initialUrl.toString() + ".  Throwing an exception.");
            throw new PageInitializationException(this.getClass().getName() + " can not be viewed from " + this.initialUrl.toString());
        }
    }

    private String ofAbsoluteUrl(String proposedUrl, String defaultProtocolHost) {
        if (proposedUrl == null) {
            return defaultProtocolHost;
        }
        if (proposedUrl.matches("^[a-zA-Z]+://.+")) {
            return proposedUrl;
        }
        return defaultProtocolHost + "/" + proposedUrl.replaceFirst("^/+", "");
    }

    private URL getUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new PageInitializationException(e);
        }
    }
}

