/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.pickimage.resolver;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import com.vansuita.pickimage.R;
import com.vansuita.pickimage.bundle.PickSetup;
import com.vansuita.pickimage.enums.EPickType;
import com.vansuita.pickimage.keep.Keep;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class IntentResolver {
    public static final int REQUESTER = 99;
    public static final String SAVE_FILE_PATH_TAG = "savePath";
    private AppCompatActivity activity;
    private PickSetup setup;
    private Intent galleryIntent;
    private Intent cameraIntent;
    private File saveFile;

    public IntentResolver(AppCompatActivity activity, PickSetup setup, Bundle savedInstanceState) {
        this.activity = activity;
        this.setup = setup;
        if (savedInstanceState != null) {
            this.onRestoreInstanceState(savedInstanceState);
        }
    }

    private Intent loadSystemPackages(Intent intent) {
        List resInfo = this.activity.getPackageManager().queryIntentActivities(intent, 0x100000);
        if (!resInfo.isEmpty()) {
            String packageName = ((ResolveInfo)resInfo.get((int)0)).activityInfo.packageName;
            intent.setPackage(packageName);
        }
        return intent;
    }

    public boolean isCamerasAvailable() {
        String feature = "android.hardware.camera";
        if (Build.VERSION.SDK_INT >= 17) {
            feature = "android.hardware.camera.any";
        }
        return this.activity.getPackageManager().hasSystemFeature(feature);
    }

    private Intent getCameraIntent() {
        if (this.cameraIntent == null) {
            this.cameraIntent = this.setup.isVideo() ? new Intent("android.media.action.VIDEO_CAPTURE") : new Intent("android.media.action.IMAGE_CAPTURE");
            this.cameraIntent.putExtra("output", (Parcelable)this.cameraUriForProvider());
            this.applyProviderPermission();
        }
        return this.cameraIntent;
    }

    public void launchCamera(Fragment listener) {
        if (this.getCameraIntent().resolveActivity(this.activity.getPackageManager()) != null) {
            this.cameraFile().delete();
            Intent chooser = Intent.createChooser((Intent)this.getCameraIntent(), (CharSequence)this.setup.getCameraChooserTitle());
            listener.startActivityForResult(chooser, 99);
        }
    }

    private void applyProviderPermission() {
        List resInfoList = this.activity.getPackageManager().queryIntentActivities(this.cameraIntent, 65536);
        for (ResolveInfo resolveInfo : resInfoList) {
            String packageName = resolveInfo.activityInfo.packageName;
            this.activity.grantUriPermission(packageName, this.cameraUriForProvider(), 3);
        }
    }

    private File cameraFile() {
        String fileName;
        File directory;
        if (this.saveFile != null) {
            return this.saveFile;
        }
        if (this.setup.isCameraToPictures()) {
            ApplicationInfo applicationInfo = this.activity.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            String appName = stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : this.activity.getString(stringId);
            directory = new File(this.activity.getExternalFilesDir(Environment.DIRECTORY_PICTURES), appName);
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            fileName = this.setup.isVideo() ? timeStamp + ".mp4" : timeStamp + ".jpg";
        } else {
            directory = new File(this.activity.getFilesDir(), "picked");
            fileName = this.activity.getString(R.string.image_file_name);
        }
        directory.mkdirs();
        this.saveFile = new File(directory, fileName);
        Log.i((String)"File-PickImage", (String)this.saveFile.getAbsolutePath());
        return this.saveFile;
    }

    public Uri cameraUri() {
        return Uri.fromFile((File)this.cameraFile());
    }

    private String getAuthority() {
        return this.activity.getApplication().getPackageName() + this.activity.getString(R.string.provider_package);
    }

    private Uri cameraUriForProvider() {
        try {
            return FileProvider.getUriForFile((Context)this.activity, (String)this.getAuthority(), (File)this.cameraFile());
        }
        catch (Exception e) {
            if (e.getMessage().contains("ProviderInfo.loadXmlMetaData")) {
                throw new Error(this.activity.getString(R.string.wrong_authority));
            }
            throw e;
        }
    }

    private Intent getGalleryIntent() {
        if (this.galleryIntent == null) {
            this.galleryIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            if (this.setup.isVideo()) {
                this.galleryIntent.setType(this.activity.getString(R.string.video_content_type));
            } else {
                this.galleryIntent.setType(this.activity.getString(R.string.image_content_type));
            }
        }
        return this.galleryIntent;
    }

    public void launchGallery(Fragment listener, String title) {
        Intent intent = Intent.createChooser((Intent)this.getGalleryIntent(), (CharSequence)title);
        try {
            listener.startActivityForResult(intent, 99);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)listener.getContext(), (CharSequence)listener.getContext().getString(R.string.gallery_app_not_found), (int)0).show();
        }
    }

    public void launchSystemChooser(Fragment listener) {
        ArrayList<Intent> intentList = new ArrayList<Intent>();
        boolean showCamera = EPickType.CAMERA.inside(this.setup.getPickTypes());
        boolean showGallery = EPickType.GALLERY.inside(this.setup.getPickTypes());
        if (showGallery) {
            intentList.add(this.getGalleryIntent());
        }
        if (showCamera && this.isCamerasAvailable() && !this.wasCameraPermissionDeniedForever()) {
            intentList.add(this.getCameraIntent());
        }
        if (intentList.size() > 0) {
            Intent chooserIntent = Intent.createChooser((Intent)((Intent)intentList.remove(intentList.size() - 1)), (CharSequence)this.setup.getTitle());
            chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", intentList.toArray(new Parcelable[0]));
            listener.startActivityForResult(chooserIntent, 99);
        }
    }

    private String[] getAllPermissionsNeeded() {
        return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
    }

    public boolean wasCameraPermissionDeniedForever() {
        if (Keep.with((Context)this.activity).neverAskedForPermissionYet()) {
            return false;
        }
        for (String permission2 : this.getAllPermissionsNeeded()) {
            if (ContextCompat.checkSelfPermission((Context)this.activity, (String)permission2) != -1 || ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)permission2)) continue;
            return true;
        }
        return false;
    }

    public boolean requestCameraPermissions(Fragment listener) {
        return this.requestPermissions(listener, this.getAllPermissionsNeeded());
    }

    public boolean requestGalleryPermissions(Fragment listener) {
        return this.requestPermissions(listener, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public boolean requestPermissions(Fragment listener, String ... permissionsNeeded) {
        ArrayList<String> list = new ArrayList<String>();
        for (String permission2 : permissionsNeeded) {
            if (ContextCompat.checkSelfPermission((Context)this.activity, (String)permission2) != -1) continue;
            list.add(permission2);
        }
        if (list.isEmpty()) {
            return true;
        }
        listener.requestPermissions(list.toArray(new String[list.size()]), 99);
        return false;
    }

    public boolean fromCamera(Intent data) {
        return data == null || data.getData() == null || data.getData().toString().contains(this.cameraFile().toString()) || data.getData().toString().toString().contains("to_be_replaced");
    }

    public AppCompatActivity getActivity() {
        return this.activity;
    }

    private void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        String saveFilePath = savedInstanceState.getString(SAVE_FILE_PATH_TAG);
        if (saveFilePath != null) {
            this.saveFile = new File(saveFilePath);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.saveFile != null) {
            outState.putString(SAVE_FILE_PATH_TAG, this.saveFile.getAbsolutePath());
        }
    }
}

