/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.pickimage.async;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import com.vansuita.pickimage.bean.PickResult;
import com.vansuita.pickimage.bundle.PickSetup;
import com.vansuita.pickimage.enums.EPickType;
import com.vansuita.pickimage.img.ImageHandler;
import com.vansuita.pickimage.resolver.IntentResolver;
import java.lang.ref.WeakReference;

public class AsyncImageResult
extends AsyncTask<Intent, Void, PickResult> {
    private WeakReference<IntentResolver> weakIntentResolver;
    private WeakReference<PickSetup> weakSetup;
    private WeakReference<OnFinish> weakOnFinish;

    public AsyncImageResult(Activity activity, PickSetup setup) {
        this.weakIntentResolver = new WeakReference<IntentResolver>(new IntentResolver(activity));
        this.weakSetup = new WeakReference<PickSetup>(setup);
    }

    public AsyncImageResult setOnFinish(OnFinish onFinish) {
        this.weakOnFinish = new WeakReference<OnFinish>(onFinish);
        return this;
    }

    protected PickResult doInBackground(Intent ... intents) {
        PickResult result = new PickResult();
        IntentResolver resolver = (IntentResolver)this.weakIntentResolver.get();
        if (resolver == null) {
            result.setError(new Error("Activity was destroyed, can't handle pick image result."));
            return result;
        }
        try {
            Intent data = intents[0];
            boolean fromCamera = resolver.fromCamera(data);
            ImageHandler imageHandler = ImageHandler.with((Context)resolver.getActivity()).setup((PickSetup)this.weakSetup.get()).provider(fromCamera ? EPickType.CAMERA : EPickType.GALLERY).uri(fromCamera ? resolver.cameraUri() : data.getData());
            result.setUri(imageHandler.getUri()).setPath(imageHandler.getUriPath()).setBitmap(imageHandler.decode());
            return result;
        }
        catch (Exception e) {
            result.setError(e);
            return result;
        }
    }

    protected void onPostExecute(PickResult r) {
        OnFinish onFinish;
        if (this.weakOnFinish != null && (onFinish = (OnFinish)this.weakOnFinish.get()) != null) {
            onFinish.onFinish(r);
        }
    }

    public static interface OnFinish {
        public void onFinish(PickResult var1);
    }
}

