/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.library;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.CardView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
import com.vansuita.library.IPickResult;
import com.vansuita.library.PickSetup;
import com.vansuita.library.R;
import com.vansuita.library.Util;
import java.io.Serializable;

public class PickImageDialog
extends DialogFragment {
    private static final String SETUP_TAG = "SETUP_TAG";
    private static final int FROM_CAMERA = 1;
    private static final int FROM_GALLERY = 2;
    private CardView cvRoot;
    private TextView tvTitle;
    private TextView tvCamera;
    private TextView tvGallery;
    private TextView tvCancel;
    private IPickResult.IPickResultBitmap bitmapListener;
    private IPickResult.IPickResultUri uriListener;
    private IPickResult.IPickClick clickListener;
    private PickSetup setup;

    public static PickImageDialog newInstance(PickSetup setup) {
        PickImageDialog frag = new PickImageDialog();
        Bundle args = new Bundle();
        args.putSerializable(SETUP_TAG, (Serializable)setup);
        frag.setArguments(args);
        return frag;
    }

    public static PickImageDialog on(AppCompatActivity activity, PickSetup setup) {
        PickImageDialog d = PickImageDialog.newInstance(setup);
        d.show(activity.getSupportFragmentManager(), "dialog");
        return d;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof IPickResult.IPickResultBitmap) {
            this.bitmapListener = (IPickResult.IPickResultBitmap)context;
        }
        if (context instanceof IPickResult.IPickResultUri) {
            this.uriListener = (IPickResult.IPickResultUri)context;
        }
        if (context instanceof IPickResult.IPickClick) {
            this.clickListener = (IPickResult.IPickClick)context;
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.cvRoot = (CardView)inflater.inflate(R.layout.dialog, null, false);
        this.bindView();
        this.setUp();
        this.bindListeners();
        return this.cvRoot;
    }

    private void setUp() {
        this.getDialog().getWindow().requestFeature(1);
        this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setup = (PickSetup)this.getArguments().getSerializable(SETUP_TAG);
        this.cvRoot.setCardBackgroundColor(this.setup.getBackgroundColor());
        this.tvTitle.setTextColor(this.setup.getTitleColor());
        this.tvCamera.setTextColor(this.setup.getOptionsColor());
        this.tvGallery.setTextColor(this.setup.getOptionsColor());
        this.tvTitle.setText((CharSequence)this.setup.getTitle());
        this.setDimAcount(this.setup.getDimAmount());
    }

    private void bindView() {
        this.tvTitle = (TextView)this.cvRoot.findViewById(R.id.title);
        this.tvCamera = (TextView)this.cvRoot.findViewById(R.id.camera);
        this.tvGallery = (TextView)this.cvRoot.findViewById(R.id.gallery);
        this.tvCancel = (TextView)this.cvRoot.findViewById(R.id.cancel);
    }

    private void setDimAcount(float dim) {
        if (Build.VERSION.SDK_INT >= 14) {
            this.getDialog().getWindow().setDimAmount(dim);
        } else {
            WindowManager.LayoutParams lp = this.getDialog().getWindow().getAttributes();
            lp.dimAmount = dim;
            this.getDialog().getWindow().setAttributes(lp);
        }
    }

    private void bindListeners() {
        this.tvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PickImageDialog.this.dismiss();
            }
        });
        this.tvCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PickImageDialog.this.clickListener != null) {
                    PickImageDialog.this.clickListener.onCameraClick();
                } else {
                    Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                    if (takePictureIntent.resolveActivity(PickImageDialog.this.getActivity().getPackageManager()) != null) {
                        PickImageDialog.this.startActivityForResult(takePictureIntent, 1);
                    }
                }
            }
        });
        this.tvGallery.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PickImageDialog.this.clickListener != null) {
                    PickImageDialog.this.clickListener.onGaleryClick();
                } else {
                    Intent intent = new Intent("android.intent.action.PICK");
                    intent.setType("image/*");
                    PickImageDialog.this.startActivityForResult(intent, 2);
                }
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            this.dismiss();
            if (this.bitmapListener != null) {
                try {
                    Bitmap bitmap = null;
                    if (requestCode == 1) {
                        bitmap = (Bitmap)data.getExtras().get("data");
                        if (this.setup.isFlipped()) {
                            bitmap = Util.flip(bitmap);
                        }
                    } else if (requestCode == 2) {
                        bitmap = Util.decodeUri(data.getData(), (Context)this.getActivity());
                    }
                    this.bitmapListener.onPickImageResult(bitmap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.uriListener != null) {
                this.uriListener.onPickImageResult(data.getData());
            }
        }
    }
}

