/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.gaussianblur;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.widget.ImageView;
import java.lang.ref.WeakReference;

public class GaussianBlur {
    private final int DEFAULT_RADIUS = 25;
    private final float DEFAULT_MAX_SIZE = 400.0f;
    private Context context;
    private int radius;
    private float maxImageSize;
    private boolean noScaleDown = false;

    public static GaussianBlur with(Context context) {
        return new GaussianBlur(context);
    }

    public GaussianBlur(Context context) {
        this.context = context;
        this.radius(25);
        this.maxSixe(400.0f);
    }

    public Bitmap render(int res) {
        return this.render(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)res));
    }

    public Bitmap render(Bitmap bitmap) {
        RenderScript rs = RenderScript.create((Context)this.context);
        if (!this.isNoScaleDown()) {
            bitmap = this.scaleDown(bitmap);
        }
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Allocation inAlloc = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)bitmap, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)2);
        Allocation outAlloc = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)output);
        ScriptIntrinsicBlur script = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)inAlloc.getElement());
        script.setRadius((float)this.getRadius());
        script.setInput(inAlloc);
        script.forEach(outAlloc);
        outAlloc.copyTo(output);
        rs.destroy();
        return output;
    }

    public void put(Bitmap bitmap, ImageView imageView) {
        new BitmapGaussianAsync(imageView).execute(new Bitmap[]{bitmap});
    }

    public void put(int res, ImageView imageView) {
        new ResourceGaussianAsync(imageView).execute(new Integer[]{res});
    }

    public Bitmap scaleDown(int res) {
        return this.scaleDown(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)res));
    }

    public Bitmap scaleDown(Bitmap input) {
        float ratio = Math.min(this.getMaxSize() / (float)input.getWidth(), this.getMaxSize() / (float)input.getHeight());
        int width = Math.round(ratio * (float)input.getWidth());
        int height = Math.round(ratio * (float)input.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)input, (int)width, (int)height, (boolean)true);
    }

    public int getRadius() {
        return this.radius;
    }

    public GaussianBlur radius(int radius) {
        this.radius = radius;
        return this;
    }

    public float getMaxSize() {
        return this.maxImageSize;
    }

    public GaussianBlur maxSixe(float maxSize) {
        this.maxImageSize = maxSize;
        return this;
    }

    public boolean isNoScaleDown() {
        return this.noScaleDown;
    }

    public GaussianBlur noScaleDown(boolean noScaleDown) {
        this.noScaleDown = noScaleDown;
        return this;
    }

    abstract class GaussianAsync<T>
    extends AsyncTask<T, Void, Bitmap> {
        private final WeakReference<ImageView> imageViewReference;

        public GaussianAsync(ImageView imageView) {
            this.imageViewReference = new WeakReference<ImageView>(imageView);
        }

        protected void onPostExecute(Bitmap bitmap) {
            ImageView imageView;
            if (this.imageViewReference != null && bitmap != null && (imageView = (ImageView)this.imageViewReference.get()) != null) {
                imageView.setImageBitmap(bitmap);
            }
        }
    }

    class BitmapGaussianAsync
    extends GaussianAsync<Bitmap> {
        public BitmapGaussianAsync(ImageView imageView) {
            super(imageView);
        }

        protected Bitmap doInBackground(Bitmap ... params) {
            return GaussianBlur.this.render(params[0]);
        }
    }

    class ResourceGaussianAsync
    extends GaussianAsync<Integer> {
        public ResourceGaussianAsync(ImageView imageView) {
            super(imageView);
        }

        protected Bitmap doInBackground(Integer ... params) {
            return GaussianBlur.this.render(params[0]);
        }
    }
}

