/*
 * Decompiled with CFR 0.152.
 */
package snow.player.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.google.common.base.Preconditions;
import snow.player.PlaybackState;
import snow.player.Player;
import snow.player.PlayerClient;
import snow.player.audio.MusicItem;
import snow.player.util.ProgressClock;

public class LiveProgress {
    private final PlayerClient mPlayerClient;
    private final OnUpdateListener mOnUpdateListener;
    @Nullable
    private LifecycleOwner mLifecycleOwner;
    private LifecycleObserver mLifecycleObserver;
    private final ProgressClock mProgressClock;
    private Player.OnPlayingMusicItemChangeListener mOnPlayingMusicItemChangeListener;
    private Player.OnPrepareListener mOnPrepareListener;
    private PlayerClient.OnPlaybackStateChangeListener mOnPlaybackStateChangeListener;
    private Player.OnSeekCompleteListener mOnSeekCompleteListener;
    private Player.OnStalledChangeListener mOnStalledChangeListener;
    private PlayerClient.OnConnectStateChangeListener mOnConnectStateChangeListener;
    private Player.OnRepeatListener mOnRepeatListener;
    private Player.OnSpeedChangeListener mSpeedChangeListener;

    public LiveProgress(@NonNull PlayerClient playerClient, @NonNull OnUpdateListener listener) {
        this(playerClient, listener, false);
    }

    public LiveProgress(@NonNull PlayerClient playerClient, @NonNull OnUpdateListener listener, boolean countDown) {
        Preconditions.checkNotNull((Object)playerClient);
        Preconditions.checkNotNull((Object)listener);
        this.mPlayerClient = playerClient;
        this.mOnUpdateListener = listener;
        this.mProgressClock = new ProgressClock(countDown, new ProgressClock.Callback(){

            @Override
            public void onUpdateProgress(int progressSec, int durationSec) {
                LiveProgress.this.updateLiveProgress(progressSec, durationSec);
            }
        });
        this.initAllListener();
    }

    private void initAllListener() {
        this.mOnPlayingMusicItemChangeListener = new Player.OnPlayingMusicItemChangeListener(){

            @Override
            public void onPlayingMusicItemChanged(@Nullable MusicItem musicItem, int position, int playProgress) {
                LiveProgress.this.mProgressClock.cancel();
                if (musicItem == null) {
                    LiveProgress.this.updateLiveProgress(0, 0);
                    return;
                }
                LiveProgress.this.updateLiveProgress(playProgress / 1000, LiveProgress.this.getDurationSec());
            }
        };
        this.mOnPrepareListener = new Player.OnPrepareListener2(){

            @Override
            public void onPreparing() {
            }

            @Override
            public void onPrepared(int audioSessionId) {
            }

            @Override
            public void onPrepared(int audioSessionId, int duration) {
                MusicItem musicItem = LiveProgress.this.mPlayerClient.getPlayingMusicItem();
                assert (musicItem != null);
                if (musicItem.isAutoDuration()) {
                    LiveProgress.this.updateLiveProgress(LiveProgress.this.mPlayerClient.getPlayProgress() / 1000, LiveProgress.this.getDurationSec());
                }
            }
        };
        this.mOnPlaybackStateChangeListener = new PlayerClient.OnPlaybackStateChangeListener(){

            @Override
            public void onPlaybackStateChanged(PlaybackState playbackState, boolean stalled) {
                switch (playbackState) {
                    case PLAYING: {
                        if (stalled) {
                            return;
                        }
                        LiveProgress.this.mProgressClock.start(LiveProgress.this.mPlayerClient.getPlayProgress(), LiveProgress.this.mPlayerClient.getPlayProgressUpdateTime(), LiveProgress.this.mPlayerClient.getPlayingMusicItemDuration(), LiveProgress.this.mPlayerClient.getSpeed());
                        break;
                    }
                    case STOPPED: {
                        LiveProgress.this.updateLiveProgress(0);
                        LiveProgress.this.mProgressClock.cancel();
                        break;
                    }
                    case PAUSED: {
                        LiveProgress.this.updateLiveProgress(LiveProgress.this.mPlayerClient.getPlayProgress() / 1000);
                        LiveProgress.this.mProgressClock.cancel();
                        break;
                    }
                    case ERROR: {
                        LiveProgress.this.mProgressClock.cancel();
                    }
                }
            }
        };
        this.mOnSeekCompleteListener = new Player.OnSeekCompleteListener(){

            @Override
            public void onSeekComplete(int progress, long updateTime, boolean stalled) {
                LiveProgress.this.updateLiveProgress(progress / 1000);
                if (LiveProgress.this.mPlayerClient.isPlaying() && !stalled) {
                    LiveProgress.this.mProgressClock.start(progress, updateTime, LiveProgress.this.mPlayerClient.getPlayingMusicItemDuration(), LiveProgress.this.mPlayerClient.getSpeed());
                }
            }
        };
        this.mOnStalledChangeListener = new Player.OnStalledChangeListener(){

            @Override
            public void onStalledChanged(boolean stalled, int playProgress, long updateTime) {
                if (stalled) {
                    LiveProgress.this.mProgressClock.cancel();
                    return;
                }
                if (LiveProgress.this.mPlayerClient.isPlaying()) {
                    LiveProgress.this.mProgressClock.start(playProgress, updateTime, LiveProgress.this.mPlayerClient.getPlayingMusicItemDuration(), LiveProgress.this.mPlayerClient.getSpeed());
                }
            }
        };
        this.mOnConnectStateChangeListener = new PlayerClient.OnConnectStateChangeListener(){

            @Override
            public void onConnectStateChanged(boolean connected) {
                if (!connected) {
                    LiveProgress.this.mProgressClock.cancel();
                }
            }
        };
        this.mOnRepeatListener = new Player.OnRepeatListener(){

            @Override
            public void onRepeat(@NonNull MusicItem musicItem, long repeatTime) {
                LiveProgress.this.mProgressClock.start(0, repeatTime, musicItem.getDuration(), LiveProgress.this.mPlayerClient.getSpeed());
            }
        };
        this.mSpeedChangeListener = new Player.OnSpeedChangeListener(){

            @Override
            public void onSpeedChanged(float speed, int playProgress, long playProgressUpdateTime) {
                LiveProgress.this.mProgressClock.setSpeed(speed);
            }
        };
    }

    private void updateLiveProgress(int progressSec) {
        this.updateLiveProgress(progressSec, this.getDurationSec());
    }

    private void updateLiveProgress(int progressSec, int durationSec) {
        if (this.mLifecycleOwner == null) {
            this.mOnUpdateListener.onUpdate(progressSec, durationSec, ProgressClock.asText(progressSec), ProgressClock.asText(durationSec));
            return;
        }
        if (this.atLeastState(this.mLifecycleOwner)) {
            this.mOnUpdateListener.onUpdate(progressSec, durationSec, ProgressClock.asText(progressSec), ProgressClock.asText(durationSec));
        }
    }

    private boolean atLeastState(@NonNull LifecycleOwner owner) {
        return owner.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED);
    }

    private int getDurationSec() {
        return this.mPlayerClient.getPlayingMusicItemDuration() / 1000;
    }

    private void addAllListener() {
        this.mPlayerClient.addOnPlayingMusicItemChangeListener(this.mOnPlayingMusicItemChangeListener);
        this.mPlayerClient.addOnPrepareListener(this.mOnPrepareListener);
        this.mPlayerClient.addOnPlaybackStateChangeListener(this.mOnPlaybackStateChangeListener);
        this.mPlayerClient.addOnSeekCompleteListener(this.mOnSeekCompleteListener);
        this.mPlayerClient.addOnStalledChangeListener(this.mOnStalledChangeListener);
        this.mPlayerClient.addOnConnectStateChangeListener(this.mOnConnectStateChangeListener);
        this.mPlayerClient.addOnRepeatListener(this.mOnRepeatListener);
        this.mPlayerClient.addOnSpeedChangeListener(this.mSpeedChangeListener);
    }

    private void removeAllListener() {
        this.mPlayerClient.removeOnPlayingMusicItemChangeListener(this.mOnPlayingMusicItemChangeListener);
        this.mPlayerClient.removeOnPrepareListener(this.mOnPrepareListener);
        this.mPlayerClient.removeOnPlaybackStateChangeListener(this.mOnPlaybackStateChangeListener);
        this.mPlayerClient.removeOnSeekCompleteListener(this.mOnSeekCompleteListener);
        this.mPlayerClient.removeOnStalledChangeListener(this.mOnStalledChangeListener);
        this.mPlayerClient.removeOnConnectStateChangeListener(this.mOnConnectStateChangeListener);
        this.mPlayerClient.removeOnRepeatListener(this.mOnRepeatListener);
        this.mPlayerClient.removeOnSpeedChangeListener(this.mSpeedChangeListener);
    }

    private void initLifecycleObserver() {
        if (this.mLifecycleObserver != null) {
            return;
        }
        this.mLifecycleObserver = new LifecycleObserver(){

            @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
            public void onDestroy() {
                LiveProgress.this.unsubscribe();
            }
        };
    }

    public void subscribe() {
        this.subscribe(null);
    }

    public void subscribe(@Nullable LifecycleOwner owner) {
        if (owner != null && this.isDestroyed(owner)) {
            return;
        }
        this.mLifecycleOwner = owner;
        if (this.mLifecycleOwner != null) {
            this.initLifecycleObserver();
            this.mLifecycleOwner.getLifecycle().addObserver(this.mLifecycleObserver);
        }
        this.addAllListener();
    }

    private boolean isDestroyed(LifecycleOwner owner) {
        return owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED;
    }

    public void unsubscribe() {
        this.removeAllListener();
        this.mProgressClock.cancel();
        if (this.mLifecycleOwner != null) {
            this.mLifecycleOwner.getLifecycle().removeObserver(this.mLifecycleObserver);
            this.mLifecycleOwner = null;
        }
    }

    public static interface OnUpdateListener {
        public void onUpdate(int var1, int var2, String var3, String var4);
    }
}

