/*
 * Decompiled with CFR 0.152.
 */
package snow.player.helper;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;
import snow.player.audio.MusicPlayer;

public class VolumeEaseHelper {
    private final MusicPlayer mMusicPlayer;
    private final Callback mCallback;
    @Nullable
    private Disposable mStartDisposable;
    @Nullable
    private Disposable mPauseDisposable;
    @Nullable
    private Disposable mDismissQuietDisposable;
    private boolean mQuiet;

    public VolumeEaseHelper(@NonNull MusicPlayer musicPlayer, @NonNull Callback callback) {
        Preconditions.checkNotNull((Object)musicPlayer);
        Preconditions.checkNotNull((Object)callback);
        this.mMusicPlayer = musicPlayer;
        this.mCallback = callback;
    }

    public void start() {
        this.cancel();
        this.setVolume(0.0f);
        this.mCallback.start();
        this.mStartDisposable = Observable.intervalRange((long)1L, (long)20L, (long)200L, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> this.setVolume((float)aLong.longValue() * 0.05f));
    }

    public void pause() {
        this.cancel();
        if (this.mQuiet) {
            this.mCallback.pause();
            return;
        }
        this.mPauseDisposable = Observable.intervalRange((long)1L, (long)20L, (long)0L, (long)30L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> this.setVolume(1.0f - (float)aLong.longValue() * 0.05f), throwable -> {}, this.mCallback::pause);
    }

    public void quiet() {
        this.mQuiet = true;
        this.mMusicPlayer.setVolume(0.2f, 0.2f);
    }

    public void dismissQuiet() {
        this.mQuiet = false;
        if (this.mPauseDisposable != null && !this.mPauseDisposable.isDisposed()) {
            return;
        }
        this.cancel();
        this.mDismissQuietDisposable = Observable.intervalRange((long)2L, (long)20L, (long)0L, (long)30L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> this.setVolume((float)aLong.longValue() * 0.05f));
    }

    public void setVolume(float volume) {
        this.mMusicPlayer.setVolume(volume, volume);
    }

    public void cancel() {
        if (this.mStartDisposable != null) {
            this.mStartDisposable.dispose();
        }
        if (this.mPauseDisposable != null) {
            this.mPauseDisposable.dispose();
        }
        if (this.mDismissQuietDisposable != null) {
            this.mDismissQuietDisposable.dispose();
        }
    }

    public static interface Callback {
        public void start();

        public void pause();
    }
}

