/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import snow.player.PlayMode;
import snow.player.PlayerService;
import snow.player.PlayerState;
import snow.player.PlayerStateHelper;
import snow.player.appwidget.AppWidgetPlayerState;
import snow.player.audio.MusicItem;

class ServicePlayerStateHelper
extends PlayerStateHelper {
    private final Context mContext;
    private final Class<? extends PlayerService> mPlayerService;

    public ServicePlayerStateHelper(@NonNull PlayerState playerState, @NonNull Context context, @NonNull Class<? extends PlayerService> playerService) {
        super(playerState);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull(playerService);
        this.mContext = context;
        this.mPlayerService = playerService;
    }

    private void updateAppWidgetPlayerState() {
        AppWidgetPlayerState playerState = new AppWidgetPlayerState(this.getPlayerState().getPlaybackState(), this.getPlayerState().getMusicItem(), this.getPlayerState().getPlayMode(), this.getPlayerState().getSpeed(), this.getPlayerState().getPlayProgress(), this.getPlayerState().getPlayProgressUpdateTime(), this.getPlayerState().isPreparing(), this.getPlayerState().isPrepared(), this.getPlayerState().isStalled(), this.getPlayerState().getErrorMessage());
        AppWidgetPlayerState.updatePlayerState(this.mContext, this.mPlayerService, playerState);
    }

    @Override
    public void onPreparing() {
        super.onPreparing();
        this.updateAppWidgetPlayerState();
    }

    @Override
    public void onPrepared(int audioSessionId, int duration) {
        super.onPrepared(audioSessionId, duration);
        this.updateAppWidgetPlayerState();
    }

    @Override
    public void onPlay(boolean stalled, int progress, long updateTime) {
        super.onPlay(stalled, progress, updateTime);
        this.updateAppWidgetPlayerState();
    }

    @Override
    public void onPaused(int playProgress, long updateTime) {
        super.onPaused(playProgress, updateTime);
        this.updateAppWidgetPlayerState();
    }

    @Override
    public void onStopped() {
        super.onStopped();
        this.updateAppWidgetPlayerState();
    }

    @Override
    public void onStalled(boolean stalled, int playProgress, long updateTime) {
        super.onStalled(stalled, playProgress, updateTime);
        this.updateAppWidgetPlayerState();
    }

    @Override
    public void onRepeat(long repeatTime) {
        super.onRepeat(repeatTime);
        this.updateAppWidgetPlayerState();
    }

    @Override
    public void onError(int errorCode, String errorMessage) {
        super.onError(errorCode, errorMessage);
        this.updateAppWidgetPlayerState();
    }

    @Override
    public void onPlayingMusicItemChanged(@Nullable MusicItem musicItem, int position, int playProgress) {
        super.onPlayingMusicItemChanged(musicItem, position, playProgress);
        this.updateAppWidgetPlayerState();
    }

    @Override
    public void onSeekComplete(int playProgress, long updateTime, boolean stalled) {
        super.onSeekComplete(playProgress, updateTime, stalled);
        this.updateAppWidgetPlayerState();
    }

    @Override
    public void onPlayModeChanged(PlayMode playMode) {
        super.onPlayModeChanged(playMode);
        this.updateAppWidgetPlayerState();
    }

    @Override
    public void onSpeedChanged(float speed, int progress, long updateTime) {
        super.onSpeedChanged(speed, progress, updateTime);
        this.updateAppWidgetPlayerState();
    }
}

