/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import snow.player.PlayMode;
import snow.player.PlaybackState;
import snow.player.SleepTimer;
import snow.player.audio.MusicItem;

class PlayerState
implements Parcelable {
    private int playProgress;
    @Nullable
    private MusicItem musicItem;
    private int playPosition;
    private PlayMode playMode;
    private float speed;
    private int duration;
    private boolean waitPlayComplete;
    private long playProgressUpdateTime;
    private PlaybackState playbackState;
    private boolean preparing;
    private boolean prepared;
    private int audioSessionId;
    private int bufferedProgress;
    private boolean stalled;
    private int errorCode;
    private String errorMessage;
    private boolean sleepTimerStarted;
    private long sleepTimerTime;
    private long sleepTimerStartTime;
    private SleepTimer.TimeoutAction timeoutAction;
    private boolean sleepTimerEnd;
    private boolean sleepTimerTimeout;
    public static final Parcelable.Creator<PlayerState> CREATOR = new Parcelable.Creator<PlayerState>(){

        public PlayerState createFromParcel(Parcel in) {
            return new PlayerState(in);
        }

        public PlayerState[] newArray(int size) {
            return new PlayerState[size];
        }
    };

    public PlayerState() {
        this.playProgress = 0;
        this.playProgressUpdateTime = 0L;
        this.playPosition = 0;
        this.playMode = PlayMode.PLAYLIST_LOOP;
        this.speed = 1.0f;
        this.playbackState = PlaybackState.NONE;
        this.preparing = false;
        this.prepared = false;
        this.audioSessionId = 0;
        this.bufferedProgress = 0;
        this.stalled = false;
        this.errorCode = 0;
        this.errorMessage = "";
        this.sleepTimerStarted = false;
        this.sleepTimerTime = 0L;
        this.sleepTimerStartTime = 0L;
        this.timeoutAction = SleepTimer.TimeoutAction.PAUSE;
        this.duration = 0;
        this.waitPlayComplete = false;
        this.sleepTimerEnd = true;
        this.sleepTimerTimeout = false;
    }

    public PlayerState(PlayerState source) {
        this.playProgress = source.playProgress;
        this.playProgressUpdateTime = source.playProgressUpdateTime;
        if (source.musicItem != null) {
            this.musicItem = new MusicItem(source.musicItem);
        }
        this.playPosition = source.playPosition;
        this.playMode = source.playMode;
        this.speed = source.speed;
        this.playbackState = source.playbackState;
        this.preparing = source.preparing;
        this.prepared = source.prepared;
        this.audioSessionId = source.audioSessionId;
        this.bufferedProgress = source.bufferedProgress;
        this.stalled = source.stalled;
        this.errorCode = source.errorCode;
        this.errorMessage = source.errorMessage;
        this.sleepTimerStarted = source.sleepTimerStarted;
        this.sleepTimerTime = source.sleepTimerTime;
        this.sleepTimerStartTime = source.sleepTimerStartTime;
        this.timeoutAction = source.timeoutAction;
        this.duration = source.duration;
        this.waitPlayComplete = source.waitPlayComplete;
        this.sleepTimerEnd = source.sleepTimerEnd;
        this.sleepTimerTimeout = source.sleepTimerTimeout;
    }

    public int getPlayProgress() {
        return this.playProgress;
    }

    public void setPlayProgress(int playProgress) {
        if (playProgress < 0) {
            this.playProgress = 0;
            return;
        }
        this.playProgress = playProgress;
    }

    public long getPlayProgressUpdateTime() {
        return this.playProgressUpdateTime;
    }

    public void setPlayProgressUpdateTime(long updateTime) {
        this.playProgressUpdateTime = updateTime;
    }

    @Nullable
    public MusicItem getMusicItem() {
        return this.musicItem;
    }

    public void setMusicItem(@Nullable MusicItem musicItem) {
        this.musicItem = musicItem;
    }

    public int getPlayPosition() {
        return this.playPosition;
    }

    public void setPlayPosition(int playPosition) {
        if (playPosition < 0) {
            this.playPosition = 0;
            return;
        }
        this.playPosition = playPosition;
    }

    public PlayMode getPlayMode() {
        return this.playMode;
    }

    public void setPlayMode(@NonNull PlayMode playMode) {
        this.playMode = playMode;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public PlaybackState getPlaybackState() {
        return this.playbackState;
    }

    public void setPlaybackState(@NonNull PlaybackState playbackState) {
        Preconditions.checkNotNull((Object)((Object)playbackState));
        this.playbackState = playbackState;
        if (playbackState != PlaybackState.ERROR) {
            this.errorCode = 0;
            this.errorMessage = "";
        }
    }

    public boolean isPreparing() {
        return this.preparing;
    }

    public void setPreparing(boolean preparing) {
        this.preparing = preparing;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public void setAudioSessionId(int audioSessionId) {
        this.audioSessionId = audioSessionId;
    }

    public int getBufferedProgress() {
        return this.bufferedProgress;
    }

    public void setBufferedProgress(int bufferedProgress) {
        if (bufferedProgress < 0) {
            this.bufferedProgress = 0;
            return;
        }
        this.bufferedProgress = bufferedProgress;
    }

    public boolean isStalled() {
        return this.stalled;
    }

    public void setStalled(boolean stalled) {
        this.stalled = stalled;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(@NonNull String errorMessage) {
        Preconditions.checkNotNull((Object)errorMessage);
        this.errorMessage = errorMessage;
    }

    public boolean isForbidSeek() {
        if (this.musicItem == null) {
            return true;
        }
        return this.musicItem.isForbidSeek();
    }

    public boolean isSleepTimerStarted() {
        return this.sleepTimerStarted;
    }

    public void setSleepTimerStarted(boolean sleepTimerStarted) {
        this.sleepTimerStarted = sleepTimerStarted;
    }

    public long getSleepTimerTime() {
        return this.sleepTimerTime;
    }

    public void setSleepTimerTime(long time) {
        this.sleepTimerTime = time;
    }

    public long getSleepTimerStartTime() {
        return this.sleepTimerStartTime;
    }

    public void setSleepTimerStartTime(long sleepTimerStartTime) {
        this.sleepTimerStartTime = sleepTimerStartTime;
    }

    @NonNull
    public SleepTimer.TimeoutAction getTimeoutAction() {
        return this.timeoutAction;
    }

    public void setTimeoutAction(@NonNull SleepTimer.TimeoutAction action) {
        Preconditions.checkNotNull((Object)((Object)this.timeoutAction));
        this.timeoutAction = action;
    }

    public boolean isWaitPlayComplete() {
        return this.waitPlayComplete;
    }

    public void setWaitPlayComplete(boolean waitPlayComplete) {
        this.waitPlayComplete = waitPlayComplete;
    }

    public boolean isSleepTimerEnd() {
        return this.sleepTimerEnd;
    }

    public void setSleepTimerEnd(boolean sleepTimerEnd) {
        this.sleepTimerEnd = sleepTimerEnd;
    }

    public boolean isSleepTimerTimeout() {
        return this.sleepTimerTimeout;
    }

    public void setSleepTimerTimeout(boolean sleepTimerTimeout) {
        this.sleepTimerTimeout = sleepTimerTimeout;
    }

    public int getDuration() {
        if (this.musicItem == null) {
            return 0;
        }
        if (this.musicItem.isAutoDuration()) {
            return this.duration;
        }
        return this.musicItem.getDuration();
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerState)) {
            return false;
        }
        PlayerState other = (PlayerState)o;
        return Objects.equal((Object)this.playProgress, (Object)other.playProgress) && Objects.equal((Object)this.playProgressUpdateTime, (Object)other.playProgressUpdateTime) && Objects.equal((Object)this.musicItem, (Object)other.musicItem) && Objects.equal((Object)this.playPosition, (Object)other.playPosition) && Objects.equal((Object)((Object)this.playMode), (Object)((Object)other.playMode)) && Objects.equal((Object)Float.valueOf(this.speed), (Object)Float.valueOf(other.speed)) && Objects.equal((Object)((Object)this.playbackState), (Object)((Object)other.playbackState)) && Objects.equal((Object)this.preparing, (Object)other.preparing) && Objects.equal((Object)this.prepared, (Object)other.prepared) && Objects.equal((Object)this.audioSessionId, (Object)other.audioSessionId) && Objects.equal((Object)this.bufferedProgress, (Object)other.bufferedProgress) && Objects.equal((Object)this.stalled, (Object)other.stalled) && Objects.equal((Object)this.errorCode, (Object)other.errorCode) && Objects.equal((Object)this.errorMessage, (Object)other.errorMessage) && Objects.equal((Object)this.sleepTimerStarted, (Object)other.sleepTimerStarted) && Objects.equal((Object)this.sleepTimerTime, (Object)other.sleepTimerTime) && Objects.equal((Object)this.sleepTimerStartTime, (Object)other.sleepTimerStartTime) && Objects.equal((Object)this.duration, (Object)other.duration) && Objects.equal((Object)((Object)this.timeoutAction), (Object)((Object)other.timeoutAction)) && Objects.equal((Object)this.waitPlayComplete, (Object)other.waitPlayComplete) && Objects.equal((Object)this.sleepTimerEnd, (Object)other.sleepTimerEnd) && Objects.equal((Object)this.sleepTimerTimeout, (Object)other.sleepTimerTimeout);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.playProgress, this.playProgressUpdateTime, this.musicItem, this.playPosition, this.playMode, Float.valueOf(this.speed), this.playbackState, this.preparing, this.prepared, this.audioSessionId, this.bufferedProgress, this.stalled, this.errorCode, this.errorMessage, this.sleepTimerStarted, this.sleepTimerTime, this.sleepTimerStartTime, this.timeoutAction, this.duration, this.waitPlayComplete, this.sleepTimerEnd, this.sleepTimerTimeout});
    }

    @NonNull
    public String toString() {
        return "PlayerState{playProgress=" + this.playProgress + ", playProgressUpdateTime=" + this.playProgressUpdateTime + ", musicItem=" + this.musicItem + ", playPosition=" + this.playPosition + ", playMode=" + (Object)((Object)this.playMode) + ", speed=" + this.speed + ", playbackState=" + (Object)((Object)this.playbackState) + ", preparing=" + this.preparing + ", prepared=" + this.prepared + ", audioSessionId=" + this.audioSessionId + ", bufferingPercent=" + this.bufferedProgress + ", stalled=" + this.stalled + ", errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + '\'' + ", sleepTimerStarted=" + this.sleepTimerStarted + ", sleepTimerTime=" + this.sleepTimerTime + ", sleepTimerStartTime=" + this.sleepTimerStartTime + ", timeoutAction=" + (Object)((Object)this.timeoutAction) + ", sleepTimerWaitPlayComplete=" + this.waitPlayComplete + ", timeoutActionComplete=" + this.sleepTimerEnd + ", sleepTimerTimeout=" + this.sleepTimerTimeout + ", duration=" + this.duration + '}';
    }

    protected PlayerState(Parcel in) {
        this.playProgress = in.readInt();
        this.playProgressUpdateTime = in.readLong();
        this.musicItem = (MusicItem)in.readParcelable(Thread.currentThread().getContextClassLoader());
        this.playPosition = in.readInt();
        this.playMode = PlayMode.values()[in.readInt()];
        this.speed = in.readFloat();
        this.playbackState = PlaybackState.values()[in.readInt()];
        this.preparing = in.readByte() != 0;
        this.prepared = in.readByte() != 0;
        this.audioSessionId = in.readInt();
        this.bufferedProgress = in.readInt();
        this.stalled = in.readByte() != 0;
        this.errorCode = in.readInt();
        this.errorMessage = in.readString();
        this.sleepTimerStarted = in.readByte() != 0;
        this.sleepTimerTime = in.readLong();
        this.sleepTimerStartTime = in.readLong();
        this.timeoutAction = SleepTimer.TimeoutAction.values()[in.readInt()];
        this.duration = in.readInt();
        this.waitPlayComplete = in.readByte() != 0;
        this.sleepTimerEnd = in.readByte() != 0;
        this.sleepTimerTimeout = in.readByte() != 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.playProgress);
        dest.writeLong(this.playProgressUpdateTime);
        dest.writeParcelable((Parcelable)this.musicItem, flags);
        dest.writeInt(this.playPosition);
        dest.writeInt(this.playMode.ordinal());
        dest.writeFloat(this.speed);
        dest.writeInt(this.playbackState.ordinal());
        dest.writeByte((byte)(this.preparing ? 1 : 0));
        dest.writeByte((byte)(this.prepared ? 1 : 0));
        dest.writeInt(this.audioSessionId);
        dest.writeInt(this.bufferedProgress);
        dest.writeByte((byte)(this.stalled ? 1 : 0));
        dest.writeInt(this.errorCode);
        dest.writeString(this.errorMessage);
        dest.writeByte((byte)(this.sleepTimerStarted ? 1 : 0));
        dest.writeLong(this.sleepTimerTime);
        dest.writeLong(this.sleepTimerStartTime);
        dest.writeInt(this.timeoutAction.ordinal());
        dest.writeInt(this.duration);
        dest.writeByte((byte)(this.waitPlayComplete ? 1 : 0));
        dest.writeByte((byte)(this.sleepTimerEnd ? 1 : 0));
        dest.writeByte((byte)(this.sleepTimerTimeout ? 1 : 0));
    }

    public int describeContents() {
        return 0;
    }
}

