/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import android.os.Bundle;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import snow.player.PlayerManager;
import snow.player.SoundQuality;

public final class PlayerManager__ChannelHelper {
    private static final String KEY_CLASS_NAME = "__class_name";
    private static final String KEY_METHOD_ID = "__method_id";
    private static final String CLASS_NAME = "snow.player.PlayerManager";
    private static final int METHOD_ID_1 = 1;
    private static final int METHOD_ID_2 = 2;
    private static final int METHOD_ID_3 = 3;
    private static final int METHOD_ID_4 = 4;
    private static final int METHOD_ID_5 = 5;
    private static final int METHOD_ID_6 = 6;

    private PlayerManager__ChannelHelper() {
        throw new AssertionError();
    }

    public static final class Dispatcher
    implements channel.helper.Dispatcher {
        private final WeakReference<PlayerManager> callbackWeakReference;

        public Dispatcher(PlayerManager callback) {
            this.callbackWeakReference = new WeakReference<PlayerManager>(callback);
        }

        public boolean match(Map<String, Object> data) {
            return PlayerManager__ChannelHelper.CLASS_NAME.equals(data.get(PlayerManager__ChannelHelper.KEY_CLASS_NAME));
        }

        public boolean dispatch(Map<String, Object> data) {
            if (!this.match(data)) {
                return false;
            }
            int methodId = (Integer)data.get(PlayerManager__ChannelHelper.KEY_METHOD_ID);
            PlayerManager callback = (PlayerManager)this.callbackWeakReference.get();
            if (callback == null) {
                return false;
            }
            switch (methodId) {
                case 1: {
                    SoundQuality METHOD_ID_1_soundQuality = SoundQuality.values()[(Integer)data.get("soundQuality")];
                    callback.setSoundQuality(METHOD_ID_1_soundQuality);
                    return true;
                }
                case 2: {
                    Bundle METHOD_ID_2_config = (Bundle)data.get("config");
                    callback.setAudioEffectConfig(METHOD_ID_2_config);
                    return true;
                }
                case 3: {
                    boolean METHOD_ID_3_enabled = (Boolean)data.get("enabled");
                    callback.setAudioEffectEnabled(METHOD_ID_3_enabled);
                    return true;
                }
                case 4: {
                    boolean METHOD_ID_4_onlyWifiNetwork = (Boolean)data.get("onlyWifiNetwork");
                    callback.setOnlyWifiNetwork(METHOD_ID_4_onlyWifiNetwork);
                    return true;
                }
                case 5: {
                    boolean METHOD_ID_5_ignoreAudioFocus = (Boolean)data.get("ignoreAudioFocus");
                    callback.setIgnoreAudioFocus(METHOD_ID_5_ignoreAudioFocus);
                    return true;
                }
                case 6: {
                    callback.shutdown();
                    return true;
                }
            }
            return false;
        }
    }

    public static final class Emitter
    implements PlayerManager {
        private channel.helper.Emitter emitter;

        public Emitter(channel.helper.Emitter emitter) {
            this.emitter = emitter;
        }

        private void sendMessage(int id, Map<String, Object> args) {
            args.put(PlayerManager__ChannelHelper.KEY_CLASS_NAME, PlayerManager__ChannelHelper.CLASS_NAME);
            args.put(PlayerManager__ChannelHelper.KEY_METHOD_ID, id);
            this.emitter.emit(args);
        }

        @Override
        public void setSoundQuality(SoundQuality soundQuality) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("soundQuality", soundQuality.ordinal());
            this.sendMessage(1, args);
        }

        @Override
        public void setAudioEffectConfig(Bundle config) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("config", config);
            this.sendMessage(2, args);
        }

        @Override
        public void setAudioEffectEnabled(boolean enabled) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("enabled", enabled);
            this.sendMessage(3, args);
        }

        @Override
        public void setOnlyWifiNetwork(boolean onlyWifiNetwork) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("onlyWifiNetwork", onlyWifiNetwork);
            this.sendMessage(4, args);
        }

        @Override
        public void setIgnoreAudioFocus(boolean ignoreAudioFocus) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("ignoreAudioFocus", ignoreAudioFocus);
            this.sendMessage(5, args);
        }

        @Override
        public void shutdown() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(6, args);
        }
    }
}

