/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.common.base.Preconditions;
import com.tencent.mmkv.MMKV;
import snow.player.SoundQuality;

class PlayerConfig {
    private static final String KEY_SOUND_QUALITY = "sound_quality";
    private static final String KEY_AUDIO_EFFECT_CONFIG = "audio_effect_config";
    private static final String KEY_AUDIO_EFFECT_ENABLED = "audio_effect_enabled";
    private static final String KEY_ONLY_WIFI_NETWORK = "only_wifi_network";
    private static final String KEY_IGNORE_AUDIO_FOCUS = "ignore_audio_focus";
    private final MMKV mMMKV;

    public PlayerConfig(@NonNull Context context, @NonNull String id) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)id);
        MMKV.initialize((Context)context);
        this.mMMKV = MMKV.mmkvWithID((String)("PlayerConfig:" + id), (int)2);
    }

    @NonNull
    public SoundQuality getSoundQuality() {
        return SoundQuality.values()[this.mMMKV.decodeInt(KEY_SOUND_QUALITY, 0)];
    }

    public void setSoundQuality(@NonNull SoundQuality soundQuality) {
        Preconditions.checkNotNull((Object)((Object)soundQuality));
        this.mMMKV.encode(KEY_SOUND_QUALITY, soundQuality.ordinal());
    }

    @NonNull
    public Bundle getAudioEffectConfig() {
        return (Bundle)this.mMMKV.decodeParcelable(KEY_AUDIO_EFFECT_CONFIG, Bundle.class, (Parcelable)new Bundle());
    }

    public void setAudioEffectConfig(@NonNull Bundle audioEffectConfig) {
        Preconditions.checkNotNull((Object)audioEffectConfig);
        this.mMMKV.encode(KEY_AUDIO_EFFECT_CONFIG, (Parcelable)audioEffectConfig);
    }

    public boolean isAudioEffectEnabled() {
        return this.mMMKV.decodeBool(KEY_AUDIO_EFFECT_ENABLED, false);
    }

    public void setAudioEffectEnabled(boolean audioEffectEnabled) {
        this.mMMKV.encode(KEY_AUDIO_EFFECT_ENABLED, audioEffectEnabled);
    }

    public boolean isOnlyWifiNetwork() {
        return this.mMMKV.decodeBool(KEY_ONLY_WIFI_NETWORK, false);
    }

    public void setOnlyWifiNetwork(boolean onlyWifiNetwork) {
        this.mMMKV.encode(KEY_ONLY_WIFI_NETWORK, onlyWifiNetwork);
    }

    public boolean isIgnoreAudioFocus() {
        return this.mMMKV.decodeBool(KEY_IGNORE_AUDIO_FOCUS, false);
    }

    public void setIgnoreAudioFocus(boolean ignoreAudioFocus) {
        this.mMMKV.encode(KEY_IGNORE_AUDIO_FOCUS, ignoreAudioFocus);
    }
}

