/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.session.MediaControllerCompat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import channel.helper.ChannelHelper;
import channel.helper.Dispatcher;
import channel.helper.DispatcherUtil;
import channel.helper.Emitter;
import channel.helper.pipe.CustomActionPipe;
import channel.helper.pipe.SessionEventPipe;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import snow.player.PlayMode;
import snow.player.PlaybackState;
import snow.player.Player;
import snow.player.PlayerConfig;
import snow.player.PlayerManager;
import snow.player.PlayerService;
import snow.player.PlayerState;
import snow.player.PlayerStateHelper;
import snow.player.PlayerStateListener;
import snow.player.PlayerStateSynchronizer;
import snow.player.PlaylistManagerImp;
import snow.player.SleepTimer;
import snow.player.SoundQuality;
import snow.player.audio.MusicItem;
import snow.player.playlist.Playlist;
import snow.player.playlist.PlaylistEditor;
import snow.player.playlist.PlaylistManager;

public class PlayerClient
implements Player,
PlayerManager,
PlaylistManager,
PlaylistEditor,
SleepTimer {
    private final Context mApplicationContext;
    private final Class<? extends PlayerService> mPlayerService;
    private final String mClientToken;
    private final String mPersistentId;
    private MediaBrowserCompat mMediaBrowser;
    private MediaControllerCompat mMediaController;
    private MediaControllerCompat.Callback mMediaControllerCallback;
    private SessionEventPipe mSessionEventDispatcher;
    private final PlayerConfig mPlayerConfig;
    private PlayerManager mPlayerManager;
    private PlayerStateSynchronizer mPlayerStateSynchronizer;
    private PlayerStateSynchronizer.OnSyncPlayerStateListener mSyncPlayerStateListener;
    private SleepTimer mSleepTimer;
    private OnConnectCallback mConnectCallback;
    private PlayerState mPlayerState;
    private PlayerStateHelper mPlayerStateHelper;
    private Player mPlayer;
    private PlaylistEditor mPlaylistEditor;
    private PlaylistManagerImp mPlaylistManager;
    private PlayerStateListenerImpl mPlayerStateListener;
    private boolean mConnecting;
    private boolean mAutoConnect;
    private Runnable mConnectedAction;
    private final List<Player.OnPlaybackStateChangeListener> mAllPlaybackStateChangeListener;
    private final List<Player.OnPrepareListener> mAllPrepareListener;
    private final List<Player.OnStalledChangeListener> mAllStalledChangeListener;
    private final List<Player.OnBufferedProgressChangeListener> mAllBufferedProgressChangeListener;
    private final List<Player.OnPlayingMusicItemChangeListener> mAllPlayingMusicItemChangeListener;
    private final List<Player.OnSeekCompleteListener> mAllSeekListener;
    private final List<Player.OnPlaylistChangeListener> mAllPlaylistChangeListener;
    private final List<Player.OnPlayModeChangeListener> mAllPlayModeChangeListener;
    private final List<OnPlaybackStateChangeListener> mClientAllPlaybackStateChangeListener;
    private final List<OnAudioSessionChangeListener> mAllAudioSessionChangeListener;
    private final List<SleepTimer.OnStateChangeListener> mAllSleepTimerStateChangeListener;
    private final List<SleepTimer.OnWaitPlayCompleteChangeListener> mAllWaitPlayCompleteChangeListener;
    private final List<Player.OnRepeatListener> mAllRepeatListener;
    private final List<Player.OnSpeedChangeListener> mAllSpeedChangeListener;
    private final List<OnConnectStateChangeListener> mAllConnectStateChangeListener;

    private PlayerClient(Context context, Class<? extends PlayerService> playerService) {
        this.mApplicationContext = context.getApplicationContext();
        this.mPlayerService = playerService;
        this.mClientToken = UUID.randomUUID().toString();
        this.mPersistentId = PlayerService.getPersistenceId(playerService);
        this.mPlayerConfig = new PlayerConfig(context, this.mPersistentId);
        this.mAllPlaybackStateChangeListener = new ArrayList<Player.OnPlaybackStateChangeListener>();
        this.mAllPrepareListener = new ArrayList<Player.OnPrepareListener>();
        this.mAllStalledChangeListener = new ArrayList<Player.OnStalledChangeListener>();
        this.mAllBufferedProgressChangeListener = new ArrayList<Player.OnBufferedProgressChangeListener>();
        this.mAllPlayingMusicItemChangeListener = new ArrayList<Player.OnPlayingMusicItemChangeListener>();
        this.mAllSeekListener = new ArrayList<Player.OnSeekCompleteListener>();
        this.mAllPlaylistChangeListener = new ArrayList<Player.OnPlaylistChangeListener>();
        this.mAllPlayModeChangeListener = new ArrayList<Player.OnPlayModeChangeListener>();
        this.mClientAllPlaybackStateChangeListener = new ArrayList<OnPlaybackStateChangeListener>();
        this.mAllAudioSessionChangeListener = new ArrayList<OnAudioSessionChangeListener>();
        this.mAllSleepTimerStateChangeListener = new ArrayList<SleepTimer.OnStateChangeListener>();
        this.mAllWaitPlayCompleteChangeListener = new ArrayList<SleepTimer.OnWaitPlayCompleteChangeListener>();
        this.mAllRepeatListener = new ArrayList<Player.OnRepeatListener>();
        this.mAllSpeedChangeListener = new ArrayList<Player.OnSpeedChangeListener>();
        this.mAllConnectStateChangeListener = new ArrayList<OnConnectStateChangeListener>();
        this.initMediaBrowser();
        this.initPlaylistManager();
        this.initPlayerStateHolder();
        this.initCommandCallback();
        this.initSessionEventDispatcher();
        this.initMediaControllerCallback();
        this.initPlayerState(new PlayerState());
    }

    public static PlayerClient newInstance(@NonNull Context context, @NonNull Class<? extends PlayerService> playerService) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull(playerService);
        if (PlayerClient.serviceNotFound(context, playerService)) {
            throw new IllegalArgumentException("PlayerService not found, Please check your 'AndroidManifest.xml'");
        }
        return new PlayerClient(context, playerService);
    }

    private static boolean serviceNotFound(Context context, Class<? extends PlayerService> playerService) {
        Intent intent;
        PackageManager pm = context.getPackageManager();
        return pm.resolveService(intent = new Intent(context, playerService), 0) == null;
    }

    private void initMediaBrowser() {
        this.mMediaBrowser = new MediaBrowserCompat(this.mApplicationContext, new ComponentName(this.mApplicationContext, this.mPlayerService), new MediaBrowserCompat.ConnectionCallback(){

            public void onConnected() {
                try {
                    PlayerClient.this.mMediaController = new MediaControllerCompat(PlayerClient.this.mApplicationContext, PlayerClient.this.mMediaBrowser.getSessionToken());
                    PlayerClient.this.mMediaController.registerCallback(PlayerClient.this.mMediaControllerCallback, new Handler(Looper.getMainLooper()));
                    PlayerClient.this.initCustomActionEmitter(PlayerClient.this.mMediaController);
                    PlayerClient.this.mPlayerStateSynchronizer.syncPlayerState(PlayerClient.this.mClientToken);
                }
                catch (Exception e) {
                    PlayerClient.this.mMediaBrowser.disconnect();
                    this.onConnectionFailed();
                }
            }

            public void onConnectionFailed() {
                PlayerClient.this.onDisconnected();
                if (PlayerClient.this.mConnectCallback != null) {
                    PlayerClient.this.mConnectCallback.onConnected(false);
                    PlayerClient.this.mConnectCallback = null;
                }
            }
        }, null);
    }

    private void initPlaylistManager() {
        this.mPlaylistManager = new PlaylistManagerImp(this.mApplicationContext, this.mPersistentId);
    }

    private void initPlayerStateHolder() {
        this.mPlayerStateListener = new PlayerStateListenerImpl();
    }

    private void initCommandCallback() {
        this.mSyncPlayerStateListener = new PlayerStateSynchronizer.OnSyncPlayerStateListener(){

            @Override
            public void onSyncPlayerState(@NonNull String clientToken, @NonNull PlayerState playerState) {
                if (!clientToken.equals(PlayerClient.this.mClientToken)) {
                    return;
                }
                PlayerClient.this.initPlayerState(playerState);
                if (PlayerClient.this.mConnectCallback != null) {
                    PlayerClient.this.mConnectCallback.onConnected(true);
                    PlayerClient.this.mConnectCallback = null;
                }
                PlayerClient.this.notifyConnectStateChanged(true);
                PlayerClient.this.notifySticky();
            }
        };
    }

    private void initCustomActionEmitter(MediaControllerCompat mediaController) {
        CustomActionPipe customActionEmitter = new CustomActionPipe(mediaController.getTransportControls());
        this.mPlayer = (Player)ChannelHelper.newEmitter(Player.class, (Emitter)customActionEmitter);
        this.mPlaylistEditor = (PlaylistEditor)ChannelHelper.newEmitter(PlaylistEditor.class, (Emitter)customActionEmitter);
        this.mPlayerManager = (PlayerManager)ChannelHelper.newEmitter(PlayerManager.class, (Emitter)customActionEmitter);
        this.mPlayerStateSynchronizer = (PlayerStateSynchronizer)ChannelHelper.newEmitter(PlayerStateSynchronizer.class, (Emitter)customActionEmitter);
        this.mSleepTimer = (SleepTimer)ChannelHelper.newEmitter(SleepTimer.class, (Emitter)customActionEmitter);
    }

    private void initSessionEventDispatcher() {
        this.mSessionEventDispatcher = new SessionEventPipe(DispatcherUtil.merge((Dispatcher)ChannelHelper.newDispatcher(PlayerStateSynchronizer.OnSyncPlayerStateListener.class, (Object)this.mSyncPlayerStateListener), (Dispatcher[])new Dispatcher[]{ChannelHelper.newDispatcher(PlayerStateListener.class, (Object)this.mPlayerStateListener), ChannelHelper.newDispatcher(SleepTimer.OnStateChangeListener2.class, (Object)this.mPlayerStateListener)}));
    }

    private void initMediaControllerCallback() {
        this.mMediaControllerCallback = new MediaControllerCompat.Callback(){

            public void onSessionEvent(String event, Bundle extras) {
                PlayerClient.this.mSessionEventDispatcher.dispatch(event, extras);
            }
        };
    }

    private void onDisconnected() {
        this.notifyConnectStateChanged(false);
    }

    private void notifyConnectStateChanged(boolean connected) {
        this.mConnecting = false;
        for (OnConnectStateChangeListener listener : this.mAllConnectStateChangeListener) {
            listener.onConnectStateChanged(connected);
        }
        if (connected && this.mConnectedAction != null) {
            this.mConnectedAction.run();
        }
    }

    public void connect() {
        if (this.mConnecting || this.isConnected()) {
            return;
        }
        this.mConnecting = true;
        this.mMediaBrowser.connect();
    }

    public void connect(OnConnectCallback callback) {
        if (this.isConnected()) {
            callback.onConnected(true);
            return;
        }
        this.mConnectCallback = callback;
        this.connect();
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.onDisconnected();
        this.mMediaController.unregisterCallback(this.mMediaControllerCallback);
        this.mMediaBrowser.disconnect();
    }

    public boolean isConnected() {
        return this.mMediaBrowser.isConnected();
    }

    public void setAutoConnect(boolean autoConnect) {
        this.mAutoConnect = autoConnect;
    }

    public boolean isAutoConnect() {
        return this.mAutoConnect;
    }

    public void addOnConnectStateChangeListener(@NonNull OnConnectStateChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllConnectStateChangeListener.contains(listener)) {
            return;
        }
        this.mAllConnectStateChangeListener.add(listener);
        listener.onConnectStateChanged(this.isConnected());
    }

    public void addOnConnectStateChangeListener(@NonNull LifecycleOwner owner, final @NonNull OnConnectStateChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnConnectStateChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnConnectStateChangeListener(listener);
            }
        }));
    }

    public void removeOnConnectStateChangeListener(OnConnectStateChangeListener listener) {
        this.mAllConnectStateChangeListener.remove(listener);
    }

    @Nullable
    public MediaControllerCompat getMediaController() {
        return this.mMediaController;
    }

    public void sendCustomAction(@NonNull String action, @Nullable Bundle args) {
        Preconditions.checkNotNull((Object)action);
        if (this.notConnected() || this.getMediaController() == null) {
            return;
        }
        this.getMediaController().getTransportControls().sendCustomAction(action, args);
    }

    @Override
    public void setSoundQuality(@NonNull SoundQuality soundQuality) {
        Preconditions.checkNotNull((Object)((Object)soundQuality));
        if (!this.isConnected()) {
            return;
        }
        this.mPlayerManager.setSoundQuality(soundQuality);
    }

    @Override
    public void setAudioEffectConfig(@NonNull Bundle config) {
        Preconditions.checkNotNull((Object)config);
        if (!this.isConnected()) {
            return;
        }
        this.mPlayerManager.setAudioEffectConfig(config);
    }

    @Override
    public void setAudioEffectEnabled(boolean enabled) {
        if (!this.isConnected()) {
            return;
        }
        this.mPlayerManager.setAudioEffectEnabled(enabled);
    }

    @Override
    public void setOnlyWifiNetwork(boolean onlyWifiNetwork) {
        if (!this.isConnected()) {
            return;
        }
        this.mPlayerManager.setOnlyWifiNetwork(onlyWifiNetwork);
    }

    @Override
    public void setIgnoreAudioFocus(boolean ignoreAudioFocus) {
        if (!this.isConnected()) {
            return;
        }
        this.mPlayerManager.setIgnoreAudioFocus(ignoreAudioFocus);
    }

    public SoundQuality getSoundQuality() {
        return this.mPlayerConfig.getSoundQuality();
    }

    @NonNull
    public Bundle getAudioEffectConfig() {
        return this.mPlayerConfig.getAudioEffectConfig();
    }

    public boolean isAudioEffectEnabled() {
        return this.mPlayerConfig.isAudioEffectEnabled();
    }

    public boolean isOnlyWifiNetwork() {
        return this.mPlayerConfig.isOnlyWifiNetwork();
    }

    public boolean isIgnoreAudioFocus() {
        return this.mPlayerConfig.isIgnoreAudioFocus();
    }

    @Override
    public void shutdown() {
        if (this.isConnected()) {
            this.mPlayerManager.shutdown();
        }
    }

    private boolean notConnected() {
        return !this.mMediaBrowser.isConnected();
    }

    public PlaylistManager getPlaylistManager() {
        return this.mPlaylistManager;
    }

    public void setPlaylist(@NonNull Playlist playlist) {
        this.setPlaylist(playlist, 0, false);
    }

    public void setPlaylist(@NonNull Playlist playlist, boolean play) {
        this.setPlaylist(playlist, 0, play);
    }

    @Override
    public void setPlaylist(final @NonNull Playlist playlist, final int position, final boolean play) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)playlist);
        if (position < 0) {
            throw new IllegalArgumentException("position must >= 0.");
        }
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.setPlaylist(playlist, position, play);
                }
            });
            return;
        }
        this.mPlaylistEditor.setPlaylist(playlist, position, play);
    }

    @Override
    public void getPlaylist(@NonNull PlaylistManager.Callback callback) {
        Preconditions.checkNotNull((Object)callback);
        this.mPlaylistManager.getPlaylist(callback);
    }

    @Override
    public long getLastModified() {
        return this.mPlaylistManager.getLastModified();
    }

    @Override
    @NonNull
    public String getPlaylistName() {
        return this.mPlaylistManager.getPlaylistName();
    }

    @Override
    public int getPlaylistSize() {
        return this.mPlaylistManager.getPlaylistSize();
    }

    @Override
    @NonNull
    public String getPlaylistToken() {
        return this.mPlaylistManager.getPlaylistToken();
    }

    @Override
    public boolean isPlaylistEditable() {
        return this.mPlaylistManager.isPlaylistEditable();
    }

    public int getPlayProgress() {
        return this.mPlayerState.getPlayProgress();
    }

    public long getPlayProgressUpdateTime() {
        return this.mPlayerState.getPlayProgressUpdateTime();
    }

    public boolean isLooping() {
        return this.getPlayMode() == PlayMode.LOOP;
    }

    @Nullable
    public MusicItem getPlayingMusicItem() {
        return this.mPlayerState.getMusicItem();
    }

    public int getPlayingMusicItemDuration() {
        return this.mPlayerState.getDuration();
    }

    public PlaybackState getPlaybackState() {
        return this.mPlayerState.getPlaybackState();
    }

    public int getAudioSessionId() {
        return this.mPlayerState.getAudioSessionId();
    }

    public int getBufferedProgress() {
        return this.mPlayerState.getBufferedProgress();
    }

    public boolean isPlaying() {
        return this.mPlayerState.getPlaybackState() == PlaybackState.PLAYING;
    }

    public boolean isStalled() {
        return this.mPlayerState.isStalled();
    }

    public boolean isPreparing() {
        return this.mPlayerState.isPreparing();
    }

    public boolean isPrepared() {
        return this.mPlayerState.isPrepared();
    }

    public boolean isError() {
        return this.getErrorCode() != 0;
    }

    public int getErrorCode() {
        return this.mPlayerState.getErrorCode();
    }

    public String getErrorMessage() {
        return this.mPlayerState.getErrorMessage();
    }

    public PlayMode getPlayMode() {
        return this.mPlayerState.getPlayMode();
    }

    public float getSpeed() {
        return this.mPlayerState.getSpeed();
    }

    public int getPlayPosition() {
        return this.mPlayerState.getPlayPosition();
    }

    public boolean isSleepTimerStarted() {
        return this.mPlayerState.isSleepTimerStarted();
    }

    public long getSleepTimerTime() {
        return this.mPlayerState.getSleepTimerTime();
    }

    public long getSleepTimerStartedTime() {
        return this.mPlayerState.getSleepTimerStartTime();
    }

    public long getSleepTimerElapsedTime() {
        if (this.isSleepTimerStarted()) {
            return SystemClock.elapsedRealtime() - this.getSleepTimerStartedTime();
        }
        return 0L;
    }

    @NonNull
    public SleepTimer.TimeoutAction getTimeoutAction() {
        return this.mPlayerState.getTimeoutAction();
    }

    @Override
    public void skipToNext() {
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.skipToNext();
                }
            });
            return;
        }
        this.mPlayer.skipToNext();
    }

    @Override
    public void skipToPrevious() {
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.skipToPrevious();
                }
            });
            return;
        }
        this.mPlayer.skipToPrevious();
    }

    @Override
    public void skipToPosition(final int position) throws IllegalArgumentException {
        if (position < 0) {
            throw new IllegalArgumentException("position music >= 0");
        }
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.skipToPosition(position);
                }
            });
            return;
        }
        this.mPlayer.skipToPosition(position);
    }

    @Override
    public void playPause(final int position) throws IllegalArgumentException {
        if (position < 0) {
            throw new IllegalArgumentException("position music >= 0");
        }
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.playPause(position);
                }
            });
            return;
        }
        this.mPlayer.playPause(position);
    }

    @Override
    public void setPlayMode(final @NonNull PlayMode playMode) {
        Preconditions.checkNotNull((Object)((Object)playMode));
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.setPlayMode(playMode);
                }
            });
            return;
        }
        this.mPlayer.setPlayMode(playMode);
    }

    @Override
    public void setSpeed(final float speed) {
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.setSpeed(speed);
                }
            });
            return;
        }
        this.mPlayer.setSpeed(speed);
    }

    private void tryAutoConnect(@Nullable Runnable connectedAction) {
        if (!this.mAutoConnect) {
            return;
        }
        if (this.isConnected() && connectedAction != null) {
            connectedAction.run();
            return;
        }
        this.mConnectedAction = connectedAction;
        this.connect();
    }

    @Override
    public void play() {
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.play();
                }
            });
            return;
        }
        this.mPlayer.play();
    }

    @Override
    public void pause() {
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.pause();
                }
            });
            return;
        }
        this.mPlayer.pause();
    }

    @Override
    public void stop() {
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.stop();
                }
            });
            return;
        }
        this.mPlayer.stop();
    }

    @Override
    public void playPause() {
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.playPause();
                }
            });
            return;
        }
        this.mPlayer.playPause();
    }

    @Override
    public void seekTo(final int progress) {
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.seekTo(progress);
                }
            });
            return;
        }
        this.mPlayer.seekTo(progress);
    }

    public boolean isForbidSeek() {
        if (this.notConnected()) {
            return false;
        }
        return this.mPlayerState.isForbidSeek();
    }

    public boolean isAutoDuration() {
        if (this.notConnected()) {
            return false;
        }
        MusicItem musicItem = this.mPlayerState.getMusicItem();
        if (musicItem == null) {
            return false;
        }
        return musicItem.isAutoDuration();
    }

    @Override
    public void fastForward() {
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.fastForward();
                }
            });
            return;
        }
        this.mPlayer.fastForward();
    }

    @Override
    public void rewind() {
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.rewind();
                }
            });
            return;
        }
        this.mPlayer.rewind();
    }

    public void startSleepTimer(long time) throws IllegalArgumentException {
        this.startSleepTimer(time, SleepTimer.TimeoutAction.PAUSE);
    }

    @Override
    public void startSleepTimer(long time, @NonNull SleepTimer.TimeoutAction action) throws IllegalArgumentException {
        if (time < 0L) {
            throw new IllegalArgumentException("time music >= 0");
        }
        Preconditions.checkNotNull((Object)((Object)action));
        if (this.notConnected()) {
            return;
        }
        this.mSleepTimer.startSleepTimer(time, action);
    }

    @Override
    public void cancelSleepTimer() {
        if (this.notConnected()) {
            return;
        }
        this.mSleepTimer.cancelSleepTimer();
    }

    @Override
    public void setWaitPlayComplete(boolean waitPlayComplete) {
        if (this.notConnected()) {
            return;
        }
        this.mSleepTimer.setWaitPlayComplete(waitPlayComplete);
    }

    public boolean isWaitPlayComplete() {
        if (this.notConnected()) {
            return false;
        }
        return this.mPlayerState.isWaitPlayComplete();
    }

    public boolean isSleepTimerEnd() {
        if (this.notConnected()) {
            return true;
        }
        return this.mPlayerState.isSleepTimerEnd();
    }

    public boolean isSleepTimerTimeout() {
        if (this.notConnected()) {
            return false;
        }
        return this.mPlayerState.isSleepTimerTimeout();
    }

    public void addOnPlaybackStateChangeListener(@NonNull Player.OnPlaybackStateChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllPlaybackStateChangeListener.contains(listener)) {
            return;
        }
        this.mAllPlaybackStateChangeListener.add(listener);
        this.notifyPlaybackStateChanged(listener);
    }

    public void addOnPlaybackStateChangeListener(@NonNull LifecycleOwner owner, final @NonNull Player.OnPlaybackStateChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnPlaybackStateChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnPlaybackStateChangeListener(listener);
            }
        }));
    }

    public void removeOnPlaybackStateChangeListener(Player.OnPlaybackStateChangeListener listener) {
        this.mAllPlaybackStateChangeListener.remove(listener);
    }

    public void addOnPrepareListener(@NonNull Player.OnPrepareListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllPrepareListener.contains(listener)) {
            return;
        }
        this.mAllPrepareListener.add(listener);
        this.notifyPrepareStateChanged(listener);
    }

    public void addOnPrepareListener(@NonNull LifecycleOwner owner, final @NonNull Player.OnPrepareListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnPrepareListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnPrepareListener(listener);
            }
        }));
    }

    public void removeOnPrepareListener(Player.OnPrepareListener listener) {
        this.mAllPrepareListener.remove(listener);
    }

    public void addOnStalledChangeListener(@NonNull Player.OnStalledChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllStalledChangeListener.contains(listener)) {
            return;
        }
        this.mAllStalledChangeListener.add(listener);
        this.notifyStalledChanged(listener);
    }

    public void addOnStalledChangeListener(@NonNull LifecycleOwner owner, final @NonNull Player.OnStalledChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnStalledChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnStalledChangeListener(listener);
            }
        }));
    }

    public void removeOnStalledChangeListener(Player.OnStalledChangeListener listener) {
        this.mAllStalledChangeListener.remove(listener);
    }

    public void addOnBufferedProgressChangeListener(@NonNull Player.OnBufferedProgressChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllBufferedProgressChangeListener.contains(listener)) {
            return;
        }
        this.mAllBufferedProgressChangeListener.add(listener);
        this.notifyOnBufferedProgressChanged(listener);
    }

    public void addOnBufferedProgressChangeListener(@NonNull LifecycleOwner owner, final @NonNull Player.OnBufferedProgressChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnBufferedProgressChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnBufferedProgressChangeListener(listener);
            }
        }));
    }

    public void removeOnBufferedProgressChangeListener(Player.OnBufferedProgressChangeListener listener) {
        this.mAllBufferedProgressChangeListener.remove(listener);
    }

    public void addOnPlayingMusicItemChangeListener(@NonNull Player.OnPlayingMusicItemChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllPlayingMusicItemChangeListener.contains(listener)) {
            return;
        }
        this.mAllPlayingMusicItemChangeListener.add(listener);
        this.notifyPlayingMusicItemChanged(listener);
    }

    public void addOnPlayingMusicItemChangeListener(@NonNull LifecycleOwner owner, final @NonNull Player.OnPlayingMusicItemChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnPlayingMusicItemChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnPlayingMusicItemChangeListener(listener);
            }
        }));
    }

    public void removeOnPlayingMusicItemChangeListener(Player.OnPlayingMusicItemChangeListener listener) {
        this.mAllPlayingMusicItemChangeListener.remove(listener);
    }

    public void addOnSeekCompleteListener(@NonNull Player.OnSeekCompleteListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllSeekListener.contains(listener)) {
            return;
        }
        this.mAllSeekListener.add(listener);
        this.notifySeekComplete(listener);
    }

    public void addOnSeekCompleteListener(@NonNull LifecycleOwner owner, final @NonNull Player.OnSeekCompleteListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnSeekCompleteListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnSeekCompleteListener(listener);
            }
        }));
    }

    public void removeOnSeekCompleteListener(Player.OnSeekCompleteListener listener) {
        this.mAllSeekListener.remove(listener);
    }

    public void addOnPlaylistChangeListener(@NonNull Player.OnPlaylistChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllPlaylistChangeListener.contains(listener)) {
            return;
        }
        this.mAllPlaylistChangeListener.add(listener);
        this.notifyPlaylistChanged(listener);
    }

    public void addOnPlaylistChangeListener(@NonNull LifecycleOwner owner, final @NonNull Player.OnPlaylistChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnPlaylistChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnPlaylistChangeListener(listener);
            }
        }));
    }

    public void removeOnPlaylistChangeListener(Player.OnPlaylistChangeListener listener) {
        this.mAllPlaylistChangeListener.remove(listener);
    }

    public void addOnPlayModeChangeListener(@NonNull Player.OnPlayModeChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllPlayModeChangeListener.contains(listener)) {
            return;
        }
        this.mAllPlayModeChangeListener.add(listener);
        this.notifyPlayModeChanged(listener);
    }

    public void addOnPlayModeChangeListener(@NonNull LifecycleOwner owner, final @NonNull Player.OnPlayModeChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnPlayModeChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnPlayModeChangeListener(listener);
            }
        }));
    }

    public void removeOnPlayModeChangeListener(Player.OnPlayModeChangeListener listener) {
        this.mAllPlayModeChangeListener.remove(listener);
    }

    public void addOnSpeedChangeListener(@NonNull Player.OnSpeedChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllSpeedChangeListener.contains(listener)) {
            return;
        }
        this.mAllSpeedChangeListener.add(listener);
        this.notifySpeedChanged(listener);
    }

    public void addOnSpeedChangeListener(@NonNull LifecycleOwner owner, final @NonNull Player.OnSpeedChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnSpeedChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnSpeedChangeListener(listener);
            }
        }));
    }

    public void removeOnSpeedChangeListener(Player.OnSpeedChangeListener listener) {
        this.mAllSpeedChangeListener.remove(listener);
    }

    public void addOnPlaybackStateChangeListener(@NonNull OnPlaybackStateChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mClientAllPlaybackStateChangeListener.contains(listener)) {
            return;
        }
        this.mClientAllPlaybackStateChangeListener.add(listener);
        this.notifyClientPlaybackStateChanged(listener);
    }

    public void addOnPlaybackStateChangeListener(@NonNull LifecycleOwner owner, final @NonNull OnPlaybackStateChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnPlaybackStateChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnPlaybackStateChangeListener(listener);
            }
        }));
    }

    public void removeOnPlaybackStateChangeListener(OnPlaybackStateChangeListener listener) {
        this.mClientAllPlaybackStateChangeListener.remove(listener);
    }

    public void addOnAudioSessionChangeListener(@NonNull OnAudioSessionChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllAudioSessionChangeListener.contains(listener)) {
            return;
        }
        this.mAllAudioSessionChangeListener.add(listener);
        this.notifyAudioSessionChanged(listener);
    }

    public void addOnAudioSessionChangeListener(@NonNull LifecycleOwner owner, final @NonNull OnAudioSessionChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnAudioSessionChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnAudioSessionChangeListener(listener);
            }
        }));
    }

    public void removeOnAudioSessionChangeListener(OnAudioSessionChangeListener listener) {
        this.mAllAudioSessionChangeListener.remove(listener);
    }

    public void addOnSleepTimerStateChangeListener(@NonNull SleepTimer.OnStateChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllSleepTimerStateChangeListener.contains(listener)) {
            return;
        }
        this.mAllSleepTimerStateChangeListener.add(listener);
        if (this.mPlayerState.isSleepTimerStarted()) {
            this.notifySleepTimerStarted();
            if (this.mPlayerState.isSleepTimerTimeout()) {
                this.notifySleepTimerTimeout(listener);
            }
        }
        if (this.mPlayerState.isSleepTimerEnd()) {
            this.notifySleepTimerEnd(listener);
        }
    }

    public void addOnSleepTimerStateChangeListener(@NonNull LifecycleOwner owner, final @NonNull SleepTimer.OnStateChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnSleepTimerStateChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnSleepTimerStateChangeListener(listener);
            }
        }));
    }

    public void removeOnSleepTimerStateChangeListener(SleepTimer.OnStateChangeListener listener) {
        this.mAllSleepTimerStateChangeListener.remove(listener);
    }

    public void addOnWaitPlayCompleteChangeListener(@NonNull SleepTimer.OnWaitPlayCompleteChangeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllWaitPlayCompleteChangeListener.contains(listener)) {
            return;
        }
        this.mAllWaitPlayCompleteChangeListener.add(listener);
        this.notifyWaitPlayCompleteChanged(listener);
    }

    public void addOnWaitPlayCompleteChangeListener(@NonNull LifecycleOwner owner, final @NonNull SleepTimer.OnWaitPlayCompleteChangeListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnWaitPlayCompleteChangeListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnWaitPlayCompleteChangeListener(listener);
            }
        }));
    }

    public void removeOnWaitPlayCompleteChangeListener(SleepTimer.OnWaitPlayCompleteChangeListener listener) {
        this.mAllWaitPlayCompleteChangeListener.remove(listener);
    }

    public void addOnRepeatListener(@NonNull Player.OnRepeatListener listener) {
        Preconditions.checkNotNull((Object)listener);
        if (this.mAllRepeatListener.contains(listener)) {
            return;
        }
        this.mAllRepeatListener.add(listener);
    }

    public void addOnRepeatListener(@NonNull LifecycleOwner owner, final @NonNull Player.OnRepeatListener listener) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)listener);
        if (this.isDestroyed(owner)) {
            return;
        }
        this.addOnRepeatListener(listener);
        owner.getLifecycle().addObserver((LifecycleObserver)new DestroyObserver(new Runnable(){

            @Override
            public void run() {
                PlayerClient.this.removeOnRepeatListener(listener);
            }
        }));
    }

    public void removeOnRepeatListener(Player.OnRepeatListener listener) {
        this.mAllRepeatListener.remove(listener);
    }

    private boolean isDestroyed(LifecycleOwner owner) {
        return owner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED;
    }

    @Override
    public void insertMusicItem(final int position, final @NonNull MusicItem musicItem) throws IllegalArgumentException {
        if (position < 0) {
            throw new IllegalArgumentException("position must >= 0.");
        }
        Preconditions.checkNotNull((Object)musicItem);
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.insertMusicItem(position, musicItem);
                }
            });
            return;
        }
        this.mPlaylistEditor.insertMusicItem(position, musicItem);
    }

    @Override
    public void appendMusicItem(final @NonNull MusicItem musicItem) {
        Preconditions.checkNotNull((Object)musicItem);
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.appendMusicItem(musicItem);
                }
            });
            return;
        }
        this.mPlaylistEditor.appendMusicItem(musicItem);
    }

    @Override
    public void moveMusicItem(final int fromPosition, final int toPosition) throws IndexOutOfBoundsException {
        int size = this.getPlaylistSize();
        if (fromPosition < 0 || fromPosition >= size) {
            throw new IndexOutOfBoundsException("fromPosition: " + fromPosition + ", size: " + size);
        }
        if (toPosition < 0 || toPosition >= size) {
            throw new IndexOutOfBoundsException("toPosition: " + toPosition + ", size: " + size);
        }
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.moveMusicItem(fromPosition, toPosition);
                }
            });
            return;
        }
        this.mPlaylistEditor.moveMusicItem(fromPosition, toPosition);
    }

    @Override
    public void removeMusicItem(final @NonNull MusicItem musicItem) {
        Preconditions.checkNotNull((Object)musicItem);
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.removeMusicItem(musicItem);
                }
            });
            return;
        }
        this.mPlaylistEditor.removeMusicItem(musicItem);
    }

    @Override
    public void removeMusicItem(final int position) {
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.removeMusicItem(position);
                }
            });
            return;
        }
        this.mPlaylistEditor.removeMusicItem(position);
    }

    @Override
    public void setNextPlay(final @NonNull MusicItem musicItem) {
        Preconditions.checkNotNull((Object)musicItem);
        if (this.notConnected()) {
            this.tryAutoConnect(new Runnable(){

                @Override
                public void run() {
                    PlayerClient.this.setNextPlay(musicItem);
                }
            });
            return;
        }
        this.mPlaylistEditor.setNextPlay(musicItem);
    }

    private void notifySticky() {
        if (this.notConnected()) {
            return;
        }
        this.notifyPlaylistChanged();
        this.notifyPlayModeChanged();
        this.notifySpeedChanged();
        this.notifyPlayingMusicItemChanged();
        this.notifyPrepareStateChanged();
        this.notifyAudioSessionChanged();
        this.notifyPlaybackStateChanged();
        this.notifyOnBufferedProgressChanged();
        if (this.mPlayerState.isStalled()) {
            this.notifyStalledChanged();
        }
        if (this.mPlayerState.isSleepTimerStarted()) {
            this.notifySleepTimerStarted();
            if (this.mPlayerState.isSleepTimerTimeout()) {
                this.notifySleepTimerTimeout();
            }
        }
        if (this.mPlayerState.isSleepTimerEnd()) {
            this.notifySleepTimerEnd();
        }
        this.notifyWaitPlayCompleteChanged();
    }

    void initPlayerState(PlayerState playerState) {
        this.mPlayerState = playerState;
        this.mPlayerStateHelper = new PlayerStateHelper(this.mPlayerState);
    }

    private void notifyPlaybackStateChanged(Player.OnPlaybackStateChangeListener listener) {
        if (this.notConnected()) {
            return;
        }
        switch (this.mPlayerState.getPlaybackState()) {
            case PLAYING: {
                listener.onPlay(this.mPlayerState.isStalled(), this.mPlayerState.getPlayProgress(), this.mPlayerState.getPlayProgressUpdateTime());
                break;
            }
            case PAUSED: {
                listener.onPause(this.mPlayerState.getPlayProgress(), this.mPlayerState.getPlayProgressUpdateTime());
                break;
            }
            case STOPPED: {
                listener.onStop();
                break;
            }
            case ERROR: {
                listener.onError(this.mPlayerState.getErrorCode(), this.mPlayerState.getErrorMessage());
                break;
            }
        }
    }

    private void notifyPlaybackStateChanged() {
        if (this.notConnected()) {
            return;
        }
        for (Player.OnPlaybackStateChangeListener listener : this.mAllPlaybackStateChangeListener) {
            this.notifyPlaybackStateChanged(listener);
        }
        this.notifyClientPlaybackStateChanged();
    }

    private void notifyPrepareStateChanged(Player.OnPrepareListener listener) {
        if (this.notConnected()) {
            return;
        }
        if (this.mPlayerState.isPreparing()) {
            listener.onPreparing();
            return;
        }
        if (this.mPlayerState.isPrepared()) {
            listener.onPrepared(this.mPlayerState.getAudioSessionId());
            if (listener instanceof Player.OnPrepareListener2) {
                ((Player.OnPrepareListener2)listener).onPrepared(this.mPlayerState.getAudioSessionId(), this.mPlayerState.getDuration());
            }
        }
    }

    private void notifyPrepareStateChanged() {
        if (this.notConnected()) {
            return;
        }
        for (Player.OnPrepareListener listener : this.mAllPrepareListener) {
            this.notifyPrepareStateChanged(listener);
        }
    }

    private void notifyStalledChanged(Player.OnStalledChangeListener listener) {
        if (this.notConnected()) {
            return;
        }
        listener.onStalledChanged(this.mPlayerState.isStalled(), this.mPlayerState.getPlayProgress(), this.mPlayerState.getPlayProgressUpdateTime());
    }

    private void notifyStalledChanged() {
        if (this.notConnected()) {
            return;
        }
        for (Player.OnStalledChangeListener listener : this.mAllStalledChangeListener) {
            this.notifyStalledChanged(listener);
        }
    }

    private void notifyOnBufferedProgressChanged(Player.OnBufferedProgressChangeListener listener) {
        if (this.notConnected()) {
            return;
        }
        listener.onBufferedProgressChanged(this.mPlayerState.getBufferedProgress());
    }

    private void notifyOnBufferedProgressChanged() {
        if (this.notConnected()) {
            return;
        }
        for (Player.OnBufferedProgressChangeListener listener : this.mAllBufferedProgressChangeListener) {
            this.notifyOnBufferedProgressChanged(listener);
        }
    }

    private void notifyPlayingMusicItemChanged(Player.OnPlayingMusicItemChangeListener listener) {
        if (this.notConnected()) {
            return;
        }
        listener.onPlayingMusicItemChanged(this.mPlayerState.getMusicItem(), this.mPlayerState.getPlayPosition(), this.mPlayerState.getPlayProgress());
    }

    private void notifyPlayingMusicItemChanged() {
        if (this.notConnected()) {
            return;
        }
        for (Player.OnPlayingMusicItemChangeListener listener : this.mAllPlayingMusicItemChangeListener) {
            this.notifyPlayingMusicItemChanged(listener);
        }
    }

    private void notifySeekComplete(Player.OnSeekCompleteListener listener) {
        if (this.notConnected()) {
            return;
        }
        listener.onSeekComplete(this.mPlayerState.getPlayProgress(), this.mPlayerState.getPlayProgressUpdateTime(), this.mPlayerState.isStalled());
    }

    private void notifySeekComplete() {
        if (this.notConnected()) {
            return;
        }
        for (Player.OnSeekCompleteListener listener : this.mAllSeekListener) {
            this.notifySeekComplete(listener);
        }
    }

    private void notifyPlaylistChanged(Player.OnPlaylistChangeListener listener) {
        if (this.notConnected()) {
            return;
        }
        listener.onPlaylistChanged(this.mPlaylistManager, this.mPlayerState.getPlayPosition());
    }

    private void notifyPlaylistChanged() {
        if (this.notConnected()) {
            return;
        }
        for (Player.OnPlaylistChangeListener listener : this.mAllPlaylistChangeListener) {
            this.notifyPlaylistChanged(listener);
        }
    }

    private void notifyPlayModeChanged(Player.OnPlayModeChangeListener listener) {
        if (this.notConnected()) {
            return;
        }
        listener.onPlayModeChanged(this.mPlayerState.getPlayMode());
    }

    private void notifyPlayModeChanged() {
        if (this.notConnected()) {
            return;
        }
        for (Player.OnPlayModeChangeListener listener : this.mAllPlayModeChangeListener) {
            this.notifyPlayModeChanged(listener);
        }
    }

    private void notifySpeedChanged(Player.OnSpeedChangeListener listener) {
        if (this.notConnected()) {
            return;
        }
        listener.onSpeedChanged(this.mPlayerState.getSpeed(), this.mPlayerState.getPlayProgress(), this.mPlayerState.getPlayProgressUpdateTime());
    }

    private void notifySpeedChanged() {
        if (this.notConnected()) {
            return;
        }
        for (Player.OnSpeedChangeListener listener : this.mAllSpeedChangeListener) {
            this.notifySpeedChanged(listener);
        }
    }

    private void notifyClientPlaybackStateChanged() {
        if (this.notConnected()) {
            return;
        }
        for (OnPlaybackStateChangeListener listener : this.mClientAllPlaybackStateChangeListener) {
            this.notifyClientPlaybackStateChanged(listener);
        }
    }

    private void notifyClientPlaybackStateChanged(OnPlaybackStateChangeListener listener) {
        if (this.notConnected()) {
            return;
        }
        listener.onPlaybackStateChanged(this.mPlayerState.getPlaybackState(), this.mPlayerState.isStalled());
    }

    private void notifyAudioSessionChanged() {
        if (this.notConnected()) {
            return;
        }
        for (OnAudioSessionChangeListener listener : this.mAllAudioSessionChangeListener) {
            this.notifyAudioSessionChanged(listener);
        }
    }

    private void notifyAudioSessionChanged(OnAudioSessionChangeListener listener) {
        if (this.notConnected()) {
            return;
        }
        listener.onAudioSessionChanged(this.mPlayerState.getAudioSessionId());
    }

    private void notifySleepTimerStarted() {
        if (this.notConnected()) {
            return;
        }
        for (SleepTimer.OnStateChangeListener listener : this.mAllSleepTimerStateChangeListener) {
            this.notifySleepTimerStarted(listener);
        }
    }

    private void notifySleepTimerStarted(SleepTimer.OnStateChangeListener listener) {
        listener.onTimerStart(this.mPlayerState.getSleepTimerTime(), this.mPlayerState.getSleepTimerStartTime(), this.mPlayerState.getTimeoutAction());
        if (listener instanceof SleepTimer.OnStateChangeListener2) {
            ((SleepTimer.OnStateChangeListener2)listener).onTimerStart(this.mPlayerState.getSleepTimerTime(), this.mPlayerState.getSleepTimerStartTime(), this.mPlayerState.getTimeoutAction(), this.mPlayerState.isWaitPlayComplete());
        }
    }

    private void notifySleepTimerEnd() {
        if (this.notConnected()) {
            return;
        }
        for (SleepTimer.OnStateChangeListener listener : this.mAllSleepTimerStateChangeListener) {
            this.notifySleepTimerEnd(listener);
        }
    }

    private void notifySleepTimerEnd(SleepTimer.OnStateChangeListener listener) {
        listener.onTimerEnd();
    }

    private void notifySleepTimerTimeout() {
        if (this.notConnected()) {
            return;
        }
        for (SleepTimer.OnStateChangeListener listener : this.mAllSleepTimerStateChangeListener) {
            this.notifySleepTimerTimeout(listener);
        }
    }

    private void notifySleepTimerTimeout(SleepTimer.OnStateChangeListener listener) {
        if (listener instanceof SleepTimer.OnStateChangeListener2) {
            ((SleepTimer.OnStateChangeListener2)listener).onTimeout(this.mPlayerState.isSleepTimerEnd());
        }
    }

    private void notifyWaitPlayCompleteChanged() {
        if (this.notConnected()) {
            return;
        }
        for (SleepTimer.OnWaitPlayCompleteChangeListener listener : this.mAllWaitPlayCompleteChangeListener) {
            this.notifyWaitPlayCompleteChanged(listener);
        }
    }

    private void notifyWaitPlayCompleteChanged(SleepTimer.OnWaitPlayCompleteChangeListener listener) {
        if (this.notConnected()) {
            return;
        }
        listener.onWaitPlayCompleteChanged(this.mPlayerState.isWaitPlayComplete());
    }

    private void notifyRepeat(@NonNull MusicItem musicItem, long repeatTime) {
        for (Player.OnRepeatListener listener : this.mAllRepeatListener) {
            listener.onRepeat(musicItem, repeatTime);
        }
    }

    private static class DestroyObserver
    implements LifecycleObserver {
        private final Runnable mOnDestroyAction;

        DestroyObserver(@NonNull Runnable action) {
            Preconditions.checkNotNull((Object)action);
            this.mOnDestroyAction = action;
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
        public void onDestroy() {
            this.mOnDestroyAction.run();
        }
    }

    private class PlayerStateListenerImpl
    implements PlayerStateListener,
    SleepTimer.OnStateChangeListener2,
    SleepTimer.OnWaitPlayCompleteChangeListener {
        private PlayerStateListenerImpl() {
        }

        @Override
        public void onPreparing() {
            boolean error = PlayerClient.this.mPlayerState.getPlaybackState() == PlaybackState.ERROR;
            PlayerClient.this.mPlayerStateHelper.onPreparing();
            if (error) {
                PlayerClient.this.notifyPlaybackStateChanged();
            }
            PlayerClient.this.notifyPrepareStateChanged();
        }

        @Override
        public void onPrepared(int audioSessionId) {
        }

        @Override
        public void onPrepared(int audioSessionId, int duration) {
            PlayerClient.this.mPlayerStateHelper.onPrepared(audioSessionId, duration);
            PlayerClient.this.notifyPrepareStateChanged();
            PlayerClient.this.notifyAudioSessionChanged();
        }

        @Override
        public void onPlay(boolean stalled, int playProgress, long playProgressUpdateTime) {
            PlayerClient.this.mPlayerStateHelper.onPlay(stalled, playProgress, playProgressUpdateTime);
            PlayerClient.this.notifyPlaybackStateChanged();
        }

        @Override
        public void onPause(int playProgress, long updateTime) {
            PlayerClient.this.mPlayerStateHelper.onPaused(playProgress, updateTime);
            PlayerClient.this.notifyPlaybackStateChanged();
        }

        @Override
        public void onStop() {
            PlayerClient.this.mPlayerStateHelper.onStopped();
            PlayerClient.this.notifyPlaybackStateChanged();
        }

        @Override
        public void onError(int errorCode, String errorMessage) {
            PlayerClient.this.mPlayerStateHelper.onError(errorCode, errorMessage);
            PlayerClient.this.notifyPlaybackStateChanged();
        }

        @Override
        public void onSeekComplete(int progress, long updateTime, boolean stalled) {
            PlayerClient.this.mPlayerStateHelper.onSeekComplete(progress, updateTime, stalled);
            PlayerClient.this.notifySeekComplete();
        }

        @Override
        public void onBufferedProgressChanged(int bufferedProgress) {
            PlayerClient.this.mPlayerStateHelper.onBufferedChanged(bufferedProgress);
            PlayerClient.this.notifyOnBufferedProgressChanged();
        }

        @Override
        public void onPlayingMusicItemChanged(@Nullable MusicItem musicItem, int position, int playProgress) {
            boolean error = PlayerClient.this.mPlayerState.getPlaybackState() == PlaybackState.ERROR;
            PlayerClient.this.mPlayerStateHelper.onPlayingMusicItemChanged(musicItem, position, playProgress);
            PlayerClient.this.notifyPlayingMusicItemChanged();
            if (error) {
                PlayerClient.this.notifyPlaybackStateChanged();
            }
        }

        @Override
        public void onStalledChanged(boolean stalled, int playProgress, long updateTime) {
            PlayerClient.this.mPlayerStateHelper.onStalled(stalled, playProgress, updateTime);
            PlayerClient.this.notifyStalledChanged();
        }

        @Override
        public void onPlaylistChanged(PlaylistManager playlistManager, int position) {
            PlayerClient.this.mPlayerStateHelper.onPlaylistChanged(position);
            PlayerClient.this.notifyPlaylistChanged();
        }

        @Override
        public void onPlayModeChanged(PlayMode playMode) {
            PlayerClient.this.mPlayerStateHelper.onPlayModeChanged(playMode);
            PlayerClient.this.notifyPlayModeChanged();
        }

        @Override
        public void onTimerStart(long time, long startTime, SleepTimer.TimeoutAction action) {
        }

        @Override
        public void onTimerEnd() {
            PlayerClient.this.mPlayerStateHelper.onSleepTimerEnd();
            PlayerClient.this.notifySleepTimerEnd();
        }

        @Override
        public void onShutdown() {
            PlayerClient.this.disconnect();
        }

        @Override
        public void onRepeat(@NonNull MusicItem musicItem, long repeatTime) {
            PlayerClient.this.mPlayerStateHelper.onRepeat(repeatTime);
            PlayerClient.this.notifyRepeat(musicItem, repeatTime);
        }

        @Override
        public void onSpeedChanged(float speed, int playProgress, long playProgressUpdateTime) {
            PlayerClient.this.mPlayerStateHelper.onSpeedChanged(speed, playProgress, playProgressUpdateTime);
            PlayerClient.this.notifySpeedChanged();
        }

        @Override
        public void onTimerStart(long time, long startTime, SleepTimer.TimeoutAction action, boolean waitPlayComplete) {
            PlayerClient.this.mPlayerStateHelper.onSleepTimerStart(time, startTime, action);
            PlayerClient.this.notifySleepTimerStarted();
        }

        @Override
        public void onWaitPlayCompleteChanged(boolean waitPlayComplete) {
            PlayerClient.this.mPlayerStateHelper.onWaitPlayCompleteChanged(waitPlayComplete);
            PlayerClient.this.notifyWaitPlayCompleteChanged();
        }

        @Override
        public void onTimeout(boolean actionComplete) {
            PlayerClient.this.mPlayerStateHelper.onSleepTimerTimeout(actionComplete);
            PlayerClient.this.notifySleepTimerTimeout();
        }
    }

    public static interface OnAudioSessionChangeListener {
        public void onAudioSessionChanged(int var1);
    }

    public static interface OnPlaybackStateChangeListener {
        public void onPlaybackStateChanged(PlaybackState var1, boolean var2);
    }

    public static interface OnConnectStateChangeListener {
        public void onConnectStateChanged(boolean var1);
    }

    public static interface OnConnectCallback {
        public void onConnected(boolean var1);
    }
}

