/*
 * Decompiled with CFR 0.152.
 */
package snow.player.util;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class Util {
    private static final String TAG = "Util";
    private static boolean isInfoReaded;
    private static String sMiuiVersionName;

    public static boolean isMIUI() {
        Util.checkReadInfo();
        return !TextUtils.isEmpty((CharSequence)sMiuiVersionName);
    }

    public static boolean isMIUI13() {
        Util.checkReadInfo();
        return "v130".equals(sMiuiVersionName);
    }

    @SuppressLint(value={"PrivateApi"})
    private static void checkReadInfo() {
        if (isInfoReaded) {
            return;
        }
        isInfoReaded = true;
        Properties properties = new Properties();
        if (Build.VERSION.SDK_INT < 26) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
                properties.load(fileInputStream);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"read file error");
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            Class<?> clzSystemProperties = Class.forName("android.os.SystemProperties");
            Method getMethod = clzSystemProperties.getDeclaredMethod("get", String.class);
            sMiuiVersionName = Util.getLowerCaseName(properties, getMethod);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"read SystemProperties error");
        }
    }

    @Nullable
    private static String getLowerCaseName(Properties p, Method get) {
        String key = "ro.miui.ui.version.name";
        String name = p.getProperty(key);
        if (name == null) {
            try {
                name = (String)get.invoke(null, key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (name != null) {
            name = name.toLowerCase();
        }
        return name;
    }
}

