/*
 * Decompiled with CFR 0.152.
 */
package snow.player.util;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.google.common.base.Preconditions;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class ProgressClock {
    private static final String TAG = "ProgressClock";
    private final boolean mCountDown;
    private boolean mEnabled;
    private final Callback mCallback;
    private float mProgressSec;
    private int mDurationSec;
    private Disposable mDisposable;
    private float mSpeed = 1.0f;

    public ProgressClock(@NonNull Callback callback) {
        this(false, callback);
    }

    public ProgressClock(boolean countDown, @NonNull Callback callback) {
        Preconditions.checkNotNull((Object)callback);
        this.mEnabled = true;
        this.mCountDown = countDown;
        this.mCallback = callback;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public boolean isCountDown() {
        return this.mCountDown;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
        if (!this.mEnabled) {
            this.cancel();
        }
    }

    public void setSpeed(float speed) {
        this.mSpeed = speed;
        if (speed <= 0.0f) {
            this.cancelTimer();
        }
    }

    public void start(int progress, long updateTime, int duration) {
        this.start(progress, updateTime, duration, 1.0f);
    }

    public void start(int progress, long updateTime, int duration, float speed) throws IllegalArgumentException {
        this.cancelTimer();
        this.mSpeed = speed;
        if (duration < 1) {
            this.mCallback.onUpdateProgress(0, 0);
            return;
        }
        if (this.mSpeed <= 0.0f) {
            return;
        }
        long currentTime = SystemClock.elapsedRealtime();
        if (updateTime > currentTime) {
            updateTime = currentTime;
            throw new IllegalArgumentException("updateTime > currentTime. updateTime=" + updateTime + ", currentTime=" + currentTime);
        }
        long realProgress = (long)((float)progress + (float)(currentTime - updateTime) * speed);
        this.mProgressSec = this.mCountDown ? (float)((int)Math.ceil((double)((long)duration - realProgress) / 1000.0)) : (float)((int)(realProgress / 1000L));
        this.mDurationSec = duration / 1000;
        if (!this.mEnabled) {
            this.mCallback.onUpdateProgress(Math.round(this.mProgressSec), this.mDurationSec);
            return;
        }
        if (this.isTimeout()) {
            this.notifyTimeout();
            return;
        }
        this.updateProgress(this.mProgressSec);
        long delay = 1000L - realProgress % 1000L;
        this.mDisposable = Observable.interval((long)delay, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.computation()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) {
                if (ProgressClock.this.mCountDown) {
                    ProgressClock.this.decrease();
                } else {
                    ProgressClock.this.increase();
                }
            }
        });
    }

    private boolean isTimeout() {
        if (this.mCountDown) {
            return this.mProgressSec <= 0.0f;
        }
        return this.mProgressSec >= (float)this.mDurationSec;
    }

    private void notifyTimeout() {
        if (this.mCountDown) {
            this.mCallback.onUpdateProgress(0, this.mDurationSec);
            return;
        }
        this.mCallback.onUpdateProgress(this.mDurationSec, this.mDurationSec);
    }

    public void cancel() {
        this.cancelTimer();
    }

    private void cancelTimer() {
        if (this.mDisposable != null && !this.mDisposable.isDisposed()) {
            this.mDisposable.dispose();
            this.mDisposable = null;
        }
    }

    private void increase() {
        float newProgress = this.mProgressSec + 1.0f * this.mSpeed;
        if (newProgress >= (float)this.mDurationSec) {
            this.cancel();
        }
        this.updateProgress(newProgress);
    }

    private void decrease() {
        float newProgress = this.mProgressSec - 1.0f * this.mSpeed;
        if (newProgress <= 0.0f) {
            this.cancel();
        }
        this.updateProgress(newProgress);
    }

    private void updateProgress(float progressSec) {
        this.mProgressSec = progressSec;
        this.mCallback.onUpdateProgress(Math.min(Math.round(this.mProgressSec), this.mDurationSec), this.mDurationSec);
    }

    public static String asText(int seconds) {
        if (seconds <= 0) {
            return "00:00";
        }
        int maxSeconds = 359999;
        if (seconds >= maxSeconds) {
            return "99:59:59";
        }
        int second = seconds % 60;
        int minute = seconds / 60 % 60;
        int hour = seconds / 3600;
        if (hour <= 0) {
            return String.format(Locale.ENGLISH, "%02d:%02d", minute, second);
        }
        return String.format(Locale.ENGLISH, "%02d:%02d:%02d", hour, minute, second);
    }

    public static interface Callback {
        public void onUpdateProgress(int var1, int var2);
    }
}

