/*
 * Decompiled with CFR 0.152.
 */
package snow.player.util;

import android.content.Context;
import androidx.annotation.NonNull;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.List;
import snow.player.R;
import snow.player.audio.MusicItem;

public final class MusicItemUtil {
    private MusicItemUtil() {
        throw new AssertionError();
    }

    public static String getTitle(@NonNull MusicItem musicItem, @NonNull String defaultTitle) {
        Preconditions.checkNotNull((Object)musicItem);
        Preconditions.checkNotNull((Object)defaultTitle);
        return MusicItemUtil.getStringOrDefault(musicItem.getTitle(), defaultTitle);
    }

    public static String getArtist(@NonNull MusicItem musicItem, @NonNull String defaultArtist) {
        Preconditions.checkNotNull((Object)musicItem);
        Preconditions.checkNotNull((Object)defaultArtist);
        return MusicItemUtil.getStringOrDefault(musicItem.getArtist(), defaultArtist);
    }

    public static String getAlbum(@NonNull MusicItem musicItem, @NonNull String defaultAlbum) {
        Preconditions.checkNotNull((Object)musicItem);
        Preconditions.checkNotNull((Object)defaultAlbum);
        return MusicItemUtil.getStringOrDefault(musicItem.getAlbum(), defaultAlbum);
    }

    public static String getTitle(@NonNull Context context, @NonNull MusicItem musicItem) {
        return MusicItemUtil.getTitle(musicItem, context.getString(R.string.snow_music_item_unknown_title));
    }

    public static String getArtist(@NonNull Context context, @NonNull MusicItem musicItem) {
        return MusicItemUtil.getArtist(musicItem, context.getString(R.string.snow_music_item_unknown_artist));
    }

    public static String getAlbum(@NonNull Context context, @NonNull MusicItem musicItem) {
        return MusicItemUtil.getAlbum(musicItem, context.getString(R.string.snow_music_item_unknown_album));
    }

    private static String getStringOrDefault(String value, String defaultValue) {
        return value.isEmpty() ? defaultValue : value;
    }

    public static <T> String generateToken(List<T> items, GetUriFunction<T> function) {
        Hasher hasher = Hashing.sha256().newHasher();
        for (T item : items) {
            hasher.putString((CharSequence)function.getUri(item), Charsets.UTF_8);
        }
        return hasher.hash().toString();
    }

    public static interface GetUriFunction<T> {
        @NonNull
        public String getUri(T var1);
    }
}

