/*
 * Decompiled with CFR 0.152.
 */
package snow.player.util;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.MediaStore;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleObserver;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class AudioScanner<T> {
    private final Context mContext;
    private final Converter<T> mConverter;
    @Nullable
    private String[] mProjection;
    @Nullable
    private String mSelection;
    @Nullable
    private String[] mSelectionArgs;
    @Nullable
    private String mSortOrder;
    private OnProgressUpdateListener<T> mListener;
    private final AtomicBoolean mScanning;
    private final AtomicBoolean mCancelled;
    private final Handler mHandler;

    public AudioScanner(@androidx.annotation.NonNull Context context, @androidx.annotation.NonNull Converter<T> converter) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull(converter);
        this.mContext = context;
        this.mConverter = converter;
        this.mScanning = new AtomicBoolean(false);
        this.mCancelled = new AtomicBoolean(false);
        this.mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(@androidx.annotation.NonNull Message msg) {
                AudioScanner.this.mListener.onProgressUpdate(msg.arg1);
                return true;
            }
        });
    }

    public void setQueryParams(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        this.mProjection = projection;
        this.mSelection = selection;
        this.mSelectionArgs = selectionArgs;
        this.mSortOrder = sortOrder;
    }

    public void scan(@androidx.annotation.NonNull OnProgressUpdateListener<T> listener) {
        Preconditions.checkNotNull(listener);
        if (this.isScanning()) {
            return;
        }
        this.mListener = listener;
        this.mScanning.set(true);
        this.mCancelled.set(false);
        Single.create((SingleOnSubscribe)new SingleOnSubscribe<List<T>>(){

            public void subscribe(@NonNull SingleEmitter<List<T>> emitter) {
                Cursor cursor = AudioScanner.this.mContext.getContentResolver().query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, AudioScanner.this.mProjection, AudioScanner.this.mSelection, AudioScanner.this.mSelectionArgs, AudioScanner.this.mSortOrder);
                ArrayList result = new ArrayList(cursor.getCount());
                if (AudioScanner.this.mCancelled.get()) {
                    emitter.onSuccess(result);
                    return;
                }
                if (cursor == null || !cursor.moveToFirst()) {
                    cursor.close();
                    emitter.onSuccess(result);
                    return;
                }
                int progress = 0;
                int count = cursor.getCount();
                do {
                    ++progress;
                    Object item = AudioScanner.this.mConverter.convert(cursor);
                    if (item != null) {
                        result.add(item);
                    }
                    AudioScanner.this.notifyProgressUpdate(Math.round((float)progress * 1.0f / (float)count * 100.0f));
                } while (cursor.moveToNext() && !AudioScanner.this.mCancelled.get());
                cursor.close();
                emitter.onSuccess(result);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new SingleObserver<List<T>>(){

            public void onSubscribe(@androidx.annotation.NonNull Disposable d) {
                AudioScanner.this.mListener.onStart();
            }

            public void onSuccess(@androidx.annotation.NonNull List<T> ts) {
                AudioScanner.this.mScanning.set(false);
                AudioScanner.this.mListener.onEnd(ts, AudioScanner.this.mCancelled.get());
            }

            public void onError(@androidx.annotation.NonNull Throwable e) {
            }
        });
    }

    private void notifyProgressUpdate(int progress) {
        Message message = this.mHandler.obtainMessage();
        message.arg1 = progress;
        this.mHandler.sendMessage(message);
    }

    public boolean isScanning() {
        return this.mScanning.get();
    }

    public void cancel() {
        this.mCancelled.set(true);
    }

    public static int getDateAdded(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("date_added"));
    }

    public static int getDateModified(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("date_modified"));
    }

    public static String getDisplayName(Cursor cursor) {
        return cursor.getString(cursor.getColumnIndexOrThrow("_display_name"));
    }

    public static String getMimeType(Cursor cursor) {
        return cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
    }

    public static int getSize(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("_size"));
    }

    @SuppressLint(value={"InlinedApi"})
    public static int getDuration(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("duration"));
    }

    public static String getTitle(Cursor cursor) {
        return cursor.getString(cursor.getColumnIndexOrThrow("title"));
    }

    public static int getId(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
    }

    @SuppressLint(value={"InlinedApi"})
    public static String getArtist(Cursor cursor) {
        return cursor.getString(cursor.getColumnIndexOrThrow("artist"));
    }

    public static int getArtistId(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("artist_id"));
    }

    @SuppressLint(value={"InlinedApi"})
    public static String getAlbum(Cursor cursor) {
        return cursor.getString(cursor.getColumnIndexOrThrow("album"));
    }

    public static int getAlbumId(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("album_id"));
    }

    public static boolean isAlarm(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("is_alarm")) != 0;
    }

    @RequiresApi(value=29)
    public static boolean isAudioBook(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("is_audiobook")) != 0;
    }

    public static boolean isNotification(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("is_notification")) != 0;
    }

    public static boolean isPodcast(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("is_podcast")) != 0;
    }

    public static boolean isRingtone(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("is_ringtone")) != 0;
    }

    public static int getTrack(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("track"));
    }

    public static int getYear(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndexOrThrow("year"));
    }

    public static Uri getUri(Cursor cursor) {
        return ContentUris.withAppendedId((Uri)MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, (long)AudioScanner.getId(cursor));
    }

    public static interface Converter<T> {
        @Nullable
        public T convert(@androidx.annotation.NonNull Cursor var1);
    }

    public static interface OnProgressUpdateListener<T> {
        public void onStart();

        public void onProgressUpdate(int var1);

        public void onEnd(@androidx.annotation.NonNull List<T> var1, boolean var2);
    }

    public static class AudioItemConverter
    implements Converter<AudioItem> {
        @Override
        @Nullable
        public AudioItem convert(@androidx.annotation.NonNull Cursor cursor) {
            long id = AudioScanner.getId(cursor);
            String displayName = AudioScanner.getDisplayName(cursor);
            String title = AudioScanner.getTitle(cursor);
            String artist = AudioScanner.getArtist(cursor);
            int artistId = AudioScanner.getArtistId(cursor);
            String album = AudioScanner.getAlbum(cursor);
            int albumId = AudioScanner.getAlbumId(cursor);
            String mimeType = AudioScanner.getMimeType(cursor);
            String uri = AudioScanner.getUri(cursor).toString();
            long duration = AudioScanner.getDuration(cursor);
            int dateAdded = AudioScanner.getDateAdded(cursor);
            int dateModified = AudioScanner.getDateModified(cursor);
            int size = AudioScanner.getSize(cursor);
            int track = AudioScanner.getTrack(cursor);
            int year = AudioScanner.getYear(cursor);
            boolean alarm = AudioScanner.isAlarm(cursor);
            boolean audioBook = false;
            if (Build.VERSION.SDK_INT >= 29) {
                audioBook = AudioScanner.isAudioBook(cursor);
            }
            boolean notification = AudioScanner.isNotification(cursor);
            boolean podcast = AudioScanner.isPodcast(cursor);
            boolean ringtone = AudioScanner.isRingtone(cursor);
            return new AudioItem(id, displayName, title, artist, artistId, album, albumId, mimeType, uri, duration, dateAdded, dateModified, size, track, year, alarm, audioBook, notification, podcast, ringtone);
        }
    }

    public static class AudioItem {
        private long id;
        private String displayName;
        private String title;
        private String artist;
        private int artistId;
        private String album;
        private int albumId;
        private String mimeType;
        private String uri;
        private long duration;
        private int dateAdded;
        private int dateModified;
        private int size;
        private int track;
        private int year;
        private boolean alarm;
        private boolean audioBook;
        private boolean notification;
        private boolean podcast;
        private boolean ringtone;

        public AudioItem(long id, String displayName, String title, String artist, int artistId, String album, int albumId, String mimeType, String uri, long duration, int dateAdded, int dateModified, int size, int track, int year, boolean alarm, boolean audioBook, boolean notification, boolean podcast, boolean ringtone) {
            this.id = id;
            this.displayName = displayName;
            this.title = title;
            this.artist = artist;
            this.artistId = artistId;
            this.album = album;
            this.albumId = albumId;
            this.mimeType = mimeType;
            this.uri = uri;
            this.duration = duration;
            this.dateAdded = dateAdded;
            this.dateModified = dateModified;
            this.size = size;
            this.track = track;
            this.year = year;
            this.alarm = alarm;
            this.audioBook = audioBook;
            this.notification = notification;
            this.podcast = podcast;
            this.ringtone = ringtone;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getArtist() {
            return this.artist;
        }

        public void setArtist(String artist) {
            this.artist = artist;
        }

        public int getArtistId() {
            return this.artistId;
        }

        public void setArtistId(int artistId) {
            this.artistId = artistId;
        }

        public String getAlbum() {
            return this.album;
        }

        public void setAlbum(String album) {
            this.album = album;
        }

        public int getAlbumId() {
            return this.albumId;
        }

        public void setAlbumId(int albumId) {
            this.albumId = albumId;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public int getDateAdded() {
            return this.dateAdded;
        }

        public void setDateAdded(int dateAdded) {
            this.dateAdded = dateAdded;
        }

        public int getDateModified() {
            return this.dateModified;
        }

        public void setDateModified(int dateModified) {
            this.dateModified = dateModified;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getTrack() {
            return this.track;
        }

        public void setTrack(int track) {
            this.track = track;
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public boolean isAlarm() {
            return this.alarm;
        }

        public void setAlarm(boolean alarm) {
            this.alarm = alarm;
        }

        public boolean isAudioBook() {
            return this.audioBook;
        }

        public void setAudioBook(boolean audioBook) {
            this.audioBook = audioBook;
        }

        public boolean isNotification() {
            return this.notification;
        }

        public void setNotification(boolean notification) {
            this.notification = notification;
        }

        public boolean isPodcast() {
            return this.podcast;
        }

        public void setPodcast(boolean podcast) {
            this.podcast = podcast;
        }

        public boolean isRingtone() {
            return this.ringtone;
        }

        public void setRingtone(boolean ringtone) {
            this.ringtone = ringtone;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AudioItem audioItem = (AudioItem)o;
            return this.id == audioItem.id && this.artistId == audioItem.artistId && this.albumId == audioItem.albumId && this.duration == audioItem.duration && this.dateAdded == audioItem.dateAdded && this.dateModified == audioItem.dateModified && this.size == audioItem.size && this.track == audioItem.track && this.year == audioItem.year && this.alarm == audioItem.alarm && this.audioBook == audioItem.audioBook && this.notification == audioItem.notification && this.podcast == audioItem.podcast && this.ringtone == audioItem.ringtone && Objects.equal((Object)this.displayName, (Object)audioItem.displayName) && Objects.equal((Object)this.title, (Object)audioItem.title) && Objects.equal((Object)this.artist, (Object)audioItem.artist) && Objects.equal((Object)this.album, (Object)audioItem.album) && Objects.equal((Object)this.mimeType, (Object)audioItem.mimeType) && Objects.equal((Object)this.uri, (Object)audioItem.uri);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.displayName, this.title, this.artist, this.artistId, this.album, this.albumId, this.mimeType, this.uri, this.duration, this.dateAdded, this.dateModified, this.size, this.track, this.year, this.alarm, this.audioBook, this.notification, this.podcast, this.ringtone});
        }

        @androidx.annotation.NonNull
        public String toString() {
            return "AudioItem{id=" + this.id + ", displayName='" + this.displayName + '\'' + ", title='" + this.title + '\'' + ", artist='" + this.artist + '\'' + ", artistId=" + this.artistId + ", album='" + this.album + '\'' + ", albumId=" + this.albumId + ", mimeType='" + this.mimeType + '\'' + ", uri='" + this.uri + '\'' + ", duration=" + this.duration + ", dateAdded=" + this.dateAdded + ", dateModified=" + this.dateModified + ", size=" + this.size + ", track=" + this.track + ", year=" + this.year + ", alarm=" + this.alarm + ", audioBook=" + this.audioBook + ", notification=" + this.notification + ", podcast=" + this.podcast + ", ringtone=" + this.ringtone + '}';
        }
    }
}

