/*
 * Decompiled with CFR 0.152.
 */
package snow.player.playlist;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import snow.player.audio.MusicItem;
import snow.player.util.MusicItemUtil;

public final class Playlist
implements Iterable<MusicItem>,
Parcelable {
    private static final String TAG = "Playlist";
    public static final int MAX_SIZE = 1000;
    private final String mName;
    private final String mToken;
    private final ArrayList<MusicItem> mMusicItems;
    private final boolean mEditable;
    @Nullable
    private final Bundle mExtra;
    public static final Parcelable.Creator<Playlist> CREATOR = new Parcelable.Creator<Playlist>(){

        public Playlist createFromParcel(Parcel in) {
            return new Playlist(in);
        }

        public Playlist[] newArray(int size) {
            return new Playlist[size];
        }
    };

    public Playlist(@NonNull String name, @NonNull List<MusicItem> items, boolean editable, @Nullable Bundle extra) {
        this(name, items, 0, editable, extra);
    }

    public Playlist(@NonNull String name, @NonNull List<MusicItem> items, int position, boolean editable, @Nullable Bundle extra) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(items);
        this.mName = name;
        this.mMusicItems = this.trim(this.excludeRepeatItem(items), position);
        this.mEditable = editable;
        this.mExtra = extra;
        this.mToken = this.generateToken();
    }

    private ArrayList<MusicItem> excludeRepeatItem(List<MusicItem> items) {
        ArrayList<MusicItem> musicItems = new ArrayList<MusicItem>();
        for (MusicItem item : items) {
            if (musicItems.contains(item)) continue;
            musicItems.add(item);
        }
        return musicItems;
    }

    private ArrayList<MusicItem> trim(ArrayList<MusicItem> musicItems, int position) {
        int size = musicItems.size();
        int start = 0;
        int end = musicItems.size();
        if (size > 1000) {
            start = position - Math.max(0, 1000 - (size - position));
            end = position + Math.min(1000, size - position);
        }
        return new ArrayList<MusicItem>(musicItems.subList(start, end));
    }

    private String generateToken() {
        return MusicItemUtil.generateToken(this.mMusicItems, new MusicItemUtil.GetUriFunction<MusicItem>(){

            @Override
            @NonNull
            public String getUri(MusicItem item) {
                return item.getUri();
            }
        });
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public String getToken() {
        return this.mToken;
    }

    public boolean isEditable() {
        return this.mEditable;
    }

    public boolean contains(MusicItem musicItem) {
        return this.mMusicItems.contains(musicItem);
    }

    public MusicItem get(int index) throws IndexOutOfBoundsException {
        return this.mMusicItems.get(index);
    }

    public int indexOf(@NonNull MusicItem musicItem) {
        Preconditions.checkNotNull((Object)musicItem);
        return this.mMusicItems.indexOf(musicItem);
    }

    public boolean isEmpty() {
        return this.mMusicItems.isEmpty();
    }

    @Override
    @NonNull
    public Iterator<MusicItem> iterator() {
        return new Iterator<MusicItem>(){
            private final Iterator<MusicItem> iterator;
            {
                this.iterator = Playlist.this.mMusicItems.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public MusicItem next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                Log.e((String)Playlist.TAG, (String)"unsupported operation");
            }
        };
    }

    public int size() {
        return this.mMusicItems.size();
    }

    public List<MusicItem> getAllMusicItem() {
        return new ArrayList<MusicItem>(this.mMusicItems);
    }

    @Nullable
    public Bundle getExtra() {
        return this.mExtra;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Playlist)) {
            return false;
        }
        Playlist other = (Playlist)obj;
        return Objects.equal((Object)this.mName, (Object)other.mName) && Objects.equal((Object)this.mToken, (Object)other.mToken) && Objects.equal(this.mMusicItems, other.mMusicItems) && Objects.equal((Object)this.mEditable, (Object)other.mEditable);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mName, this.mToken, this.mMusicItems, this.mEditable});
    }

    protected Playlist(Parcel in) {
        this.mName = in.readString();
        this.mToken = in.readString();
        this.mMusicItems = in.createTypedArrayList(MusicItem.CREATOR);
        this.mEditable = in.readByte() != 0;
        this.mExtra = in.readBundle(Thread.currentThread().getContextClassLoader());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeString(this.mToken);
        dest.writeTypedList(this.mMusicItems);
        dest.writeByte((byte)(this.mEditable ? 1 : 0));
        dest.writeBundle(this.mExtra);
    }

    public int describeContents() {
        return 0;
    }

    public static final class Builder {
        private String mName = "";
        private final List<MusicItem> mMusicItems = new ArrayList<MusicItem>();
        private boolean mEditable = true;
        private Bundle mExtra;
        private int mPosition = 0;

        public Builder setName(@NonNull String name) {
            Preconditions.checkNotNull((Object)name);
            this.mName = name;
            return this;
        }

        public Builder setEditable(boolean editable) {
            this.mEditable = editable;
            return this;
        }

        public Builder append(@NonNull MusicItem musicItem) {
            Preconditions.checkNotNull((Object)musicItem);
            this.mMusicItems.add(musicItem);
            return this;
        }

        public Builder appendAll(@NonNull List<MusicItem> musicItems) {
            Preconditions.checkNotNull(musicItems);
            this.mMusicItems.addAll(musicItems);
            return this;
        }

        public Builder remove(@NonNull MusicItem musicItem) {
            Preconditions.checkNotNull((Object)musicItem);
            this.mMusicItems.remove(musicItem);
            return this;
        }

        public Builder removeAll(@NonNull List<MusicItem> musicItems) {
            Preconditions.checkNotNull(musicItems);
            this.mMusicItems.removeAll(musicItems);
            return this;
        }

        public Builder setPosition(int position) {
            this.mPosition = position;
            return this;
        }

        public Builder setExtra(@Nullable Bundle extra) {
            this.mExtra = extra;
            return this;
        }

        public Playlist build() {
            return new Playlist(this.mName, this.mMusicItems, this.mPosition, this.mEditable, this.mExtra);
        }
    }
}

