/*
 * Decompiled with CFR 0.152.
 */
package snow.player.lifecycle;

import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import com.google.common.base.Preconditions;
import snow.player.Player;
import snow.player.PlayerClient;
import snow.player.playlist.Playlist;
import snow.player.playlist.PlaylistManager;

public class PlaylistLiveData
extends LiveData<Playlist>
implements Player.OnPlaylistChangeListener {
    private static final String TAG = "PlaylistLiveData";
    private PlayerClient mPlayerClient;
    private boolean mLazy;

    public PlaylistLiveData(@NonNull PlayerClient playerClient, Playlist value) {
        this(playerClient, value, true);
    }

    public PlaylistLiveData(@NonNull PlayerClient playerClient, Playlist value, boolean lazy) {
        super((Object)value);
        Preconditions.checkNotNull((Object)playerClient);
        this.mPlayerClient = playerClient;
        this.mLazy = lazy;
        if (this.mLazy) {
            return;
        }
        this.observePlaylist();
    }

    public boolean isLazy() {
        return this.mLazy;
    }

    protected void onActive() {
        this.observePlaylist();
    }

    protected void onInactive() {
        this.mPlayerClient.removeOnPlaylistChangeListener(this);
    }

    @Override
    public void onPlaylistChanged(PlaylistManager playlistManager, int position) {
        playlistManager.getPlaylist(new PlaylistManager.Callback(){

            @Override
            public void onFinished(@NonNull Playlist playlist) {
                PlaylistLiveData.this.setValue(playlist);
            }
        });
    }

    private void observePlaylist() {
        this.mPlayerClient.addOnPlaylistChangeListener(this);
    }
}

