/*
 * Decompiled with CFR 0.152.
 */
package snow.player.lifecycle;

import android.content.Context;
import android.os.SystemClock;
import android.widget.SeekBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import com.google.common.base.Preconditions;
import snow.player.PlayMode;
import snow.player.PlaybackState;
import snow.player.Player;
import snow.player.PlayerClient;
import snow.player.R;
import snow.player.SleepTimer;
import snow.player.audio.MusicItem;
import snow.player.playlist.Playlist;
import snow.player.playlist.PlaylistManager;
import snow.player.util.MusicItemUtil;
import snow.player.util.ProgressClock;

public class PlayerViewModel
extends ViewModel {
    private PlayerClient mPlayerClient;
    private MutableLiveData<String> mTitle;
    private MutableLiveData<String> mArtist;
    private MutableLiveData<String> mAlbum;
    private MutableLiveData<String> mIconUri;
    private MutableLiveData<Integer> mDuration;
    private MutableLiveData<Integer> mPlayProgress;
    private MutableLiveData<Integer> mBufferedProgress;
    private MutableLiveData<Boolean> mSleepTimerStarted;
    private MutableLiveData<Integer> mSleepTimerTime;
    private MutableLiveData<Integer> mSleepTimerProgress;
    private MutableLiveData<Boolean> mWaitPlayComplete;
    private MutableLiveData<Integer> mPlayPosition;
    private MutableLiveData<PlayMode> mPlayMode;
    private MutableLiveData<Float> mSpeed;
    private MutableLiveData<PlaybackState> mPlaybackState;
    private MutableLiveData<Boolean> mStalled;
    private MutableLiveData<Boolean> mConnected;
    private MutableLiveData<Boolean> mPreparing;
    private MutableLiveData<String> mErrorMessage;
    private MutableLiveData<MusicItem> mPlayingMusicItem;
    private MutableLiveData<Boolean> mPlayingNoStalled;
    private MutableLiveData<Float> mVolume;
    private Player.OnPlayingMusicItemChangeListener mPlayingMusicItemChangeListener;
    private Player.OnPlaylistChangeListener mPlaylistChangeListener;
    private Player.OnPlayModeChangeListener mPlayModeChangeListener;
    private Player.OnSpeedChangeListener mSpeedChangeListener;
    private PlayerClient.OnPlaybackStateChangeListener mClientPlaybackStateChangeListener;
    private Player.OnBufferedProgressChangeListener mBufferedProgressChangeListener;
    private SleepTimer.OnStateChangeListener mSleepTimerStateChangeListener;
    private SleepTimer.OnWaitPlayCompleteChangeListener mWaitPlayCompleteChangeListener;
    private Player.OnSeekCompleteListener mSeekCompleteListener;
    private Player.OnStalledChangeListener mStalledChangeListener;
    private Player.OnPrepareListener mPrepareListener;
    private PlayerClient.OnConnectStateChangeListener mConnectStateChangeListener;
    private Player.OnRepeatListener mRepeatListener;
    private Player.OnVolumeChaneListener mVolumeChaneListener;
    private String mDefaultTitle;
    private String mDefaultArtist;
    private String mDefaultAlbum;
    private ProgressClock mProgressClock;
    private ProgressClock mSleepTimerProgressClock;
    private boolean mInitialized;
    private boolean mCleared;
    private boolean mAutoDisconnect;

    public void init(@NonNull Context context, @NonNull PlayerClient playerClient) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)playerClient);
        this.init(context, playerClient, true);
    }

    public void init(@NonNull Context context, @NonNull PlayerClient playerClient, boolean enableProgressClock) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)playerClient);
        this.init(playerClient, context.getString(R.string.snow_music_item_unknown_title), context.getString(R.string.snow_music_item_unknown_artist), context.getString(R.string.snow_music_item_unknown_album), enableProgressClock);
    }

    public void init(@NonNull PlayerClient playerClient, @NonNull String defaultTitle, @NonNull String defaultArtist, @NonNull String defaultAlbum) {
        Preconditions.checkNotNull((Object)playerClient);
        Preconditions.checkNotNull((Object)defaultTitle);
        Preconditions.checkNotNull((Object)defaultArtist);
        Preconditions.checkNotNull((Object)defaultAlbum);
        this.init(playerClient, defaultTitle, defaultArtist, defaultAlbum, true);
    }

    public void init(@NonNull PlayerClient playerClient, @NonNull String defaultTitle, @NonNull String defaultArtist, @NonNull String defaultAlbum, boolean enableProgressClock) {
        Preconditions.checkNotNull((Object)playerClient);
        Preconditions.checkNotNull((Object)defaultTitle);
        Preconditions.checkNotNull((Object)defaultArtist);
        Preconditions.checkNotNull((Object)defaultAlbum);
        if (this.mInitialized) {
            throw new IllegalArgumentException("PlayerViewModel is initialized, please do not repeat initialization.");
        }
        if (this.mCleared) {
            throw new IllegalStateException("PlayerViewModel is cleared.");
        }
        this.mPlayerClient = playerClient;
        this.mDefaultTitle = defaultTitle;
        this.mDefaultArtist = defaultArtist;
        this.mDefaultAlbum = defaultAlbum;
        this.initAllLiveData();
        this.initAllListener();
        this.initAllProgressClock(enableProgressClock);
        this.addAllListener();
        this.mInitialized = true;
        this.onInitialized();
    }

    protected void onInitialized() {
    }

    public void setAutoDisconnect(boolean autoDisconnect) {
        this.mAutoDisconnect = autoDisconnect;
    }

    private void initAllListener() {
        this.mPlayingMusicItemChangeListener = new Player.OnPlayingMusicItemChangeListener(){

            @Override
            public void onPlayingMusicItemChanged(@Nullable MusicItem musicItem, int position, int playProgress) {
                PlayerViewModel.this.mProgressClock.cancel();
                PlayerViewModel.this.mPlayPosition.setValue((Object)position);
                PlayerViewModel.this.mPlayingMusicItem.setValue((Object)musicItem);
                if (musicItem == null) {
                    PlayerViewModel.this.mTitle.setValue((Object)PlayerViewModel.this.mDefaultTitle);
                    PlayerViewModel.this.mArtist.setValue((Object)PlayerViewModel.this.mDefaultArtist);
                    PlayerViewModel.this.mAlbum.setValue((Object)PlayerViewModel.this.mDefaultAlbum);
                    PlayerViewModel.this.mIconUri.setValue((Object)"");
                    PlayerViewModel.this.mDuration.setValue((Object)0);
                    PlayerViewModel.this.mPlayProgress.setValue((Object)0);
                    return;
                }
                PlayerViewModel.this.mTitle.setValue((Object)MusicItemUtil.getTitle(musicItem, PlayerViewModel.this.mDefaultTitle));
                PlayerViewModel.this.mArtist.setValue((Object)MusicItemUtil.getArtist(musicItem, PlayerViewModel.this.mDefaultArtist));
                PlayerViewModel.this.mAlbum.setValue((Object)MusicItemUtil.getAlbum(musicItem, PlayerViewModel.this.mDefaultAlbum));
                PlayerViewModel.this.mIconUri.setValue((Object)musicItem.getIconUri());
                PlayerViewModel.this.mPlayProgress.setValue((Object)(playProgress / 1000));
                PlayerViewModel.this.mDuration.setValue((Object)PlayerViewModel.this.getDurationSec());
            }
        };
        this.mPlaylistChangeListener = new Player.OnPlaylistChangeListener(){

            @Override
            public void onPlaylistChanged(PlaylistManager playlistManager, int position) {
                PlayerViewModel.this.mPlayPosition.setValue((Object)position);
            }
        };
        this.mPlayModeChangeListener = new Player.OnPlayModeChangeListener(){

            @Override
            public void onPlayModeChanged(PlayMode playMode) {
                PlayerViewModel.this.mPlayMode.setValue((Object)playMode);
            }
        };
        this.mSpeedChangeListener = new Player.OnSpeedChangeListener(){

            @Override
            public void onSpeedChanged(float speed, int playProgress, long playProgressUpdateTime) {
                PlayerViewModel.this.mSpeed.setValue((Object)Float.valueOf(speed));
                PlayerViewModel.this.mProgressClock.setSpeed(speed);
            }
        };
        this.mClientPlaybackStateChangeListener = new PlayerClient.OnPlaybackStateChangeListener(){

            @Override
            public void onPlaybackStateChanged(PlaybackState playbackState, boolean stalled) {
                if (playbackState == PlaybackState.ERROR) {
                    PlayerViewModel.this.mErrorMessage.setValue((Object)PlayerViewModel.this.mPlayerClient.getErrorMessage());
                } else {
                    PlayerViewModel.this.mErrorMessage.setValue((Object)"");
                }
                PlayerViewModel.this.mPlaybackState.setValue((Object)playbackState);
                PlayerViewModel.this.mPlayingNoStalled.setValue((Object)(playbackState == PlaybackState.PLAYING && !stalled ? 1 : 0));
                switch (playbackState) {
                    case PLAYING: {
                        if (stalled) {
                            return;
                        }
                        PlayerViewModel.this.mProgressClock.start(PlayerViewModel.this.mPlayerClient.getPlayProgress(), PlayerViewModel.this.mPlayerClient.getPlayProgressUpdateTime(), PlayerViewModel.this.mPlayerClient.getPlayingMusicItemDuration(), PlayerViewModel.this.mPlayerClient.getSpeed());
                        break;
                    }
                    case STOPPED: {
                        PlayerViewModel.this.mPreparing.setValue((Object)false);
                        PlayerViewModel.this.mPlayProgress.setValue((Object)0);
                        PlayerViewModel.this.mPreparing.setValue((Object)false);
                        PlayerViewModel.this.mProgressClock.cancel();
                        break;
                    }
                    case PAUSED: {
                        PlayerViewModel.this.mPlayProgress.setValue((Object)(PlayerViewModel.this.mPlayerClient.getPlayProgress() / 1000));
                        PlayerViewModel.this.mPreparing.setValue((Object)false);
                        PlayerViewModel.this.mProgressClock.cancel();
                        break;
                    }
                    case ERROR: {
                        PlayerViewModel.this.mPreparing.setValue((Object)false);
                        PlayerViewModel.this.mProgressClock.cancel();
                    }
                }
            }
        };
        this.mBufferedProgressChangeListener = new Player.OnBufferedProgressChangeListener(){

            @Override
            public void onBufferedProgressChanged(int bufferedProgress) {
                PlayerViewModel.this.mBufferedProgress.setValue((Object)PlayerViewModel.this.getBufferedProgressSec());
            }
        };
        this.mSleepTimerStateChangeListener = new SleepTimer.OnStateChangeListener(){

            @Override
            public void onTimerStart(long time, long startTime, SleepTimer.TimeoutAction action) {
                PlayerViewModel.this.mSleepTimerStarted.setValue((Object)true);
                PlayerViewModel.this.mSleepTimerTime.setValue((Object)((int)(time / 1000L)));
                PlayerViewModel.this.mSleepTimerProgressClock.start(0, startTime, (int)time);
            }

            @Override
            public void onTimerEnd() {
                PlayerViewModel.this.mSleepTimerStarted.setValue((Object)false);
                PlayerViewModel.this.mSleepTimerProgressClock.cancel();
                PlayerViewModel.this.mSleepTimerTime.setValue((Object)0);
                PlayerViewModel.this.mSleepTimerProgress.setValue((Object)0);
            }
        };
        this.mWaitPlayCompleteChangeListener = new SleepTimer.OnWaitPlayCompleteChangeListener(){

            @Override
            public void onWaitPlayCompleteChanged(boolean waitPlayComplete) {
                PlayerViewModel.this.mWaitPlayComplete.setValue((Object)waitPlayComplete);
            }
        };
        this.mSeekCompleteListener = new Player.OnSeekCompleteListener(){

            @Override
            public void onSeekComplete(int progress, long updateTime, boolean stalled) {
                PlayerViewModel.this.mPlayProgress.setValue((Object)(progress / 1000));
                if (PlaybackState.PLAYING == PlayerViewModel.this.mPlaybackState.getValue() && !stalled) {
                    PlayerViewModel.this.mProgressClock.start(progress, updateTime, PlayerViewModel.this.mPlayerClient.getPlayingMusicItemDuration(), PlayerViewModel.this.mPlayerClient.getSpeed());
                }
            }
        };
        this.mStalledChangeListener = new Player.OnStalledChangeListener(){

            @Override
            public void onStalledChanged(boolean stalled, int playProgress, long updateTime) {
                PlayerViewModel.this.mStalled.setValue((Object)stalled);
                PlayerViewModel.this.mPlayingNoStalled.setValue((Object)(PlayerViewModel.this.mPlayerClient.isPlaying() && !stalled ? 1 : 0));
                if (stalled) {
                    PlayerViewModel.this.mProgressClock.cancel();
                    return;
                }
                if (PlayerViewModel.this.mPlayerClient.isPlaying()) {
                    PlayerViewModel.this.mProgressClock.start(playProgress, updateTime, PlayerViewModel.this.mPlayerClient.getPlayingMusicItemDuration(), PlayerViewModel.this.mPlayerClient.getSpeed());
                }
            }
        };
        this.mPrepareListener = new Player.OnPrepareListener2(){

            @Override
            public void onPreparing() {
                PlayerViewModel.this.mPreparing.setValue((Object)true);
            }

            @Override
            public void onPrepared(int audioSessionId) {
            }

            @Override
            public void onPrepared(int audioSessionId, int duration) {
                PlayerViewModel.this.mPreparing.setValue((Object)false);
                MusicItem musicItem = PlayerViewModel.this.mPlayerClient.getPlayingMusicItem();
                assert (musicItem != null);
                if (musicItem.isAutoDuration()) {
                    PlayerViewModel.this.mPlayProgress.setValue((Object)PlayerViewModel.this.getPlayProgressSec());
                    PlayerViewModel.this.mDuration.setValue((Object)PlayerViewModel.this.getDurationSec());
                }
            }
        };
        this.mConnectStateChangeListener = new PlayerClient.OnConnectStateChangeListener(){

            @Override
            public void onConnectStateChanged(boolean connected) {
                PlayerViewModel.this.mConnected.setValue((Object)connected);
                if (PlayerViewModel.this.isInitialized() && !connected) {
                    PlayerViewModel.this.mProgressClock.cancel();
                    PlayerViewModel.this.mSleepTimerProgressClock.cancel();
                }
            }
        };
        this.mRepeatListener = new Player.OnRepeatListener(){

            @Override
            public void onRepeat(@NonNull MusicItem musicItem, long repeatTime) {
                PlayerViewModel.this.mProgressClock.start(0, repeatTime, musicItem.getDuration(), PlayerViewModel.this.mPlayerClient.getSpeed());
            }
        };
        this.mVolumeChaneListener = volume -> this.mVolume.setValue((Object)Float.valueOf(volume));
    }

    private void initAllProgressClock(boolean enable) {
        this.mProgressClock = new ProgressClock(new ProgressClock.Callback(){

            @Override
            public void onUpdateProgress(int progressSec, int durationSec) {
                PlayerViewModel.this.mPlayProgress.setValue((Object)progressSec);
            }
        });
        this.mProgressClock.setEnabled(enable);
        this.mSleepTimerProgressClock = new ProgressClock(true, new ProgressClock.Callback(){

            @Override
            public void onUpdateProgress(int progressSec, int durationSec) {
                PlayerViewModel.this.mSleepTimerProgress.setValue((Object)progressSec);
            }
        });
    }

    private void addAllListener() {
        this.mPlayerClient.addOnPlayingMusicItemChangeListener(this.mPlayingMusicItemChangeListener);
        this.mPlayerClient.addOnPlaylistChangeListener(this.mPlaylistChangeListener);
        this.mPlayerClient.addOnPlayModeChangeListener(this.mPlayModeChangeListener);
        this.mPlayerClient.addOnSpeedChangeListener(this.mSpeedChangeListener);
        this.mPlayerClient.addOnPlaybackStateChangeListener(this.mClientPlaybackStateChangeListener);
        this.mPlayerClient.addOnBufferedProgressChangeListener(this.mBufferedProgressChangeListener);
        this.mPlayerClient.addOnSleepTimerStateChangeListener(this.mSleepTimerStateChangeListener);
        this.mPlayerClient.addOnWaitPlayCompleteChangeListener(this.mWaitPlayCompleteChangeListener);
        this.mPlayerClient.addOnSeekCompleteListener(this.mSeekCompleteListener);
        this.mPlayerClient.addOnStalledChangeListener(this.mStalledChangeListener);
        this.mPlayerClient.addOnPrepareListener(this.mPrepareListener);
        this.mPlayerClient.addOnConnectStateChangeListener(this.mConnectStateChangeListener);
        this.mPlayerClient.addOnRepeatListener(this.mRepeatListener);
        this.mPlayerClient.addOnVolumeChangeListener(this.mVolumeChaneListener);
    }

    private void removeAllListener() {
        this.mPlayerClient.removeOnPlayingMusicItemChangeListener(this.mPlayingMusicItemChangeListener);
        this.mPlayerClient.removeOnPlaylistChangeListener(this.mPlaylistChangeListener);
        this.mPlayerClient.removeOnPlayModeChangeListener(this.mPlayModeChangeListener);
        this.mPlayerClient.removeOnSpeedChangeListener(this.mSpeedChangeListener);
        this.mPlayerClient.removeOnPlaybackStateChangeListener(this.mClientPlaybackStateChangeListener);
        this.mPlayerClient.removeOnBufferedProgressChangeListener(this.mBufferedProgressChangeListener);
        this.mPlayerClient.removeOnSleepTimerStateChangeListener(this.mSleepTimerStateChangeListener);
        this.mPlayerClient.removeOnWaitPlayCompleteChangeListener(this.mWaitPlayCompleteChangeListener);
        this.mPlayerClient.removeOnSeekCompleteListener(this.mSeekCompleteListener);
        this.mPlayerClient.removeOnStalledChangeListener(this.mStalledChangeListener);
        this.mPlayerClient.removeOnPrepareListener(this.mPrepareListener);
        this.mPlayerClient.removeOnConnectStateChangeListener(this.mConnectStateChangeListener);
        this.mPlayerClient.removeOnRepeatListener(this.mRepeatListener);
        this.mPlayerClient.removeOnVolumeChangeListener(this.mVolumeChaneListener);
    }

    protected void onCleared() {
        super.onCleared();
        this.mCleared = true;
        if (!this.mInitialized) {
            return;
        }
        this.mProgressClock.cancel();
        this.mSleepTimerProgressClock.cancel();
        this.removeAllListener();
        if (this.mAutoDisconnect) {
            this.mPlayerClient.disconnect();
        }
        this.mPlayerClient = null;
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    @NonNull
    public PlayerClient getPlayerClient() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mPlayerClient;
    }

    @NonNull
    public LiveData<String> getTitle() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mTitle;
    }

    @NonNull
    public LiveData<String> getArtist() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mArtist;
    }

    @NonNull
    public LiveData<String> getAlbum() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mAlbum;
    }

    @NonNull
    public LiveData<String> getIconUri() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mIconUri;
    }

    @NonNull
    public LiveData<Integer> getDuration() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mDuration;
    }

    @NonNull
    public MutableLiveData<Integer> getPlayProgress() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mPlayProgress;
    }

    @NonNull
    public LiveData<Integer> getBufferedProgress() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mBufferedProgress;
    }

    @NonNull
    public LiveData<Integer> getPlayPosition() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mPlayPosition;
    }

    @NonNull
    public LiveData<PlayMode> getPlayMode() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mPlayMode;
    }

    public LiveData<Float> getSpeed() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mSpeed;
    }

    @NonNull
    public LiveData<PlaybackState> getPlaybackState() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mPlaybackState;
    }

    @NonNull
    public LiveData<Boolean> getStalled() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mStalled;
    }

    public LiveData<Boolean> getConnected() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mConnected;
    }

    public LiveData<Boolean> getPreparing() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mPreparing;
    }

    @NonNull
    public LiveData<Boolean> isError() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return Transformations.map(this.mPlaybackState, playbackState -> playbackState == PlaybackState.ERROR);
    }

    @NonNull
    public LiveData<String> getErrorMessage() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mErrorMessage;
    }

    @NonNull
    public LiveData<MusicItem> getPlayingMusicItem() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mPlayingMusicItem;
    }

    @NonNull
    public LiveData<Boolean> getPlayingNoStalled() {
        return this.mPlayingNoStalled;
    }

    @NonNull
    public LiveData<String> getTextDuration() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return Transformations.map(this.mDuration, ProgressClock::asText);
    }

    @NonNull
    public LiveData<String> getTextPlayProgress() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return Transformations.map(this.mPlayProgress, ProgressClock::asText);
    }

    @NonNull
    public LiveData<Boolean> getSleepTimerStarted() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mSleepTimerStarted;
    }

    @NonNull
    public LiveData<Integer> getSleepTimerTime() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mSleepTimerTime;
    }

    @NonNull
    public LiveData<String> getTextSleepTimerTime() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return Transformations.map(this.mSleepTimerTime, ProgressClock::asText);
    }

    @NonNull
    public LiveData<Integer> getSleepTimerProgress() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mSleepTimerProgress;
    }

    @NonNull
    public LiveData<Boolean> getWaitPlayComplete() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mWaitPlayComplete;
    }

    @NonNull
    public LiveData<String> getTextSleepTimerProgress() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return Transformations.map(this.mSleepTimerProgress, ProgressClock::asText);
    }

    public LiveData<Float> getVolume() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("PlayerViewModel not initialized yet.");
        }
        return this.mVolume;
    }

    public void setPlaylist(Playlist playlist) {
        if (this.isInitialized()) {
            this.mPlayerClient.setPlaylist(playlist);
        }
    }

    public void setPlaylist(Playlist playlist, boolean play) {
        if (this.isInitialized()) {
            this.mPlayerClient.setPlaylist(playlist, play);
        }
    }

    public void setPlaylist(Playlist playlist, int position, boolean play) {
        if (this.isInitialized()) {
            this.mPlayerClient.setPlaylist(playlist, position, play);
        }
    }

    public void play() {
        if (this.isInitialized()) {
            this.mPlayerClient.play();
        }
    }

    public void pause() {
        if (this.isInitialized()) {
            this.mPlayerClient.pause();
        }
    }

    public void playPause() {
        if (this.isInitialized()) {
            this.mPlayerClient.playPause();
        }
    }

    public void playPause(int position) {
        if (this.isInitialized()) {
            this.mPlayerClient.playPause(position);
        }
    }

    public void stop() {
        if (this.isInitialized()) {
            this.mPlayerClient.stop();
        }
    }

    public void skipToPrevious() {
        if (this.isInitialized()) {
            this.mPlayerClient.skipToPrevious();
        }
    }

    public void skipToNext() {
        if (this.isInitialized()) {
            this.mPlayerClient.skipToNext();
        }
    }

    public void skipToPosition(int position) {
        if (this.isInitialized()) {
            this.mPlayerClient.skipToPosition(position);
        }
    }

    public void fastForward() {
        if (this.isInitialized()) {
            this.mPlayerClient.fastForward();
        }
    }

    public void rewind() {
        if (this.isInitialized()) {
            this.mPlayerClient.rewind();
        }
    }

    public void setNextPlay(@NonNull MusicItem musicItem) {
        Preconditions.checkNotNull((Object)musicItem);
        if (this.isInitialized()) {
            this.mPlayerClient.setNextPlay(musicItem);
        }
    }

    public void setPlayMode(@NonNull PlayMode playMode) {
        Preconditions.checkNotNull((Object)((Object)playMode));
        if (this.isInitialized()) {
            this.mPlayerClient.setPlayMode(playMode);
        }
    }

    public void setSpeed(float speed) {
        if (this.isInitialized()) {
            this.mPlayerClient.setSpeed(speed);
            this.mProgressClock.setSpeed(speed);
        }
    }

    public void seekTo(int progress) {
        if (this.isInitialized()) {
            this.mProgressClock.cancel();
            this.mPlayerClient.seekTo(progress);
        }
    }

    public void setVolume(float volume) {
        if (this.isInitialized()) {
            this.mPlayerClient.setVolume(volume);
        }
    }

    public void cancelProgressClock() {
        if (this.isInitialized()) {
            this.mProgressClock.cancel();
        }
    }

    public void startSleepTimer(long time) throws IllegalArgumentException {
        if (this.isInitialized()) {
            this.mPlayerClient.startSleepTimer(time);
        }
    }

    public void startSleepTimer(long time, SleepTimer.TimeoutAction action) throws IllegalArgumentException {
        if (this.isInitialized()) {
            this.mPlayerClient.startSleepTimer(time, action);
        }
    }

    public void cancelSleepTimer() {
        if (this.isInitialized()) {
            this.mPlayerClient.cancelSleepTimer();
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.cancelProgressClock();
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (!this.isInitialized()) {
            return;
        }
        if (this.mPlayerClient.isForbidSeek()) {
            this.restorePlayProgress();
            return;
        }
        this.seekTo(seekBar.getProgress() * 1000);
    }

    public void setWaitPlayComplete(boolean waitPlayComplete) {
        if (!this.isInitialized()) {
            return;
        }
        this.mPlayerClient.setWaitPlayComplete(waitPlayComplete);
    }

    private void restorePlayProgress() {
        if (!this.mPlayerClient.isPlaying() || this.mPlayerClient.isStalled()) {
            this.mPlayProgress.setValue((Object)(this.mPlayerClient.getPlayProgress() / 1000));
            return;
        }
        this.mProgressClock.start(this.mPlayerClient.getPlayProgress(), this.mPlayerClient.getPlayProgressUpdateTime(), this.mPlayerClient.getPlayingMusicItemDuration(), this.mPlayerClient.getSpeed());
    }

    private void initAllLiveData() {
        this.mTitle = new MutableLiveData((Object)this.mDefaultTitle);
        this.mArtist = new MutableLiveData((Object)this.mDefaultArtist);
        this.mAlbum = new MutableLiveData((Object)this.mDefaultAlbum);
        this.mIconUri = new MutableLiveData((Object)this.getIconUri(this.mPlayerClient));
        this.mDuration = new MutableLiveData((Object)this.getDurationSec());
        this.mPlayProgress = new MutableLiveData((Object)this.getPlayProgressSec());
        this.mBufferedProgress = new MutableLiveData((Object)this.getBufferedProgressSec());
        this.mSleepTimerStarted = new MutableLiveData((Object)this.mPlayerClient.isSleepTimerStarted());
        this.mSleepTimerTime = new MutableLiveData((Object)((int)(this.mPlayerClient.getSleepTimerTime() / 1000L)));
        this.mSleepTimerProgress = new MutableLiveData((Object)((int)(this.mPlayerClient.getSleepTimerElapsedTime() / 1000L)));
        this.mPlayPosition = new MutableLiveData((Object)this.mPlayerClient.getPlayPosition());
        this.mPlayMode = new MutableLiveData((Object)this.mPlayerClient.getPlayMode());
        this.mSpeed = new MutableLiveData((Object)Float.valueOf(this.mPlayerClient.getSpeed()));
        this.mPlaybackState = new MutableLiveData((Object)this.mPlayerClient.getPlaybackState());
        this.mStalled = new MutableLiveData((Object)this.mPlayerClient.isStalled());
        this.mConnected = new MutableLiveData((Object)this.mPlayerClient.isConnected());
        this.mPreparing = new MutableLiveData((Object)this.mPlayerClient.isPreparing());
        this.mErrorMessage = new MutableLiveData((Object)this.mPlayerClient.getErrorMessage());
        this.mPlayingMusicItem = new MutableLiveData((Object)this.mPlayerClient.getPlayingMusicItem());
        this.mPlayingNoStalled = new MutableLiveData((Object)(this.mPlayerClient.isPlaying() && !this.mPlayerClient.isStalled() ? 1 : 0));
        this.mWaitPlayComplete = new MutableLiveData((Object)this.mPlayerClient.isWaitPlayComplete());
        this.mVolume = new MutableLiveData((Object)Float.valueOf(this.mPlayerClient.getVolume()));
    }

    private int getDurationSec() {
        return this.mPlayerClient.getPlayingMusicItemDuration() / 1000;
    }

    private int getPlayProgressSec() {
        if (this.mPlayerClient.isPlaying()) {
            long realProgress = (long)this.mPlayerClient.getPlayProgress() + (SystemClock.elapsedRealtime() - this.mPlayerClient.getPlayProgressUpdateTime());
            return (int)(realProgress / 1000L);
        }
        return this.mPlayerClient.getPlayProgress() / 1000;
    }

    private int getBufferedProgressSec() {
        return this.mPlayerClient.getBufferedProgress() / 1000;
    }

    private String getIconUri(PlayerClient playerClient) {
        MusicItem musicItem = playerClient.getPlayingMusicItem();
        if (musicItem == null) {
            return "";
        }
        return musicItem.getIconUri();
    }
}

