/*
 * Decompiled with CFR 0.152.
 */
package snow.player.audio;

import android.content.Context;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.common.base.Preconditions;
import java.net.HttpCookie;
import java.util.List;
import java.util.Map;
import snow.player.audio.MusicPlayer;

public class MediaMusicPlayer
implements MusicPlayer {
    private static final String TAG = "MediaMusicPlayer";
    private final Context mContext;
    private final Uri mUri;
    private final Map<String, String> mHeaders;
    private List<HttpCookie> mCookies;
    private MediaPlayer mMediaPlayer;
    @Nullable
    private MusicPlayer.OnErrorListener mErrorListener;
    @Nullable
    private MusicPlayer.OnStalledListener mStalledListener;
    @Nullable
    private MusicPlayer.OnRepeatListener mRepeatListener;
    @Nullable
    private MusicPlayer.OnCompletionListener mCompletionListener;
    private boolean mStalled;
    private boolean mInvalid;
    private boolean mLooping;
    private float mVolume = 1.0f;

    public MediaMusicPlayer(@NonNull Context context, @NonNull Uri uri) {
        this(context, uri, null);
    }

    public MediaMusicPlayer(@NonNull Context context, @NonNull Uri uri, @Nullable Map<String, String> headers) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)uri);
        this.mContext = context;
        this.mUri = uri;
        this.mHeaders = headers;
        this.mMediaPlayer = new MediaPlayer();
        this.mInvalid = false;
        this.mMediaPlayer.setWakeMode(context, 1);
        this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                Log.e((String)MediaMusicPlayer.TAG, (String)("MediaPlayer Error[what: " + what + ", extra: " + extra + "]"));
                MediaMusicPlayer.this.setInvalid();
                if (MediaMusicPlayer.this.mErrorListener != null) {
                    MediaMusicPlayer.this.mErrorListener.onError(MediaMusicPlayer.this, MediaMusicPlayer.this.toErrorCode(what, extra));
                }
                return true;
            }
        });
        this.mMediaPlayer.setOnInfoListener(new MediaPlayer.OnInfoListener(){

            public boolean onInfo(MediaPlayer mp, int what, int extra) {
                switch (what) {
                    case 701: {
                        MediaMusicPlayer.this.setStalled(true);
                        return true;
                    }
                    case 702: {
                        MediaMusicPlayer.this.setStalled(false);
                        return true;
                    }
                }
                return false;
            }
        });
        this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                if (MediaMusicPlayer.this.mLooping) {
                    mp.start();
                    MediaMusicPlayer.this.notifyOnRepeat();
                    return;
                }
                MediaMusicPlayer.this.notifyOnComplete();
            }
        });
    }

    private void notifyOnRepeat() {
        if (this.mRepeatListener != null) {
            this.mRepeatListener.onRepeat(this);
        }
    }

    private void notifyOnComplete() {
        if (this.mCompletionListener != null) {
            this.mCompletionListener.onCompletion(this);
        }
    }

    @RequiresApi(value=26)
    public MediaMusicPlayer(@NonNull Context context, @NonNull Uri uri, @Nullable Map<String, String> headers, @Nullable List<HttpCookie> cookies) {
        this(context, uri, headers);
        this.mCookies = cookies;
    }

    private int toErrorCode(int what, int extra) {
        if (Build.VERSION.SDK_INT < 17) {
            switch (what) {
                case 1: {
                    return 8;
                }
                case 100: {
                    return 2;
                }
            }
        }
        switch (extra) {
            case -1004: 
            case -110: {
                return 5;
            }
            case -2147483648: 
            case -1010: 
            case -1007: {
                return 2;
            }
        }
        return 8;
    }

    private void setStalled(boolean stalled) {
        this.mStalled = stalled;
        if (this.mStalledListener != null) {
            this.mStalledListener.onStalled(this.mStalled);
        }
    }

    @Override
    public void prepare() throws Exception {
        if (this.isInvalid()) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mMediaPlayer.setDataSource(this.mContext, this.mUri, this.mHeaders, this.mCookies);
            } else {
                this.mMediaPlayer.setDataSource(this.mContext, this.mUri, this.mHeaders);
            }
            this.mMediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            this.setInvalid();
            throw e;
        }
    }

    @Override
    public void setLooping(boolean looping) {
        if (this.isInvalid()) {
            return;
        }
        this.mLooping = looping;
    }

    @Override
    public boolean isLooping() {
        return this.mMediaPlayer.isLooping();
    }

    @Override
    public boolean isStalled() {
        return this.mStalled;
    }

    @Override
    public boolean isPlaying() {
        return this.mMediaPlayer.isPlaying();
    }

    @Override
    public int getDuration() {
        return this.mMediaPlayer.getDuration();
    }

    @Override
    public int getProgress() {
        return this.mMediaPlayer.getCurrentPosition();
    }

    @Override
    public void start() {
        if (this.isInvalid()) {
            return;
        }
        this.mMediaPlayer.start();
    }

    @Override
    public void pause() {
        if (this.isInvalid()) {
            return;
        }
        this.mMediaPlayer.pause();
    }

    @Override
    public void stop() {
        if (this.isInvalid()) {
            return;
        }
        this.mMediaPlayer.stop();
    }

    @Override
    public void quiet() {
        if (this.isInvalid()) {
            return;
        }
        float volume = this.mVolume * 0.5f;
        this.mMediaPlayer.setVolume(volume, volume);
    }

    @Override
    public void dismissQuiet() {
        if (this.isInvalid()) {
            return;
        }
        this.mMediaPlayer.setVolume(this.mVolume, this.mVolume);
    }

    @Override
    public void release() {
        this.setInvalid();
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
        }
    }

    @Override
    public void seekTo(int pos) {
        if (this.isInvalid()) {
            return;
        }
        this.mMediaPlayer.seekTo(pos);
    }

    @Override
    public void setVolume(float volume) {
        if (this.isInvalid()) {
            return;
        }
        this.mVolume = volume;
        this.mMediaPlayer.setVolume(volume, volume);
    }

    @Override
    public float getVolume() {
        return this.mVolume;
    }

    @Override
    public void setSpeed(float speed) {
        if (this.isInvalid()) {
            return;
        }
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        PlaybackParams playbackParams = this.mMediaPlayer.getPlaybackParams();
        playbackParams.setSpeed(speed);
        this.mMediaPlayer.setPlaybackParams(playbackParams);
    }

    @Override
    public synchronized boolean isInvalid() {
        return this.mInvalid;
    }

    private synchronized void setInvalid() {
        this.mInvalid = true;
    }

    @Override
    public int getAudioSessionId() {
        return this.mMediaPlayer.getAudioSessionId();
    }

    @Override
    public void setOnPreparedListener(final @Nullable MusicPlayer.OnPreparedListener listener) {
        if (listener == null) {
            this.mMediaPlayer.setOnPreparedListener(null);
            return;
        }
        this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                listener.onPrepared(MediaMusicPlayer.this);
            }
        });
    }

    @Override
    public void setOnCompletionListener(@Nullable MusicPlayer.OnCompletionListener listener) {
        this.mCompletionListener = listener;
    }

    @Override
    public void setOnRepeatListener(@Nullable MusicPlayer.OnRepeatListener listener) {
        this.mRepeatListener = listener;
    }

    @Override
    public void setOnSeekCompleteListener(final @Nullable MusicPlayer.OnSeekCompleteListener listener) {
        if (listener == null) {
            this.mMediaPlayer.setOnSeekCompleteListener(null);
            return;
        }
        this.mMediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

            public void onSeekComplete(MediaPlayer mp) {
                listener.onSeekComplete(MediaMusicPlayer.this);
            }
        });
    }

    @Override
    public void setOnStalledListener(@Nullable MusicPlayer.OnStalledListener listener) {
        this.mStalledListener = listener;
    }

    @Override
    public void setOnBufferingUpdateListener(final @Nullable MusicPlayer.OnBufferingUpdateListener listener) {
        if (listener == null) {
            this.mMediaPlayer.setOnBufferingUpdateListener(null);
            return;
        }
        this.mMediaPlayer.setOnBufferingUpdateListener(new MediaPlayer.OnBufferingUpdateListener(){

            public void onBufferingUpdate(MediaPlayer mp, int percent) {
                listener.onBufferingUpdate(MediaMusicPlayer.this, percent, true);
            }
        });
    }

    @Override
    public void setOnErrorListener(@Nullable MusicPlayer.OnErrorListener listener) {
        this.mErrorListener = listener;
    }
}

