/*
 * Decompiled with CFR 0.152.
 */
package snow.player.audio;

import android.content.Context;
import android.content.res.Resources;
import snow.player.R;

public final class ErrorCode {
    public static final int NO_ERROR = 0;
    public static final int ONLY_WIFI_NETWORK = 1;
    public static final int PLAYER_ERROR = 2;
    public static final int NETWORK_ERROR = 3;
    public static final int FILE_NOT_FOUND = 4;
    public static final int DATA_LOAD_FAILED = 5;
    public static final int GET_URL_FAILED = 6;
    public static final int OUT_OF_MEMORY = 7;
    public static final int UNKNOWN_ERROR = 8;
    public static final int PREPARE_MUSIC_ITEM_ERROR = 9;
    public static final int PLAY_POSITION_OUT_OF_BOUNDS = 10;

    private ErrorCode() {
        throw new AssertionError();
    }

    public static String getErrorMessage(Context context, int errorCode) {
        Resources res = context.getResources();
        switch (errorCode) {
            case 0: {
                return res.getString(R.string.snow_error_no_error);
            }
            case 1: {
                return res.getString(R.string.snow_error_only_wifi_network);
            }
            case 2: {
                return res.getString(R.string.snow_error_player_error);
            }
            case 3: {
                return res.getString(R.string.snow_error_network_error);
            }
            case 4: {
                return res.getString(R.string.snow_error_file_not_found);
            }
            case 5: {
                return res.getString(R.string.snow_error_data_load_failed);
            }
            case 6: {
                return res.getString(R.string.snow_error_get_url_failed);
            }
            case 7: {
                return res.getString(R.string.snow_error_out_of_memory);
            }
            case 9: {
                return res.getString(R.string.snow_error_prepare_music_item_failed);
            }
            case 10: {
                return res.getString(R.string.snow_error_play_position_out_of_bounds);
            }
        }
        return res.getString(R.string.snow_error_unknown_error);
    }
}

