/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import android.os.SystemClock;
import com.google.common.base.Preconditions;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;
import snow.player.PlayerService;
import snow.player.PlayerState;
import snow.player.PlayerStateHelper;
import snow.player.ServicePlayerStateHelper;
import snow.player.SleepTimer;

class SleepTimerImp
implements SleepTimer {
    private final PlayerService mPlayerService;
    private final PlayerState mPlayerState;
    private final SleepTimer.OnStateChangeListener2 mSleepTimerStateChangedListener;
    private final SleepTimer.OnWaitPlayCompleteChangeListener mWaitPlayCompleteChangeListener;
    private final PlayerStateHelper mPlayerStateHelper;
    private Disposable mSleepTimerDisposable;

    SleepTimerImp(PlayerService playerService, PlayerState playerState, ServicePlayerStateHelper playerStateHelper, SleepTimer.OnStateChangeListener2 onStateChangeListener2, SleepTimer.OnWaitPlayCompleteChangeListener onWaitPlayCompleteChangeListener) {
        this.mPlayerService = playerService;
        this.mPlayerState = playerState;
        this.mSleepTimerStateChangedListener = onStateChangeListener2;
        this.mWaitPlayCompleteChangeListener = onWaitPlayCompleteChangeListener;
        this.mPlayerStateHelper = playerStateHelper;
    }

    @Override
    public void startSleepTimer(long time, SleepTimer.TimeoutAction action) {
        if (time < 0L) {
            throw new IllegalArgumentException("time must >= 0");
        }
        Preconditions.checkNotNull((Object)((Object)action));
        this.disposeLastSleepTimer();
        if (this.mPlayerService.getPlayingMusicItem() == null) {
            return;
        }
        if (time == 0L) {
            this.onTimeout();
            return;
        }
        this.mSleepTimerDisposable = Observable.timer((long)time, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) {
                SleepTimerImp.this.onTimeout();
            }
        });
        long startTime = SystemClock.elapsedRealtime();
        this.mPlayerStateHelper.onSleepTimerStart(time, startTime, action);
        this.mSleepTimerStateChangedListener.onTimerStart(time, startTime, action, this.mPlayerState.isWaitPlayComplete());
    }

    @Override
    public void cancelSleepTimer() {
        this.disposeLastSleepTimer();
        this.mPlayerStateHelper.onSleepTimerEnd();
        this.mSleepTimerStateChangedListener.onTimerEnd();
    }

    @Override
    public void setWaitPlayComplete(boolean waitPlayComplete) {
        if (waitPlayComplete == this.mPlayerState.isWaitPlayComplete()) {
            return;
        }
        this.mPlayerStateHelper.onWaitPlayCompleteChanged(waitPlayComplete);
        this.mWaitPlayCompleteChangeListener.onWaitPlayCompleteChanged(waitPlayComplete);
        if (!waitPlayComplete && this.mPlayerState.isSleepTimerStarted() && this.mPlayerState.isSleepTimerTimeout() && !this.mPlayerState.isSleepTimerEnd()) {
            this.cancelSleepTimer();
        }
    }

    private void onTimeout() {
        if (this.mPlayerState.isWaitPlayComplete() && this.mPlayerService.isPlaying()) {
            this.mPlayerStateHelper.onSleepTimerTimeout(false);
            this.mSleepTimerStateChangedListener.onTimeout(false);
            return;
        }
        this.doAction();
        this.mPlayerStateHelper.onSleepTimerTimeout(true);
        this.mSleepTimerStateChangedListener.onTimeout(true);
        this.mSleepTimerStateChangedListener.onTimerEnd();
    }

    public void performAction() {
        if (this.mPlayerState.isSleepTimerEnd()) {
            return;
        }
        this.doAction();
        this.mSleepTimerStateChangedListener.onTimerEnd();
    }

    private void doAction() {
        switch (this.mPlayerState.getTimeoutAction()) {
            case PAUSE: {
                this.mPlayerService.getPlayer().pause();
                break;
            }
            case STOP: {
                this.mPlayerService.getPlayer().stop();
                break;
            }
            case SHUTDOWN: {
                this.mPlayerService.shutdown();
            }
        }
        this.mPlayerStateHelper.onSleepTimerEnd();
    }

    private void disposeLastSleepTimer() {
        if (this.mSleepTimerDisposable == null || this.mSleepTimerDisposable.isDisposed()) {
            return;
        }
        this.mSleepTimerDisposable.dispose();
    }
}

