/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import com.tencent.mmkv.MMKV;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import snow.player.playlist.Playlist;
import snow.player.playlist.PlaylistManager;

class PlaylistManagerImp
implements PlaylistManager {
    private static final String KEY_PLAYLIST = "playlist";
    private static final String KEY_PLAYLIST_SIZE = "playlist_size";
    private static final String KEY_NAME = "name";
    private static final String KEY_TOKEN = "token";
    private static final String KEY_EDITABLE = "editable";
    private static final String KEY_LAST_MODIFIED = "last_modified";
    private final MMKV mMMKV;
    private Disposable mSaveDisposable;

    PlaylistManagerImp(@NonNull Context context, @NonNull String playlistId) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)playlistId);
        MMKV.initialize((Context)context);
        this.mMMKV = MMKV.mmkvWithID((String)("PlaylistManager:" + playlistId), (int)2);
    }

    @Override
    @NonNull
    public String getPlaylistName() {
        return this.mMMKV.decodeString(KEY_NAME, "");
    }

    @Override
    public int getPlaylistSize() {
        return this.mMMKV.decodeInt(KEY_PLAYLIST_SIZE, 0);
    }

    @Override
    @NonNull
    public String getPlaylistToken() {
        return this.mMMKV.decodeString(KEY_TOKEN, "");
    }

    @Override
    public boolean isPlaylistEditable() {
        return this.mMMKV.decodeBool(KEY_EDITABLE, true);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void getPlaylist(final @NonNull PlaylistManager.Callback callback) {
        Single.create((SingleOnSubscribe)new SingleOnSubscribe<Playlist>(){

            public void subscribe(SingleEmitter<Playlist> emitter) {
                Playlist playlist = (Playlist)PlaylistManagerImp.this.mMMKV.decodeParcelable(PlaylistManagerImp.KEY_PLAYLIST, Playlist.class);
                if (playlist == null) {
                    playlist = new Playlist.Builder().build();
                }
                emitter.onSuccess((Object)playlist);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Playlist>(){

            public void accept(Playlist playlist) {
                callback.onFinished(playlist);
            }
        });
    }

    @Override
    public long getLastModified() {
        return this.mMMKV.decodeLong(KEY_LAST_MODIFIED, System.currentTimeMillis());
    }

    public void save(final @NonNull Playlist playlist, final @Nullable Runnable doOnSaved) {
        Preconditions.checkNotNull((Object)playlist);
        this.disposeLastSave();
        this.mSaveDisposable = Single.create((SingleOnSubscribe)new SingleOnSubscribe<Boolean>(){

            public void subscribe(SingleEmitter<Boolean> emitter) {
                if (emitter.isDisposed()) {
                    return;
                }
                PlaylistManagerImp.this.mMMKV.encode(PlaylistManagerImp.KEY_PLAYLIST, (Parcelable)playlist);
                PlaylistManagerImp.this.mMMKV.encode(PlaylistManagerImp.KEY_PLAYLIST_SIZE, playlist.size());
                PlaylistManagerImp.this.mMMKV.encode(PlaylistManagerImp.KEY_NAME, playlist.getName());
                PlaylistManagerImp.this.mMMKV.encode(PlaylistManagerImp.KEY_TOKEN, playlist.getToken());
                PlaylistManagerImp.this.mMMKV.encode(PlaylistManagerImp.KEY_EDITABLE, playlist.isEditable());
                PlaylistManagerImp.this.mMMKV.encode(PlaylistManagerImp.KEY_LAST_MODIFIED, System.currentTimeMillis());
                if (emitter.isDisposed()) {
                    return;
                }
                emitter.onSuccess((Object)true);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean aBoolean) {
                if (doOnSaved != null) {
                    doOnSaved.run();
                }
            }
        });
    }

    private void disposeLastSave() {
        if (this.mSaveDisposable != null && !this.mSaveDisposable.isDisposed()) {
            this.mSaveDisposable.dispose();
        }
    }
}

