/*
 * Decompiled with CFR 0.152.
 */
package snow.player;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import snow.player.PlayMode;
import snow.player.Player;

public final class Player__ChannelHelper {
    private static final String KEY_CLASS_NAME = "__class_name";
    private static final String KEY_METHOD_ID = "__method_id";
    private static final String CLASS_NAME = "snow.player.Player";
    private static final int METHOD_ID_1 = 1;
    private static final int METHOD_ID_2 = 2;
    private static final int METHOD_ID_3 = 3;
    private static final int METHOD_ID_4 = 4;
    private static final int METHOD_ID_5 = 5;
    private static final int METHOD_ID_6 = 6;
    private static final int METHOD_ID_7 = 7;
    private static final int METHOD_ID_8 = 8;
    private static final int METHOD_ID_9 = 9;
    private static final int METHOD_ID_10 = 10;
    private static final int METHOD_ID_11 = 11;
    private static final int METHOD_ID_12 = 12;
    private static final int METHOD_ID_13 = 13;
    private static final int METHOD_ID_14 = 14;

    private Player__ChannelHelper() {
        throw new AssertionError();
    }

    public static final class Dispatcher
    implements channel.helper.Dispatcher {
        private final WeakReference<Player> callbackWeakReference;

        public Dispatcher(Player callback) {
            this.callbackWeakReference = new WeakReference<Player>(callback);
        }

        public boolean match(Map<String, Object> data) {
            return Player__ChannelHelper.CLASS_NAME.equals(data.get(Player__ChannelHelper.KEY_CLASS_NAME));
        }

        public boolean dispatch(Map<String, Object> data) {
            if (!this.match(data)) {
                return false;
            }
            int methodId = (Integer)data.get(Player__ChannelHelper.KEY_METHOD_ID);
            Player callback = (Player)this.callbackWeakReference.get();
            if (callback == null) {
                return false;
            }
            switch (methodId) {
                case 1: {
                    callback.play();
                    return true;
                }
                case 2: {
                    callback.pause();
                    return true;
                }
                case 3: {
                    callback.stop();
                    return true;
                }
                case 4: {
                    callback.playPause();
                    return true;
                }
                case 5: {
                    int METHOD_ID_5_progress = (Integer)data.get("progress");
                    callback.seekTo(METHOD_ID_5_progress);
                    return true;
                }
                case 6: {
                    callback.fastForward();
                    return true;
                }
                case 7: {
                    callback.rewind();
                    return true;
                }
                case 8: {
                    callback.skipToNext();
                    return true;
                }
                case 9: {
                    callback.skipToPrevious();
                    return true;
                }
                case 10: {
                    int METHOD_ID_10_position = (Integer)data.get("position");
                    callback.skipToPosition(METHOD_ID_10_position);
                    return true;
                }
                case 11: {
                    int METHOD_ID_11_position = (Integer)data.get("position");
                    callback.playPause(METHOD_ID_11_position);
                    return true;
                }
                case 12: {
                    PlayMode METHOD_ID_12_playMode = PlayMode.values()[(Integer)data.get("playMode")];
                    callback.setPlayMode(METHOD_ID_12_playMode);
                    return true;
                }
                case 13: {
                    float METHOD_ID_13_speed = ((Float)data.get("speed")).floatValue();
                    callback.setSpeed(METHOD_ID_13_speed);
                    return true;
                }
                case 14: {
                    float METHOD_ID_14_volume = ((Float)data.get("volume")).floatValue();
                    callback.setVolume(METHOD_ID_14_volume);
                    return true;
                }
            }
            return false;
        }
    }

    public static final class Emitter
    implements Player {
        private channel.helper.Emitter emitter;

        public Emitter(channel.helper.Emitter emitter) {
            this.emitter = emitter;
        }

        private void sendMessage(int id, Map<String, Object> args) {
            args.put(Player__ChannelHelper.KEY_CLASS_NAME, Player__ChannelHelper.CLASS_NAME);
            args.put(Player__ChannelHelper.KEY_METHOD_ID, id);
            this.emitter.emit(args);
        }

        @Override
        public void play() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(1, args);
        }

        @Override
        public void pause() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(2, args);
        }

        @Override
        public void stop() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(3, args);
        }

        @Override
        public void playPause() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(4, args);
        }

        @Override
        public void seekTo(int progress) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("progress", progress);
            this.sendMessage(5, args);
        }

        @Override
        public void fastForward() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(6, args);
        }

        @Override
        public void rewind() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(7, args);
        }

        @Override
        public void skipToNext() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(8, args);
        }

        @Override
        public void skipToPrevious() {
            HashMap<String, Object> args = new HashMap<String, Object>();
            this.sendMessage(9, args);
        }

        @Override
        public void skipToPosition(int position) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("position", position);
            this.sendMessage(10, args);
        }

        @Override
        public void playPause(int position) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("position", position);
            this.sendMessage(11, args);
        }

        @Override
        public void setPlayMode(PlayMode playMode) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("playMode", playMode.ordinal());
            this.sendMessage(12, args);
        }

        @Override
        public void setSpeed(float speed) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("speed", Float.valueOf(speed));
            this.sendMessage(13, args);
        }

        @Override
        public void setVolume(float volume) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("volume", Float.valueOf(volume));
            this.sendMessage(14, args);
        }
    }
}

